// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The InterruptAudioAndAnnounceRequest model.
 */
@Fluent
public final class InterruptAudioAndAnnounceRequest implements JsonSerializable<InterruptAudioAndAnnounceRequest> {
    /*
     * The source of the audio to be played.
     */
    private List<PlaySourceInternal> playSources;

    /*
     * The list of call participants play provided audio to.
     * Plays to everyone in the call when not provided.
     */
    private CommunicationIdentifierModel playTo;

    /*
     * The value to identify context of the operation.
     */
    private String operationContext;

    /**
     * Creates an instance of InterruptAudioAndAnnounceRequest class.
     */
    public InterruptAudioAndAnnounceRequest() {
    }

    /**
     * Get the playSources property: The source of the audio to be played.
     * 
     * @return the playSources value.
     */
    public List<PlaySourceInternal> getPlaySources() {
        return this.playSources;
    }

    /**
     * Set the playSources property: The source of the audio to be played.
     * 
     * @param playSources the playSources value to set.
     * @return the InterruptAudioAndAnnounceRequest object itself.
     */
    public InterruptAudioAndAnnounceRequest setPlaySources(List<PlaySourceInternal> playSources) {
        this.playSources = playSources;
        return this;
    }

    /**
     * Get the playTo property: The list of call participants play provided audio to.
     * Plays to everyone in the call when not provided.
     * 
     * @return the playTo value.
     */
    public CommunicationIdentifierModel getPlayTo() {
        return this.playTo;
    }

    /**
     * Set the playTo property: The list of call participants play provided audio to.
     * Plays to everyone in the call when not provided.
     * 
     * @param playTo the playTo value to set.
     * @return the InterruptAudioAndAnnounceRequest object itself.
     */
    public InterruptAudioAndAnnounceRequest setPlayTo(CommunicationIdentifierModel playTo) {
        this.playTo = playTo;
        return this;
    }

    /**
     * Get the operationContext property: The value to identify context of the operation.
     * 
     * @return the operationContext value.
     */
    public String getOperationContext() {
        return this.operationContext;
    }

    /**
     * Set the operationContext property: The value to identify context of the operation.
     * 
     * @param operationContext the operationContext value to set.
     * @return the InterruptAudioAndAnnounceRequest object itself.
     */
    public InterruptAudioAndAnnounceRequest setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("playSources", this.playSources, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("playTo", this.playTo);
        jsonWriter.writeStringField("operationContext", this.operationContext);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of InterruptAudioAndAnnounceRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of InterruptAudioAndAnnounceRequest if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the InterruptAudioAndAnnounceRequest.
     */
    public static InterruptAudioAndAnnounceRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            InterruptAudioAndAnnounceRequest deserializedInterruptAudioAndAnnounceRequest
                = new InterruptAudioAndAnnounceRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("playSources".equals(fieldName)) {
                    List<PlaySourceInternal> playSources
                        = reader.readArray(reader1 -> PlaySourceInternal.fromJson(reader1));
                    deserializedInterruptAudioAndAnnounceRequest.playSources = playSources;
                } else if ("playTo".equals(fieldName)) {
                    deserializedInterruptAudioAndAnnounceRequest.playTo = CommunicationIdentifierModel.fromJson(reader);
                } else if ("operationContext".equals(fieldName)) {
                    deserializedInterruptAudioAndAnnounceRequest.operationContext = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedInterruptAudioAndAnnounceRequest;
        });
    }
}
