// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The incoming call event.
 */
@Immutable
public final class IncomingCall implements JsonSerializable<IncomingCall> {
    /*
     * The communication identifier of the target user.
     */
    private CommunicationIdentifierModel to;

    /*
     * The communication identifier of the user who initiated the call.
     */
    private CommunicationIdentifierModel from;

    /*
     * Display name of caller.
     */
    private String callerDisplayName;

    /*
     * The server call id.
     */
    private String serverCallId;

    /*
     * Custom Context of Incoming Call
     */
    private CustomCallingContext customContext;

    /*
     * Incoming call context.
     */
    private String incomingCallContext;

    /*
     * The communication identifier of the user on behalf of whom the call is made.
     */
    private CommunicationIdentifierModel onBehalfOfCallee;

    /*
     * Correlation ID for event to call correlation. Also called ChainId for skype chain ID.
     */
    private String correlationId;

    /**
     * Creates an instance of IncomingCall class.
     */
    public IncomingCall() {
    }

    /**
     * Get the to property: The communication identifier of the target user.
     * 
     * @return the to value.
     */
    public CommunicationIdentifierModel getTo() {
        return this.to;
    }

    /**
     * Get the from property: The communication identifier of the user who initiated the call.
     * 
     * @return the from value.
     */
    public CommunicationIdentifierModel getFrom() {
        return this.from;
    }

    /**
     * Get the callerDisplayName property: Display name of caller.
     * 
     * @return the callerDisplayName value.
     */
    public String getCallerDisplayName() {
        return this.callerDisplayName;
    }

    /**
     * Get the serverCallId property: The server call id.
     * 
     * @return the serverCallId value.
     */
    public String getServerCallId() {
        return this.serverCallId;
    }

    /**
     * Get the customContext property: Custom Context of Incoming Call.
     * 
     * @return the customContext value.
     */
    public CustomCallingContext getCustomContext() {
        return this.customContext;
    }

    /**
     * Get the incomingCallContext property: Incoming call context.
     * 
     * @return the incomingCallContext value.
     */
    public String getIncomingCallContext() {
        return this.incomingCallContext;
    }

    /**
     * Get the onBehalfOfCallee property: The communication identifier of the user on behalf of whom the call is made.
     * 
     * @return the onBehalfOfCallee value.
     */
    public CommunicationIdentifierModel getOnBehalfOfCallee() {
        return this.onBehalfOfCallee;
    }

    /**
     * Get the correlationId property: Correlation ID for event to call correlation. Also called ChainId for skype chain
     * ID.
     * 
     * @return the correlationId value.
     */
    public String getCorrelationId() {
        return this.correlationId;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IncomingCall from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IncomingCall if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the IncomingCall.
     */
    public static IncomingCall fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IncomingCall deserializedIncomingCall = new IncomingCall();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("to".equals(fieldName)) {
                    deserializedIncomingCall.to = CommunicationIdentifierModel.fromJson(reader);
                } else if ("from".equals(fieldName)) {
                    deserializedIncomingCall.from = CommunicationIdentifierModel.fromJson(reader);
                } else if ("callerDisplayName".equals(fieldName)) {
                    deserializedIncomingCall.callerDisplayName = reader.getString();
                } else if ("serverCallId".equals(fieldName)) {
                    deserializedIncomingCall.serverCallId = reader.getString();
                } else if ("customContext".equals(fieldName)) {
                    deserializedIncomingCall.customContext = CustomCallingContext.fromJson(reader);
                } else if ("incomingCallContext".equals(fieldName)) {
                    deserializedIncomingCall.incomingCallContext = reader.getString();
                } else if ("onBehalfOfCallee".equals(fieldName)) {
                    deserializedIncomingCall.onBehalfOfCallee = CommunicationIdentifierModel.fromJson(reader);
                } else if ("correlationId".equals(fieldName)) {
                    deserializedIncomingCall.correlationId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIncomingCall;
        });
    }
}
