// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The FileSourceInternal model.
 */
@Fluent
public final class FileSourceInternal implements JsonSerializable<FileSourceInternal> {
    /*
     * Uri for the audio file to be played
     */
    @Generated
    private String uri;

    /**
     * Creates an instance of FileSourceInternal class.
     */
    @Generated
    public FileSourceInternal() {
    }

    /**
     * Get the uri property: Uri for the audio file to be played.
     * 
     * @return the uri value.
     */
    @Generated
    public String getUri() {
        return this.uri;
    }

    /**
     * Set the uri property: Uri for the audio file to be played.
     * 
     * @param uri the uri value to set.
     * @return the FileSourceInternal object itself.
     */
    @Generated
    public FileSourceInternal setUri(String uri) {
        this.uri = uri;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("uri", this.uri);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FileSourceInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FileSourceInternal if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FileSourceInternal.
     */
    @Generated
    public static FileSourceInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FileSourceInternal deserializedFileSourceInternal = new FileSourceInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("uri".equals(fieldName)) {
                    deserializedFileSourceInternal.uri = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFileSourceInternal;
        });
    }
}
