// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The DtmfResult model.
 */
@Immutable
public final class DtmfResult implements JsonSerializable<DtmfResult> {
    /*
     * The tones property.
     */
    @Generated
    private List<DtmfToneInternal> tones;

    /**
     * Creates an instance of DtmfResult class.
     */
    @Generated
    public DtmfResult() {
    }

    /**
     * Get the tones property: The tones property.
     * 
     * @return the tones value.
     */
    @Generated
    public List<DtmfToneInternal> getTones() {
        return this.tones;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DtmfResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DtmfResult if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the DtmfResult.
     */
    @Generated
    public static DtmfResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DtmfResult deserializedDtmfResult = new DtmfResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tones".equals(fieldName)) {
                    List<DtmfToneInternal> tones
                        = reader.readArray(reader1 -> DtmfToneInternal.fromString(reader1.getString()));
                    deserializedDtmfResult.tones = tones;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDtmfResult;
        });
    }
}
