// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * The custom calling context which will be sent to the target.
 */
@Fluent
public final class CustomCallingContext implements JsonSerializable<CustomCallingContext> {
    /*
     * Custom calling context VoiP headers
     */
    @Generated
    private Map<String, String> voipHeaders;

    /*
     * Custom calling context SIP headers
     */
    @Generated
    private Map<String, String> sipHeaders;

    /**
     * Creates an instance of CustomCallingContext class.
     */
    @Generated
    public CustomCallingContext() {
    }

    /**
     * Get the voipHeaders property: Custom calling context VoiP headers.
     * 
     * @return the voipHeaders value.
     */
    @Generated
    public Map<String, String> getVoipHeaders() {
        return this.voipHeaders;
    }

    /**
     * Set the voipHeaders property: Custom calling context VoiP headers.
     * 
     * @param voipHeaders the voipHeaders value to set.
     * @return the CustomCallingContext object itself.
     */
    @Generated
    public CustomCallingContext setVoipHeaders(Map<String, String> voipHeaders) {
        this.voipHeaders = voipHeaders;
        return this;
    }

    /**
     * Get the sipHeaders property: Custom calling context SIP headers.
     * 
     * @return the sipHeaders value.
     */
    @Generated
    public Map<String, String> getSipHeaders() {
        return this.sipHeaders;
    }

    /**
     * Set the sipHeaders property: Custom calling context SIP headers.
     * 
     * @param sipHeaders the sipHeaders value to set.
     * @return the CustomCallingContext object itself.
     */
    @Generated
    public CustomCallingContext setSipHeaders(Map<String, String> sipHeaders) {
        this.sipHeaders = sipHeaders;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("voipHeaders", this.voipHeaders, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("sipHeaders", this.sipHeaders, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomCallingContext from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomCallingContext if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CustomCallingContext.
     */
    @Generated
    public static CustomCallingContext fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomCallingContext deserializedCustomCallingContext = new CustomCallingContext();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("voipHeaders".equals(fieldName)) {
                    Map<String, String> voipHeaders = reader.readMap(reader1 -> reader1.getString());
                    deserializedCustomCallingContext.voipHeaders = voipHeaders;
                } else if ("sipHeaders".equals(fieldName)) {
                    Map<String, String> sipHeaders = reader.readMap(reader1 -> reader1.getString());
                    deserializedCustomCallingContext.sipHeaders = sipHeaders;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomCallingContext;
        });
    }
}
