// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The request payload for creating the call.
 */
@Fluent
public final class CreateCallRequestInternal implements JsonSerializable<CreateCallRequestInternal> {
    /*
     * The targets of the call.
     */
    @Generated
    private List<CommunicationIdentifierModel> targets;

    /*
     * The source caller Id, a phone number, that's shown to the PSTN participant being invited.
     * Required only when calling a PSTN callee.
     */
    @Generated
    private PhoneNumberIdentifierModel sourceCallerIdNumber;

    /*
     * Display name of the call if dialing out to a pstn number
     */
    @Generated
    private String sourceDisplayName;

    /*
     * The identifier of the source of the call
     */
    @Generated
    private CommunicationUserIdentifierModel source;

    /*
     * A customer set value used to track the answering of a call.
     */
    @Generated
    private String operationContext;

    /*
     * The callback URI.
     */
    @Generated
    private String callbackUri;

    /*
     * AI options for the call.
     */
    @Generated
    private CallIntelligenceOptionsInternal callIntelligenceOptions;

    /*
     * Media Streaming Options.
     */
    @Generated
    private MediaStreamingOptionsInternal mediaStreamingOptions;

    /*
     * Transcription Options.
     */
    @Generated
    private TranscriptionOptionsInternal transcriptionOptions;

    /*
     * The identifier of the source for creating call with Teams resource account ID.
     */
    @Generated
    private MicrosoftTeamsAppIdentifierModel teamsAppSource;

    /**
     * Creates an instance of CreateCallRequestInternal class.
     */
    @Generated
    public CreateCallRequestInternal() {
    }

    /**
     * Get the targets property: The targets of the call.
     * 
     * @return the targets value.
     */
    @Generated
    public List<CommunicationIdentifierModel> getTargets() {
        return this.targets;
    }

    /**
     * Set the targets property: The targets of the call.
     * 
     * @param targets the targets value to set.
     * @return the CreateCallRequestInternal object itself.
     */
    @Generated
    public CreateCallRequestInternal setTargets(List<CommunicationIdentifierModel> targets) {
        this.targets = targets;
        return this;
    }

    /**
     * Get the sourceCallerIdNumber property: The source caller Id, a phone number, that's shown to the PSTN participant
     * being invited.
     * Required only when calling a PSTN callee.
     * 
     * @return the sourceCallerIdNumber value.
     */
    @Generated
    public PhoneNumberIdentifierModel getSourceCallerIdNumber() {
        return this.sourceCallerIdNumber;
    }

    /**
     * Set the sourceCallerIdNumber property: The source caller Id, a phone number, that's shown to the PSTN participant
     * being invited.
     * Required only when calling a PSTN callee.
     * 
     * @param sourceCallerIdNumber the sourceCallerIdNumber value to set.
     * @return the CreateCallRequestInternal object itself.
     */
    @Generated
    public CreateCallRequestInternal setSourceCallerIdNumber(PhoneNumberIdentifierModel sourceCallerIdNumber) {
        this.sourceCallerIdNumber = sourceCallerIdNumber;
        return this;
    }

    /**
     * Get the sourceDisplayName property: Display name of the call if dialing out to a pstn number.
     * 
     * @return the sourceDisplayName value.
     */
    @Generated
    public String getSourceDisplayName() {
        return this.sourceDisplayName;
    }

    /**
     * Set the sourceDisplayName property: Display name of the call if dialing out to a pstn number.
     * 
     * @param sourceDisplayName the sourceDisplayName value to set.
     * @return the CreateCallRequestInternal object itself.
     */
    @Generated
    public CreateCallRequestInternal setSourceDisplayName(String sourceDisplayName) {
        this.sourceDisplayName = sourceDisplayName;
        return this;
    }

    /**
     * Get the source property: The identifier of the source of the call.
     * 
     * @return the source value.
     */
    @Generated
    public CommunicationUserIdentifierModel getSource() {
        return this.source;
    }

    /**
     * Set the source property: The identifier of the source of the call.
     * 
     * @param source the source value to set.
     * @return the CreateCallRequestInternal object itself.
     */
    @Generated
    public CreateCallRequestInternal setSource(CommunicationUserIdentifierModel source) {
        this.source = source;
        return this;
    }

    /**
     * Get the operationContext property: A customer set value used to track the answering of a call.
     * 
     * @return the operationContext value.
     */
    @Generated
    public String getOperationContext() {
        return this.operationContext;
    }

    /**
     * Set the operationContext property: A customer set value used to track the answering of a call.
     * 
     * @param operationContext the operationContext value to set.
     * @return the CreateCallRequestInternal object itself.
     */
    @Generated
    public CreateCallRequestInternal setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    /**
     * Get the callbackUri property: The callback URI.
     * 
     * @return the callbackUri value.
     */
    @Generated
    public String getCallbackUri() {
        return this.callbackUri;
    }

    /**
     * Set the callbackUri property: The callback URI.
     * 
     * @param callbackUri the callbackUri value to set.
     * @return the CreateCallRequestInternal object itself.
     */
    @Generated
    public CreateCallRequestInternal setCallbackUri(String callbackUri) {
        this.callbackUri = callbackUri;
        return this;
    }

    /**
     * Get the callIntelligenceOptions property: AI options for the call.
     * 
     * @return the callIntelligenceOptions value.
     */
    @Generated
    public CallIntelligenceOptionsInternal getCallIntelligenceOptions() {
        return this.callIntelligenceOptions;
    }

    /**
     * Set the callIntelligenceOptions property: AI options for the call.
     * 
     * @param callIntelligenceOptions the callIntelligenceOptions value to set.
     * @return the CreateCallRequestInternal object itself.
     */
    @Generated
    public CreateCallRequestInternal
        setCallIntelligenceOptions(CallIntelligenceOptionsInternal callIntelligenceOptions) {
        this.callIntelligenceOptions = callIntelligenceOptions;
        return this;
    }

    /**
     * Get the mediaStreamingOptions property: Media Streaming Options.
     * 
     * @return the mediaStreamingOptions value.
     */
    @Generated
    public MediaStreamingOptionsInternal getMediaStreamingOptions() {
        return this.mediaStreamingOptions;
    }

    /**
     * Set the mediaStreamingOptions property: Media Streaming Options.
     * 
     * @param mediaStreamingOptions the mediaStreamingOptions value to set.
     * @return the CreateCallRequestInternal object itself.
     */
    @Generated
    public CreateCallRequestInternal setMediaStreamingOptions(MediaStreamingOptionsInternal mediaStreamingOptions) {
        this.mediaStreamingOptions = mediaStreamingOptions;
        return this;
    }

    /**
     * Get the transcriptionOptions property: Transcription Options.
     * 
     * @return the transcriptionOptions value.
     */
    @Generated
    public TranscriptionOptionsInternal getTranscriptionOptions() {
        return this.transcriptionOptions;
    }

    /**
     * Set the transcriptionOptions property: Transcription Options.
     * 
     * @param transcriptionOptions the transcriptionOptions value to set.
     * @return the CreateCallRequestInternal object itself.
     */
    @Generated
    public CreateCallRequestInternal setTranscriptionOptions(TranscriptionOptionsInternal transcriptionOptions) {
        this.transcriptionOptions = transcriptionOptions;
        return this;
    }

    /**
     * Get the teamsAppSource property: The identifier of the source for creating call with Teams resource account ID.
     * 
     * @return the teamsAppSource value.
     */
    @Generated
    public MicrosoftTeamsAppIdentifierModel getTeamsAppSource() {
        return this.teamsAppSource;
    }

    /**
     * Set the teamsAppSource property: The identifier of the source for creating call with Teams resource account ID.
     * 
     * @param teamsAppSource the teamsAppSource value to set.
     * @return the CreateCallRequestInternal object itself.
     */
    @Generated
    public CreateCallRequestInternal setTeamsAppSource(MicrosoftTeamsAppIdentifierModel teamsAppSource) {
        this.teamsAppSource = teamsAppSource;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("targets", this.targets, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("callbackUri", this.callbackUri);
        jsonWriter.writeJsonField("sourceCallerIdNumber", this.sourceCallerIdNumber);
        jsonWriter.writeStringField("sourceDisplayName", this.sourceDisplayName);
        jsonWriter.writeJsonField("source", this.source);
        jsonWriter.writeStringField("operationContext", this.operationContext);
        jsonWriter.writeJsonField("callIntelligenceOptions", this.callIntelligenceOptions);
        jsonWriter.writeJsonField("mediaStreamingOptions", this.mediaStreamingOptions);
        jsonWriter.writeJsonField("transcriptionOptions", this.transcriptionOptions);
        jsonWriter.writeJsonField("teamsAppSource", this.teamsAppSource);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CreateCallRequestInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CreateCallRequestInternal if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CreateCallRequestInternal.
     */
    @Generated
    public static CreateCallRequestInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CreateCallRequestInternal deserializedCreateCallRequestInternal = new CreateCallRequestInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("targets".equals(fieldName)) {
                    List<CommunicationIdentifierModel> targets
                        = reader.readArray(reader1 -> CommunicationIdentifierModel.fromJson(reader1));
                    deserializedCreateCallRequestInternal.targets = targets;
                } else if ("callbackUri".equals(fieldName)) {
                    deserializedCreateCallRequestInternal.callbackUri = reader.getString();
                } else if ("sourceCallerIdNumber".equals(fieldName)) {
                    deserializedCreateCallRequestInternal.sourceCallerIdNumber
                        = PhoneNumberIdentifierModel.fromJson(reader);
                } else if ("sourceDisplayName".equals(fieldName)) {
                    deserializedCreateCallRequestInternal.sourceDisplayName = reader.getString();
                } else if ("source".equals(fieldName)) {
                    deserializedCreateCallRequestInternal.source = CommunicationUserIdentifierModel.fromJson(reader);
                } else if ("operationContext".equals(fieldName)) {
                    deserializedCreateCallRequestInternal.operationContext = reader.getString();
                } else if ("callIntelligenceOptions".equals(fieldName)) {
                    deserializedCreateCallRequestInternal.callIntelligenceOptions
                        = CallIntelligenceOptionsInternal.fromJson(reader);
                } else if ("mediaStreamingOptions".equals(fieldName)) {
                    deserializedCreateCallRequestInternal.mediaStreamingOptions
                        = MediaStreamingOptionsInternal.fromJson(reader);
                } else if ("transcriptionOptions".equals(fieldName)) {
                    deserializedCreateCallRequestInternal.transcriptionOptions
                        = TranscriptionOptionsInternal.fromJson(reader);
                } else if ("teamsAppSource".equals(fieldName)) {
                    deserializedCreateCallRequestInternal.teamsAppSource
                        = MicrosoftTeamsAppIdentifierModel.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCreateCallRequestInternal;
        });
    }
}
