// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ContinuousDtmfRecognitionRequestInternal model.
 */
@Fluent
public final class ContinuousDtmfRecognitionRequestInternal
    implements JsonSerializable<ContinuousDtmfRecognitionRequestInternal> {
    /*
     * Defines options for recognition.
     */
    @Generated
    private CommunicationIdentifierModel targetParticipant;

    /*
     * The value to identify context of the operation.
     */
    @Generated
    private String operationContext;

    /*
     * Set a callback URI that overrides the default callback URI set by CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     */
    @Generated
    private String operationCallbackUri;

    /**
     * Creates an instance of ContinuousDtmfRecognitionRequestInternal class.
     */
    @Generated
    public ContinuousDtmfRecognitionRequestInternal() {
    }

    /**
     * Get the targetParticipant property: Defines options for recognition.
     * 
     * @return the targetParticipant value.
     */
    @Generated
    public CommunicationIdentifierModel getTargetParticipant() {
        return this.targetParticipant;
    }

    /**
     * Set the targetParticipant property: Defines options for recognition.
     * 
     * @param targetParticipant the targetParticipant value to set.
     * @return the ContinuousDtmfRecognitionRequestInternal object itself.
     */
    @Generated
    public ContinuousDtmfRecognitionRequestInternal
        setTargetParticipant(CommunicationIdentifierModel targetParticipant) {
        this.targetParticipant = targetParticipant;
        return this;
    }

    /**
     * Get the operationContext property: The value to identify context of the operation.
     * 
     * @return the operationContext value.
     */
    @Generated
    public String getOperationContext() {
        return this.operationContext;
    }

    /**
     * Set the operationContext property: The value to identify context of the operation.
     * 
     * @param operationContext the operationContext value to set.
     * @return the ContinuousDtmfRecognitionRequestInternal object itself.
     */
    @Generated
    public ContinuousDtmfRecognitionRequestInternal setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    /**
     * Get the operationCallbackUri property: Set a callback URI that overrides the default callback URI set by
     * CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     * 
     * @return the operationCallbackUri value.
     */
    @Generated
    public String getOperationCallbackUri() {
        return this.operationCallbackUri;
    }

    /**
     * Set the operationCallbackUri property: Set a callback URI that overrides the default callback URI set by
     * CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     * 
     * @param operationCallbackUri the operationCallbackUri value to set.
     * @return the ContinuousDtmfRecognitionRequestInternal object itself.
     */
    @Generated
    public ContinuousDtmfRecognitionRequestInternal setOperationCallbackUri(String operationCallbackUri) {
        this.operationCallbackUri = operationCallbackUri;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("targetParticipant", this.targetParticipant);
        jsonWriter.writeStringField("operationContext", this.operationContext);
        jsonWriter.writeStringField("operationCallbackUri", this.operationCallbackUri);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContinuousDtmfRecognitionRequestInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContinuousDtmfRecognitionRequestInternal if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ContinuousDtmfRecognitionRequestInternal.
     */
    @Generated
    public static ContinuousDtmfRecognitionRequestInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContinuousDtmfRecognitionRequestInternal deserializedContinuousDtmfRecognitionRequestInternal
                = new ContinuousDtmfRecognitionRequestInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("targetParticipant".equals(fieldName)) {
                    deserializedContinuousDtmfRecognitionRequestInternal.targetParticipant
                        = CommunicationIdentifierModel.fromJson(reader);
                } else if ("operationContext".equals(fieldName)) {
                    deserializedContinuousDtmfRecognitionRequestInternal.operationContext = reader.getString();
                } else if ("operationCallbackUri".equals(fieldName)) {
                    deserializedContinuousDtmfRecognitionRequestInternal.operationCallbackUri = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContinuousDtmfRecognitionRequestInternal;
        });
    }
}
