// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The request payload for creating a connection to a CallLocator.
 */
@Fluent
public final class ConnectRequestInternal implements JsonSerializable<ConnectRequestInternal> {
    /*
     * The call locator.
     */
    @Generated
    private CallLocatorInternal callLocator;

    /*
     * The callback URI.
     */
    @Generated
    private String callbackUri;

    /*
     * Used by customers to correlate the request to the response event.
     */
    @Generated
    private String operationContext;

    /*
     * AI options for the call.
     */
    @Generated
    private CallIntelligenceOptionsInternal callIntelligenceOptions;

    /*
     * Media Streaming Options.
     */
    @Generated
    private MediaStreamingOptionsInternal mediaStreamingOptions;

    /*
     * Transcription Options.
     */
    @Generated
    private TranscriptionOptionsInternal transcriptionOptions;

    /**
     * Creates an instance of ConnectRequestInternal class.
     */
    @Generated
    public ConnectRequestInternal() {
    }

    /**
     * Get the callLocator property: The call locator.
     * 
     * @return the callLocator value.
     */
    @Generated
    public CallLocatorInternal getCallLocator() {
        return this.callLocator;
    }

    /**
     * Set the callLocator property: The call locator.
     * 
     * @param callLocator the callLocator value to set.
     * @return the ConnectRequestInternal object itself.
     */
    @Generated
    public ConnectRequestInternal setCallLocator(CallLocatorInternal callLocator) {
        this.callLocator = callLocator;
        return this;
    }

    /**
     * Get the callbackUri property: The callback URI.
     * 
     * @return the callbackUri value.
     */
    @Generated
    public String getCallbackUri() {
        return this.callbackUri;
    }

    /**
     * Set the callbackUri property: The callback URI.
     * 
     * @param callbackUri the callbackUri value to set.
     * @return the ConnectRequestInternal object itself.
     */
    @Generated
    public ConnectRequestInternal setCallbackUri(String callbackUri) {
        this.callbackUri = callbackUri;
        return this;
    }

    /**
     * Get the operationContext property: Used by customers to correlate the request to the response event.
     * 
     * @return the operationContext value.
     */
    @Generated
    public String getOperationContext() {
        return this.operationContext;
    }

    /**
     * Set the operationContext property: Used by customers to correlate the request to the response event.
     * 
     * @param operationContext the operationContext value to set.
     * @return the ConnectRequestInternal object itself.
     */
    @Generated
    public ConnectRequestInternal setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    /**
     * Get the callIntelligenceOptions property: AI options for the call.
     * 
     * @return the callIntelligenceOptions value.
     */
    @Generated
    public CallIntelligenceOptionsInternal getCallIntelligenceOptions() {
        return this.callIntelligenceOptions;
    }

    /**
     * Set the callIntelligenceOptions property: AI options for the call.
     * 
     * @param callIntelligenceOptions the callIntelligenceOptions value to set.
     * @return the ConnectRequestInternal object itself.
     */
    @Generated
    public ConnectRequestInternal setCallIntelligenceOptions(CallIntelligenceOptionsInternal callIntelligenceOptions) {
        this.callIntelligenceOptions = callIntelligenceOptions;
        return this;
    }

    /**
     * Get the mediaStreamingOptions property: Media Streaming Options.
     * 
     * @return the mediaStreamingOptions value.
     */
    @Generated
    public MediaStreamingOptionsInternal getMediaStreamingOptions() {
        return this.mediaStreamingOptions;
    }

    /**
     * Set the mediaStreamingOptions property: Media Streaming Options.
     * 
     * @param mediaStreamingOptions the mediaStreamingOptions value to set.
     * @return the ConnectRequestInternal object itself.
     */
    @Generated
    public ConnectRequestInternal setMediaStreamingOptions(MediaStreamingOptionsInternal mediaStreamingOptions) {
        this.mediaStreamingOptions = mediaStreamingOptions;
        return this;
    }

    /**
     * Get the transcriptionOptions property: Transcription Options.
     * 
     * @return the transcriptionOptions value.
     */
    @Generated
    public TranscriptionOptionsInternal getTranscriptionOptions() {
        return this.transcriptionOptions;
    }

    /**
     * Set the transcriptionOptions property: Transcription Options.
     * 
     * @param transcriptionOptions the transcriptionOptions value to set.
     * @return the ConnectRequestInternal object itself.
     */
    @Generated
    public ConnectRequestInternal setTranscriptionOptions(TranscriptionOptionsInternal transcriptionOptions) {
        this.transcriptionOptions = transcriptionOptions;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("callLocator", this.callLocator);
        jsonWriter.writeStringField("callbackUri", this.callbackUri);
        jsonWriter.writeStringField("operationContext", this.operationContext);
        jsonWriter.writeJsonField("callIntelligenceOptions", this.callIntelligenceOptions);
        jsonWriter.writeJsonField("mediaStreamingOptions", this.mediaStreamingOptions);
        jsonWriter.writeJsonField("transcriptionOptions", this.transcriptionOptions);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectRequestInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectRequestInternal if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ConnectRequestInternal.
     */
    @Generated
    public static ConnectRequestInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectRequestInternal deserializedConnectRequestInternal = new ConnectRequestInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("callLocator".equals(fieldName)) {
                    deserializedConnectRequestInternal.callLocator = CallLocatorInternal.fromJson(reader);
                } else if ("callbackUri".equals(fieldName)) {
                    deserializedConnectRequestInternal.callbackUri = reader.getString();
                } else if ("operationContext".equals(fieldName)) {
                    deserializedConnectRequestInternal.operationContext = reader.getString();
                } else if ("callIntelligenceOptions".equals(fieldName)) {
                    deserializedConnectRequestInternal.callIntelligenceOptions
                        = CallIntelligenceOptionsInternal.fromJson(reader);
                } else if ("mediaStreamingOptions".equals(fieldName)) {
                    deserializedConnectRequestInternal.mediaStreamingOptions
                        = MediaStreamingOptionsInternal.fromJson(reader);
                } else if ("transcriptionOptions".equals(fieldName)) {
                    deserializedConnectRequestInternal.transcriptionOptions
                        = TranscriptionOptionsInternal.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectRequestInternal;
        });
    }
}
