// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The request payload for creating a connection to a CallLocator.
 */
@Fluent
public final class ConnectRequest implements JsonSerializable<ConnectRequest> {
    /*
     * The call locator.
     */
    private CallLocatorInternal callLocator;

    /*
     * The callback URI.
     */
    private String callbackUri;

    /*
     * Used by customers to correlate the request to the response event.
     */
    private String operationContext;

    /*
     * AI options for the call.
     */
    private CallIntelligenceOptionsInternal callIntelligenceOptions;

    /*
     * Media Streaming Options.
     */
    private MediaStreamingOptionsInternal mediaStreamingOptions;

    /*
     * Transcription Options.
     */
    private TranscriptionOptionsInternal transcriptionOptions;

    /**
     * Creates an instance of ConnectRequest class.
     */
    public ConnectRequest() {
    }

    /**
     * Get the callLocator property: The call locator.
     * 
     * @return the callLocator value.
     */
    public CallLocatorInternal getCallLocator() {
        return this.callLocator;
    }

    /**
     * Set the callLocator property: The call locator.
     * 
     * @param callLocator the callLocator value to set.
     * @return the ConnectRequest object itself.
     */
    public ConnectRequest setCallLocator(CallLocatorInternal callLocator) {
        this.callLocator = callLocator;
        return this;
    }

    /**
     * Get the callbackUri property: The callback URI.
     * 
     * @return the callbackUri value.
     */
    public String getCallbackUri() {
        return this.callbackUri;
    }

    /**
     * Set the callbackUri property: The callback URI.
     * 
     * @param callbackUri the callbackUri value to set.
     * @return the ConnectRequest object itself.
     */
    public ConnectRequest setCallbackUri(String callbackUri) {
        this.callbackUri = callbackUri;
        return this;
    }

    /**
     * Get the operationContext property: Used by customers to correlate the request to the response event.
     * 
     * @return the operationContext value.
     */
    public String getOperationContext() {
        return this.operationContext;
    }

    /**
     * Set the operationContext property: Used by customers to correlate the request to the response event.
     * 
     * @param operationContext the operationContext value to set.
     * @return the ConnectRequest object itself.
     */
    public ConnectRequest setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    /**
     * Get the callIntelligenceOptions property: AI options for the call.
     * 
     * @return the callIntelligenceOptions value.
     */
    public CallIntelligenceOptionsInternal getCallIntelligenceOptions() {
        return this.callIntelligenceOptions;
    }

    /**
     * Set the callIntelligenceOptions property: AI options for the call.
     * 
     * @param callIntelligenceOptions the callIntelligenceOptions value to set.
     * @return the ConnectRequest object itself.
     */
    public ConnectRequest setCallIntelligenceOptions(CallIntelligenceOptionsInternal callIntelligenceOptions) {
        this.callIntelligenceOptions = callIntelligenceOptions;
        return this;
    }

    /**
     * Get the mediaStreamingOptions property: Media Streaming Options.
     * 
     * @return the mediaStreamingOptions value.
     */
    public MediaStreamingOptionsInternal getMediaStreamingOptions() {
        return this.mediaStreamingOptions;
    }

    /**
     * Set the mediaStreamingOptions property: Media Streaming Options.
     * 
     * @param mediaStreamingOptions the mediaStreamingOptions value to set.
     * @return the ConnectRequest object itself.
     */
    public ConnectRequest setMediaStreamingOptions(MediaStreamingOptionsInternal mediaStreamingOptions) {
        this.mediaStreamingOptions = mediaStreamingOptions;
        return this;
    }

    /**
     * Get the transcriptionOptions property: Transcription Options.
     * 
     * @return the transcriptionOptions value.
     */
    public TranscriptionOptionsInternal getTranscriptionOptions() {
        return this.transcriptionOptions;
    }

    /**
     * Set the transcriptionOptions property: Transcription Options.
     * 
     * @param transcriptionOptions the transcriptionOptions value to set.
     * @return the ConnectRequest object itself.
     */
    public ConnectRequest setTranscriptionOptions(TranscriptionOptionsInternal transcriptionOptions) {
        this.transcriptionOptions = transcriptionOptions;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("callLocator", this.callLocator);
        jsonWriter.writeStringField("callbackUri", this.callbackUri);
        jsonWriter.writeStringField("operationContext", this.operationContext);
        jsonWriter.writeJsonField("callIntelligenceOptions", this.callIntelligenceOptions);
        jsonWriter.writeJsonField("mediaStreamingOptions", this.mediaStreamingOptions);
        jsonWriter.writeJsonField("transcriptionOptions", this.transcriptionOptions);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectRequest if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ConnectRequest.
     */
    public static ConnectRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectRequest deserializedConnectRequest = new ConnectRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("callLocator".equals(fieldName)) {
                    deserializedConnectRequest.callLocator = CallLocatorInternal.fromJson(reader);
                } else if ("callbackUri".equals(fieldName)) {
                    deserializedConnectRequest.callbackUri = reader.getString();
                } else if ("operationContext".equals(fieldName)) {
                    deserializedConnectRequest.operationContext = reader.getString();
                } else if ("callIntelligenceOptions".equals(fieldName)) {
                    deserializedConnectRequest.callIntelligenceOptions
                        = CallIntelligenceOptionsInternal.fromJson(reader);
                } else if ("mediaStreamingOptions".equals(fieldName)) {
                    deserializedConnectRequest.mediaStreamingOptions = MediaStreamingOptionsInternal.fromJson(reader);
                } else if ("transcriptionOptions".equals(fieldName)) {
                    deserializedConnectRequest.transcriptionOptions = TranscriptionOptionsInternal.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectRequest;
        });
    }
}
