// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ChoiceResultInternal model.
 */
@Fluent
public final class ChoiceResultInternal implements JsonSerializable<ChoiceResultInternal> {
    /*
     * Label is the primary identifier for the choice detected
     */
    @Generated
    private String label;

    /*
     * Phrases are set to the value if choice is selected via phrase detection.
     * If Dtmf input is recognized, then Label will be the identifier for the choice detected and phrases will be set to
     * null
     */
    @Generated
    private String recognizedPhrase;

    /*
     * The confidence level of the recognized speech, if available, ranges from 0.0 to 1.0
     */
    @Generated
    private Double confidence;

    /**
     * Creates an instance of ChoiceResultInternal class.
     */
    @Generated
    public ChoiceResultInternal() {
    }

    /**
     * Get the label property: Label is the primary identifier for the choice detected.
     * 
     * @return the label value.
     */
    @Generated
    public String getLabel() {
        return this.label;
    }

    /**
     * Set the label property: Label is the primary identifier for the choice detected.
     * 
     * @param label the label value to set.
     * @return the ChoiceResultInternal object itself.
     */
    @Generated
    public ChoiceResultInternal setLabel(String label) {
        this.label = label;
        return this;
    }

    /**
     * Get the recognizedPhrase property: Phrases are set to the value if choice is selected via phrase detection.
     * If Dtmf input is recognized, then Label will be the identifier for the choice detected and phrases will be set to
     * null.
     * 
     * @return the recognizedPhrase value.
     */
    @Generated
    public String getRecognizedPhrase() {
        return this.recognizedPhrase;
    }

    /**
     * Set the recognizedPhrase property: Phrases are set to the value if choice is selected via phrase detection.
     * If Dtmf input is recognized, then Label will be the identifier for the choice detected and phrases will be set to
     * null.
     * 
     * @param recognizedPhrase the recognizedPhrase value to set.
     * @return the ChoiceResultInternal object itself.
     */
    @Generated
    public ChoiceResultInternal setRecognizedPhrase(String recognizedPhrase) {
        this.recognizedPhrase = recognizedPhrase;
        return this;
    }

    /**
     * Get the confidence property: The confidence level of the recognized speech, if available, ranges from 0.0 to 1.0.
     * 
     * @return the confidence value.
     */
    @Generated
    public Double getConfidence() {
        return this.confidence;
    }

    /**
     * Set the confidence property: The confidence level of the recognized speech, if available, ranges from 0.0 to 1.0.
     * 
     * @param confidence the confidence value to set.
     * @return the ChoiceResultInternal object itself.
     */
    @Generated
    public ChoiceResultInternal setConfidence(Double confidence) {
        this.confidence = confidence;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("label", this.label);
        jsonWriter.writeStringField("recognizedPhrase", this.recognizedPhrase);
        jsonWriter.writeNumberField("confidence", this.confidence);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChoiceResultInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChoiceResultInternal if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ChoiceResultInternal.
     */
    @Generated
    public static ChoiceResultInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChoiceResultInternal deserializedChoiceResultInternal = new ChoiceResultInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("label".equals(fieldName)) {
                    deserializedChoiceResultInternal.label = reader.getString();
                } else if ("recognizedPhrase".equals(fieldName)) {
                    deserializedChoiceResultInternal.recognizedPhrase = reader.getString();
                } else if ("confidence".equals(fieldName)) {
                    deserializedChoiceResultInternal.confidence = reader.getNullable(JsonReader::getDouble);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedChoiceResultInternal;
        });
    }
}
