// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Channel affinity for a participant.
 */
@Fluent
public final class ChannelAffinityInternal implements JsonSerializable<ChannelAffinityInternal> {
    /*
     * Channel number to which bitstream from a particular participant will be written.
     */
    @Generated
    private Integer channel;

    /*
     * The identifier for the participant whose bitstream will be written to the channel
     * represented by the channel number.
     */
    @Generated
    private CommunicationIdentifierModel participant;

    /**
     * Creates an instance of ChannelAffinityInternal class.
     */
    @Generated
    public ChannelAffinityInternal() {
    }

    /**
     * Get the channel property: Channel number to which bitstream from a particular participant will be written.
     * 
     * @return the channel value.
     */
    @Generated
    public Integer getChannel() {
        return this.channel;
    }

    /**
     * Set the channel property: Channel number to which bitstream from a particular participant will be written.
     * 
     * @param channel the channel value to set.
     * @return the ChannelAffinityInternal object itself.
     */
    @Generated
    public ChannelAffinityInternal setChannel(Integer channel) {
        this.channel = channel;
        return this;
    }

    /**
     * Get the participant property: The identifier for the participant whose bitstream will be written to the channel
     * represented by the channel number.
     * 
     * @return the participant value.
     */
    @Generated
    public CommunicationIdentifierModel getParticipant() {
        return this.participant;
    }

    /**
     * Set the participant property: The identifier for the participant whose bitstream will be written to the channel
     * represented by the channel number.
     * 
     * @param participant the participant value to set.
     * @return the ChannelAffinityInternal object itself.
     */
    @Generated
    public ChannelAffinityInternal setParticipant(CommunicationIdentifierModel participant) {
        this.participant = participant;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("participant", this.participant);
        jsonWriter.writeNumberField("channel", this.channel);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChannelAffinityInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChannelAffinityInternal if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChannelAffinityInternal.
     */
    @Generated
    public static ChannelAffinityInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChannelAffinityInternal deserializedChannelAffinityInternal = new ChannelAffinityInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("participant".equals(fieldName)) {
                    deserializedChannelAffinityInternal.participant = CommunicationIdentifierModel.fromJson(reader);
                } else if ("channel".equals(fieldName)) {
                    deserializedChannelAffinityInternal.channel = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedChannelAffinityInternal;
        });
    }
}
