// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Response payload for cancel add participant request.
 */
@Fluent
public final class CancelAddParticipantResponse implements JsonSerializable<CancelAddParticipantResponse> {
    /*
     * Invitation ID used to cancel the add participant action.
     */
    @Generated
    private String invitationId;

    /*
     * The operation context provided by client.
     */
    @Generated
    private String operationContext;

    /**
     * Creates an instance of CancelAddParticipantResponse class.
     */
    @Generated
    public CancelAddParticipantResponse() {
    }

    /**
     * Get the invitationId property: Invitation ID used to cancel the add participant action.
     * 
     * @return the invitationId value.
     */
    @Generated
    public String getInvitationId() {
        return this.invitationId;
    }

    /**
     * Set the invitationId property: Invitation ID used to cancel the add participant action.
     * 
     * @param invitationId the invitationId value to set.
     * @return the CancelAddParticipantResponse object itself.
     */
    @Generated
    public CancelAddParticipantResponse setInvitationId(String invitationId) {
        this.invitationId = invitationId;
        return this;
    }

    /**
     * Get the operationContext property: The operation context provided by client.
     * 
     * @return the operationContext value.
     */
    @Generated
    public String getOperationContext() {
        return this.operationContext;
    }

    /**
     * Set the operationContext property: The operation context provided by client.
     * 
     * @param operationContext the operationContext value to set.
     * @return the CancelAddParticipantResponse object itself.
     */
    @Generated
    public CancelAddParticipantResponse setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("invitationId", this.invitationId);
        jsonWriter.writeStringField("operationContext", this.operationContext);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CancelAddParticipantResponse from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CancelAddParticipantResponse if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CancelAddParticipantResponse.
     */
    @Generated
    public static CancelAddParticipantResponse fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CancelAddParticipantResponse deserializedCancelAddParticipantResponse = new CancelAddParticipantResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("invitationId".equals(fieldName)) {
                    deserializedCancelAddParticipantResponse.invitationId = reader.getString();
                } else if ("operationContext".equals(fieldName)) {
                    deserializedCancelAddParticipantResponse.operationContext = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCancelAddParticipantResponse;
        });
    }
}
