// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Request payload for cancelling add participant request.
 */
@Fluent
public final class CancelAddParticipantRequest implements JsonSerializable<CancelAddParticipantRequest> {
    /*
     * Invitation ID used to add a participant.
     */
    @Generated
    private String invitationId;

    /*
     * Used by customers when calling mid-call actions to correlate the request to the response event.
     */
    @Generated
    private String operationContext;

    /*
     * Set a callback URI that overrides the default callback URI set by CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     */
    @Generated
    private String operationCallbackUri;

    /**
     * Creates an instance of CancelAddParticipantRequest class.
     */
    @Generated
    public CancelAddParticipantRequest() {
    }

    /**
     * Get the invitationId property: Invitation ID used to add a participant.
     * 
     * @return the invitationId value.
     */
    @Generated
    public String getInvitationId() {
        return this.invitationId;
    }

    /**
     * Set the invitationId property: Invitation ID used to add a participant.
     * 
     * @param invitationId the invitationId value to set.
     * @return the CancelAddParticipantRequest object itself.
     */
    @Generated
    public CancelAddParticipantRequest setInvitationId(String invitationId) {
        this.invitationId = invitationId;
        return this;
    }

    /**
     * Get the operationContext property: Used by customers when calling mid-call actions to correlate the request to
     * the response event.
     * 
     * @return the operationContext value.
     */
    @Generated
    public String getOperationContext() {
        return this.operationContext;
    }

    /**
     * Set the operationContext property: Used by customers when calling mid-call actions to correlate the request to
     * the response event.
     * 
     * @param operationContext the operationContext value to set.
     * @return the CancelAddParticipantRequest object itself.
     */
    @Generated
    public CancelAddParticipantRequest setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    /**
     * Get the operationCallbackUri property: Set a callback URI that overrides the default callback URI set by
     * CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     * 
     * @return the operationCallbackUri value.
     */
    @Generated
    public String getOperationCallbackUri() {
        return this.operationCallbackUri;
    }

    /**
     * Set the operationCallbackUri property: Set a callback URI that overrides the default callback URI set by
     * CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     * 
     * @param operationCallbackUri the operationCallbackUri value to set.
     * @return the CancelAddParticipantRequest object itself.
     */
    @Generated
    public CancelAddParticipantRequest setOperationCallbackUri(String operationCallbackUri) {
        this.operationCallbackUri = operationCallbackUri;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("invitationId", this.invitationId);
        jsonWriter.writeStringField("operationContext", this.operationContext);
        jsonWriter.writeStringField("operationCallbackUri", this.operationCallbackUri);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CancelAddParticipantRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CancelAddParticipantRequest if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CancelAddParticipantRequest.
     */
    @Generated
    public static CancelAddParticipantRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CancelAddParticipantRequest deserializedCancelAddParticipantRequest = new CancelAddParticipantRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("invitationId".equals(fieldName)) {
                    deserializedCancelAddParticipantRequest.invitationId = reader.getString();
                } else if ("operationContext".equals(fieldName)) {
                    deserializedCancelAddParticipantRequest.operationContext = reader.getString();
                } else if ("operationCallbackUri".equals(fieldName)) {
                    deserializedCancelAddParticipantRequest.operationCallbackUri = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCancelAddParticipantRequest;
        });
    }
}
