// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A call participant.
 */
@Fluent
public final class CallParticipantInternal implements JsonSerializable<CallParticipantInternal> {
    /*
     * Communication identifier of the participant
     */
    @Generated
    private CommunicationIdentifierModel identifier;

    /*
     * Is participant muted
     */
    @Generated
    private Boolean isMuted;

    /*
     * Is participant on hold.
     */
    @Generated
    private Boolean isOnHold;

    /**
     * Creates an instance of CallParticipantInternal class.
     */
    @Generated
    public CallParticipantInternal() {
    }

    /**
     * Get the identifier property: Communication identifier of the participant.
     * 
     * @return the identifier value.
     */
    @Generated
    public CommunicationIdentifierModel getIdentifier() {
        return this.identifier;
    }

    /**
     * Set the identifier property: Communication identifier of the participant.
     * 
     * @param identifier the identifier value to set.
     * @return the CallParticipantInternal object itself.
     */
    @Generated
    public CallParticipantInternal setIdentifier(CommunicationIdentifierModel identifier) {
        this.identifier = identifier;
        return this;
    }

    /**
     * Get the isMuted property: Is participant muted.
     * 
     * @return the isMuted value.
     */
    @Generated
    public Boolean isMuted() {
        return this.isMuted;
    }

    /**
     * Set the isMuted property: Is participant muted.
     * 
     * @param isMuted the isMuted value to set.
     * @return the CallParticipantInternal object itself.
     */
    @Generated
    public CallParticipantInternal setIsMuted(Boolean isMuted) {
        this.isMuted = isMuted;
        return this;
    }

    /**
     * Get the isOnHold property: Is participant on hold.
     * 
     * @return the isOnHold value.
     */
    @Generated
    public Boolean isOnHold() {
        return this.isOnHold;
    }

    /**
     * Set the isOnHold property: Is participant on hold.
     * 
     * @param isOnHold the isOnHold value to set.
     * @return the CallParticipantInternal object itself.
     */
    @Generated
    public CallParticipantInternal setIsOnHold(Boolean isOnHold) {
        this.isOnHold = isOnHold;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identifier", this.identifier);
        jsonWriter.writeBooleanField("isMuted", this.isMuted);
        jsonWriter.writeBooleanField("isOnHold", this.isOnHold);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CallParticipantInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CallParticipantInternal if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CallParticipantInternal.
     */
    @Generated
    public static CallParticipantInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CallParticipantInternal deserializedCallParticipantInternal = new CallParticipantInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("identifier".equals(fieldName)) {
                    deserializedCallParticipantInternal.identifier = CommunicationIdentifierModel.fromJson(reader);
                } else if ("isMuted".equals(fieldName)) {
                    deserializedCallParticipantInternal.isMuted = reader.getNullable(JsonReader::getBoolean);
                } else if ("isOnHold".equals(fieldName)) {
                    deserializedCallParticipantInternal.isOnHold = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCallParticipantInternal;
        });
    }
}
