// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * AI options for the call.
 */
@Fluent
public final class CallIntelligenceOptionsInternal implements JsonSerializable<CallIntelligenceOptionsInternal> {
    /*
     * The identifier of the Cognitive Service resource assigned to this call.
     */
    @Generated
    private String cognitiveServicesEndpoint;

    /**
     * Creates an instance of CallIntelligenceOptionsInternal class.
     */
    @Generated
    public CallIntelligenceOptionsInternal() {
    }

    /**
     * Get the cognitiveServicesEndpoint property: The identifier of the Cognitive Service resource assigned to this
     * call.
     * 
     * @return the cognitiveServicesEndpoint value.
     */
    @Generated
    public String getCognitiveServicesEndpoint() {
        return this.cognitiveServicesEndpoint;
    }

    /**
     * Set the cognitiveServicesEndpoint property: The identifier of the Cognitive Service resource assigned to this
     * call.
     * 
     * @param cognitiveServicesEndpoint the cognitiveServicesEndpoint value to set.
     * @return the CallIntelligenceOptionsInternal object itself.
     */
    @Generated
    public CallIntelligenceOptionsInternal setCognitiveServicesEndpoint(String cognitiveServicesEndpoint) {
        this.cognitiveServicesEndpoint = cognitiveServicesEndpoint;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("cognitiveServicesEndpoint", this.cognitiveServicesEndpoint);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CallIntelligenceOptionsInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CallIntelligenceOptionsInternal if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CallIntelligenceOptionsInternal.
     */
    @Generated
    public static CallIntelligenceOptionsInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CallIntelligenceOptionsInternal deserializedCallIntelligenceOptionsInternal
                = new CallIntelligenceOptionsInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("cognitiveServicesEndpoint".equals(fieldName)) {
                    deserializedCallIntelligenceOptionsInternal.cognitiveServicesEndpoint = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCallIntelligenceOptionsInternal;
        });
    }
}
