// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The request payload for answering the call.
 */
@Fluent
public final class AnswerCallRequestInternal implements JsonSerializable<AnswerCallRequestInternal> {
    /*
     * The context associated with the call.
     */
    @Generated
    private String incomingCallContext;

    /*
     * The callback uri.
     */
    @Generated
    private String callbackUri;

    /*
     * A customer set value used to track the answering of a call.
     */
    @Generated
    private String operationContext;

    /*
     * AI options for the call.
     */
    @Generated
    private CallIntelligenceOptionsInternal callIntelligenceOptions;

    /*
     * The identifier of the call automation entity which answers the call
     */
    @Generated
    private CommunicationUserIdentifierModel answeredBy;

    /*
     * Media Streaming Options.
     */
    @Generated
    private MediaStreamingOptionsInternal mediaStreamingOptions;

    /*
     * Transcription Options.
     */
    @Generated
    private TranscriptionOptionsInternal transcriptionOptions;

    /**
     * Creates an instance of AnswerCallRequestInternal class.
     */
    @Generated
    public AnswerCallRequestInternal() {
    }

    /**
     * Get the incomingCallContext property: The context associated with the call.
     * 
     * @return the incomingCallContext value.
     */
    @Generated
    public String getIncomingCallContext() {
        return this.incomingCallContext;
    }

    /**
     * Set the incomingCallContext property: The context associated with the call.
     * 
     * @param incomingCallContext the incomingCallContext value to set.
     * @return the AnswerCallRequestInternal object itself.
     */
    @Generated
    public AnswerCallRequestInternal setIncomingCallContext(String incomingCallContext) {
        this.incomingCallContext = incomingCallContext;
        return this;
    }

    /**
     * Get the callbackUri property: The callback uri.
     * 
     * @return the callbackUri value.
     */
    @Generated
    public String getCallbackUri() {
        return this.callbackUri;
    }

    /**
     * Set the callbackUri property: The callback uri.
     * 
     * @param callbackUri the callbackUri value to set.
     * @return the AnswerCallRequestInternal object itself.
     */
    @Generated
    public AnswerCallRequestInternal setCallbackUri(String callbackUri) {
        this.callbackUri = callbackUri;
        return this;
    }

    /**
     * Get the operationContext property: A customer set value used to track the answering of a call.
     * 
     * @return the operationContext value.
     */
    @Generated
    public String getOperationContext() {
        return this.operationContext;
    }

    /**
     * Set the operationContext property: A customer set value used to track the answering of a call.
     * 
     * @param operationContext the operationContext value to set.
     * @return the AnswerCallRequestInternal object itself.
     */
    @Generated
    public AnswerCallRequestInternal setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    /**
     * Get the callIntelligenceOptions property: AI options for the call.
     * 
     * @return the callIntelligenceOptions value.
     */
    @Generated
    public CallIntelligenceOptionsInternal getCallIntelligenceOptions() {
        return this.callIntelligenceOptions;
    }

    /**
     * Set the callIntelligenceOptions property: AI options for the call.
     * 
     * @param callIntelligenceOptions the callIntelligenceOptions value to set.
     * @return the AnswerCallRequestInternal object itself.
     */
    @Generated
    public AnswerCallRequestInternal
        setCallIntelligenceOptions(CallIntelligenceOptionsInternal callIntelligenceOptions) {
        this.callIntelligenceOptions = callIntelligenceOptions;
        return this;
    }

    /**
     * Get the answeredBy property: The identifier of the call automation entity which answers the call.
     * 
     * @return the answeredBy value.
     */
    @Generated
    public CommunicationUserIdentifierModel getAnsweredBy() {
        return this.answeredBy;
    }

    /**
     * Set the answeredBy property: The identifier of the call automation entity which answers the call.
     * 
     * @param answeredBy the answeredBy value to set.
     * @return the AnswerCallRequestInternal object itself.
     */
    @Generated
    public AnswerCallRequestInternal setAnsweredBy(CommunicationUserIdentifierModel answeredBy) {
        this.answeredBy = answeredBy;
        return this;
    }

    /**
     * Get the mediaStreamingOptions property: Media Streaming Options.
     * 
     * @return the mediaStreamingOptions value.
     */
    @Generated
    public MediaStreamingOptionsInternal getMediaStreamingOptions() {
        return this.mediaStreamingOptions;
    }

    /**
     * Set the mediaStreamingOptions property: Media Streaming Options.
     * 
     * @param mediaStreamingOptions the mediaStreamingOptions value to set.
     * @return the AnswerCallRequestInternal object itself.
     */
    @Generated
    public AnswerCallRequestInternal setMediaStreamingOptions(MediaStreamingOptionsInternal mediaStreamingOptions) {
        this.mediaStreamingOptions = mediaStreamingOptions;
        return this;
    }

    /**
     * Get the transcriptionOptions property: Transcription Options.
     * 
     * @return the transcriptionOptions value.
     */
    @Generated
    public TranscriptionOptionsInternal getTranscriptionOptions() {
        return this.transcriptionOptions;
    }

    /**
     * Set the transcriptionOptions property: Transcription Options.
     * 
     * @param transcriptionOptions the transcriptionOptions value to set.
     * @return the AnswerCallRequestInternal object itself.
     */
    @Generated
    public AnswerCallRequestInternal setTranscriptionOptions(TranscriptionOptionsInternal transcriptionOptions) {
        this.transcriptionOptions = transcriptionOptions;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("incomingCallContext", this.incomingCallContext);
        jsonWriter.writeStringField("callbackUri", this.callbackUri);
        jsonWriter.writeStringField("operationContext", this.operationContext);
        jsonWriter.writeJsonField("callIntelligenceOptions", this.callIntelligenceOptions);
        jsonWriter.writeJsonField("answeredBy", this.answeredBy);
        jsonWriter.writeJsonField("mediaStreamingOptions", this.mediaStreamingOptions);
        jsonWriter.writeJsonField("transcriptionOptions", this.transcriptionOptions);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AnswerCallRequestInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AnswerCallRequestInternal if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AnswerCallRequestInternal.
     */
    @Generated
    public static AnswerCallRequestInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AnswerCallRequestInternal deserializedAnswerCallRequestInternal = new AnswerCallRequestInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("incomingCallContext".equals(fieldName)) {
                    deserializedAnswerCallRequestInternal.incomingCallContext = reader.getString();
                } else if ("callbackUri".equals(fieldName)) {
                    deserializedAnswerCallRequestInternal.callbackUri = reader.getString();
                } else if ("operationContext".equals(fieldName)) {
                    deserializedAnswerCallRequestInternal.operationContext = reader.getString();
                } else if ("callIntelligenceOptions".equals(fieldName)) {
                    deserializedAnswerCallRequestInternal.callIntelligenceOptions
                        = CallIntelligenceOptionsInternal.fromJson(reader);
                } else if ("answeredBy".equals(fieldName)) {
                    deserializedAnswerCallRequestInternal.answeredBy
                        = CommunicationUserIdentifierModel.fromJson(reader);
                } else if ("mediaStreamingOptions".equals(fieldName)) {
                    deserializedAnswerCallRequestInternal.mediaStreamingOptions
                        = MediaStreamingOptionsInternal.fromJson(reader);
                } else if ("transcriptionOptions".equals(fieldName)) {
                    deserializedAnswerCallRequestInternal.transcriptionOptions
                        = TranscriptionOptionsInternal.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAnswerCallRequestInternal;
        });
    }
}
