// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The response payload for adding participants to the call.
 */
@Fluent
public final class AddParticipantResponseInternal implements JsonSerializable<AddParticipantResponseInternal> {
    /*
     * List of current participants in the call.
     */
    @Generated
    private CallParticipantInternal participant;

    /*
     * The operation context provided by client.
     */
    @Generated
    private String operationContext;

    /*
     * Invitation ID used to add a participant.
     */
    @Generated
    private String invitationId;

    /**
     * Creates an instance of AddParticipantResponseInternal class.
     */
    @Generated
    public AddParticipantResponseInternal() {
    }

    /**
     * Get the participant property: List of current participants in the call.
     * 
     * @return the participant value.
     */
    @Generated
    public CallParticipantInternal getParticipant() {
        return this.participant;
    }

    /**
     * Set the participant property: List of current participants in the call.
     * 
     * @param participant the participant value to set.
     * @return the AddParticipantResponseInternal object itself.
     */
    @Generated
    public AddParticipantResponseInternal setParticipant(CallParticipantInternal participant) {
        this.participant = participant;
        return this;
    }

    /**
     * Get the operationContext property: The operation context provided by client.
     * 
     * @return the operationContext value.
     */
    @Generated
    public String getOperationContext() {
        return this.operationContext;
    }

    /**
     * Set the operationContext property: The operation context provided by client.
     * 
     * @param operationContext the operationContext value to set.
     * @return the AddParticipantResponseInternal object itself.
     */
    @Generated
    public AddParticipantResponseInternal setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    /**
     * Get the invitationId property: Invitation ID used to add a participant.
     * 
     * @return the invitationId value.
     */
    @Generated
    public String getInvitationId() {
        return this.invitationId;
    }

    /**
     * Set the invitationId property: Invitation ID used to add a participant.
     * 
     * @param invitationId the invitationId value to set.
     * @return the AddParticipantResponseInternal object itself.
     */
    @Generated
    public AddParticipantResponseInternal setInvitationId(String invitationId) {
        this.invitationId = invitationId;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("participant", this.participant);
        jsonWriter.writeStringField("operationContext", this.operationContext);
        jsonWriter.writeStringField("invitationId", this.invitationId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AddParticipantResponseInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AddParticipantResponseInternal if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AddParticipantResponseInternal.
     */
    @Generated
    public static AddParticipantResponseInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AddParticipantResponseInternal deserializedAddParticipantResponseInternal
                = new AddParticipantResponseInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("participant".equals(fieldName)) {
                    deserializedAddParticipantResponseInternal.participant = CallParticipantInternal.fromJson(reader);
                } else if ("operationContext".equals(fieldName)) {
                    deserializedAddParticipantResponseInternal.operationContext = reader.getString();
                } else if ("invitationId".equals(fieldName)) {
                    deserializedAddParticipantResponseInternal.invitationId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAddParticipantResponseInternal;
        });
    }
}
