// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The request payload for adding participant to the call.
 */
@Fluent
public final class AddParticipantRequestInternal implements JsonSerializable<AddParticipantRequestInternal> {
    /*
     * The source caller Id, a phone number, that's shown to the PSTN participant being invited.
     * Required only when inviting a PSTN participant.
     */
    @Generated
    private PhoneNumberIdentifierModel sourceCallerIdNumber;

    /*
     * (Optional) The display name of the source that is associated with this invite operation when
     * adding a PSTN participant or teams user. Note: Will not update the display name in the roster.
     */
    @Generated
    private String sourceDisplayName;

    /*
     * The participant to invite.
     */
    @Generated
    private CommunicationIdentifierModel participantToAdd;

    /*
     * Gets or sets the timeout to wait for the invited participant to pickup.
     * The maximum value of this is 180 seconds
     */
    @Generated
    private Integer invitationTimeoutInSeconds;

    /*
     * Used by customers when calling mid-call actions to correlate the request to the response event.
     */
    @Generated
    private String operationContext;

    /*
     * Set a callback URI that overrides the default callback URI set by CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     */
    @Generated
    private String operationCallbackUri;

    /*
     * Used by customer to send custom calling context to targets
     */
    @Generated
    private CustomCallingContext customCallingContext;

    /**
     * Creates an instance of AddParticipantRequestInternal class.
     */
    @Generated
    public AddParticipantRequestInternal() {
    }

    /**
     * Get the sourceCallerIdNumber property: The source caller Id, a phone number, that's shown to the PSTN participant
     * being invited.
     * Required only when inviting a PSTN participant.
     * 
     * @return the sourceCallerIdNumber value.
     */
    @Generated
    public PhoneNumberIdentifierModel getSourceCallerIdNumber() {
        return this.sourceCallerIdNumber;
    }

    /**
     * Set the sourceCallerIdNumber property: The source caller Id, a phone number, that's shown to the PSTN participant
     * being invited.
     * Required only when inviting a PSTN participant.
     * 
     * @param sourceCallerIdNumber the sourceCallerIdNumber value to set.
     * @return the AddParticipantRequestInternal object itself.
     */
    @Generated
    public AddParticipantRequestInternal setSourceCallerIdNumber(PhoneNumberIdentifierModel sourceCallerIdNumber) {
        this.sourceCallerIdNumber = sourceCallerIdNumber;
        return this;
    }

    /**
     * Get the sourceDisplayName property: (Optional) The display name of the source that is associated with this invite
     * operation when
     * adding a PSTN participant or teams user. Note: Will not update the display name in the roster.
     * 
     * @return the sourceDisplayName value.
     */
    @Generated
    public String getSourceDisplayName() {
        return this.sourceDisplayName;
    }

    /**
     * Set the sourceDisplayName property: (Optional) The display name of the source that is associated with this invite
     * operation when
     * adding a PSTN participant or teams user. Note: Will not update the display name in the roster.
     * 
     * @param sourceDisplayName the sourceDisplayName value to set.
     * @return the AddParticipantRequestInternal object itself.
     */
    @Generated
    public AddParticipantRequestInternal setSourceDisplayName(String sourceDisplayName) {
        this.sourceDisplayName = sourceDisplayName;
        return this;
    }

    /**
     * Get the participantToAdd property: The participant to invite.
     * 
     * @return the participantToAdd value.
     */
    @Generated
    public CommunicationIdentifierModel getParticipantToAdd() {
        return this.participantToAdd;
    }

    /**
     * Set the participantToAdd property: The participant to invite.
     * 
     * @param participantToAdd the participantToAdd value to set.
     * @return the AddParticipantRequestInternal object itself.
     */
    @Generated
    public AddParticipantRequestInternal setParticipantToAdd(CommunicationIdentifierModel participantToAdd) {
        this.participantToAdd = participantToAdd;
        return this;
    }

    /**
     * Get the invitationTimeoutInSeconds property: Gets or sets the timeout to wait for the invited participant to
     * pickup.
     * The maximum value of this is 180 seconds.
     * 
     * @return the invitationTimeoutInSeconds value.
     */
    @Generated
    public Integer getInvitationTimeoutInSeconds() {
        return this.invitationTimeoutInSeconds;
    }

    /**
     * Set the invitationTimeoutInSeconds property: Gets or sets the timeout to wait for the invited participant to
     * pickup.
     * The maximum value of this is 180 seconds.
     * 
     * @param invitationTimeoutInSeconds the invitationTimeoutInSeconds value to set.
     * @return the AddParticipantRequestInternal object itself.
     */
    @Generated
    public AddParticipantRequestInternal setInvitationTimeoutInSeconds(Integer invitationTimeoutInSeconds) {
        this.invitationTimeoutInSeconds = invitationTimeoutInSeconds;
        return this;
    }

    /**
     * Get the operationContext property: Used by customers when calling mid-call actions to correlate the request to
     * the response event.
     * 
     * @return the operationContext value.
     */
    @Generated
    public String getOperationContext() {
        return this.operationContext;
    }

    /**
     * Set the operationContext property: Used by customers when calling mid-call actions to correlate the request to
     * the response event.
     * 
     * @param operationContext the operationContext value to set.
     * @return the AddParticipantRequestInternal object itself.
     */
    @Generated
    public AddParticipantRequestInternal setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    /**
     * Get the operationCallbackUri property: Set a callback URI that overrides the default callback URI set by
     * CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     * 
     * @return the operationCallbackUri value.
     */
    @Generated
    public String getOperationCallbackUri() {
        return this.operationCallbackUri;
    }

    /**
     * Set the operationCallbackUri property: Set a callback URI that overrides the default callback URI set by
     * CreateCall/AnswerCall for this operation.
     * This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
     * 
     * @param operationCallbackUri the operationCallbackUri value to set.
     * @return the AddParticipantRequestInternal object itself.
     */
    @Generated
    public AddParticipantRequestInternal setOperationCallbackUri(String operationCallbackUri) {
        this.operationCallbackUri = operationCallbackUri;
        return this;
    }

    /**
     * Get the customCallingContext property: Used by customer to send custom calling context to targets.
     * 
     * @return the customCallingContext value.
     */
    @Generated
    public CustomCallingContext getCustomCallingContext() {
        return this.customCallingContext;
    }

    /**
     * Set the customCallingContext property: Used by customer to send custom calling context to targets.
     * 
     * @param customCallingContext the customCallingContext value to set.
     * @return the AddParticipantRequestInternal object itself.
     */
    @Generated
    public AddParticipantRequestInternal setCustomCallingContext(CustomCallingContext customCallingContext) {
        this.customCallingContext = customCallingContext;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("participantToAdd", this.participantToAdd);
        jsonWriter.writeJsonField("sourceCallerIdNumber", this.sourceCallerIdNumber);
        jsonWriter.writeStringField("sourceDisplayName", this.sourceDisplayName);
        jsonWriter.writeNumberField("invitationTimeoutInSeconds", this.invitationTimeoutInSeconds);
        jsonWriter.writeStringField("operationContext", this.operationContext);
        jsonWriter.writeStringField("operationCallbackUri", this.operationCallbackUri);
        jsonWriter.writeJsonField("customCallingContext", this.customCallingContext);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AddParticipantRequestInternal from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AddParticipantRequestInternal if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AddParticipantRequestInternal.
     */
    @Generated
    public static AddParticipantRequestInternal fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AddParticipantRequestInternal deserializedAddParticipantRequestInternal
                = new AddParticipantRequestInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("participantToAdd".equals(fieldName)) {
                    deserializedAddParticipantRequestInternal.participantToAdd
                        = CommunicationIdentifierModel.fromJson(reader);
                } else if ("sourceCallerIdNumber".equals(fieldName)) {
                    deserializedAddParticipantRequestInternal.sourceCallerIdNumber
                        = PhoneNumberIdentifierModel.fromJson(reader);
                } else if ("sourceDisplayName".equals(fieldName)) {
                    deserializedAddParticipantRequestInternal.sourceDisplayName = reader.getString();
                } else if ("invitationTimeoutInSeconds".equals(fieldName)) {
                    deserializedAddParticipantRequestInternal.invitationTimeoutInSeconds
                        = reader.getNullable(JsonReader::getInt);
                } else if ("operationContext".equals(fieldName)) {
                    deserializedAddParticipantRequestInternal.operationContext = reader.getString();
                } else if ("operationCallbackUri".equals(fieldName)) {
                    deserializedAddParticipantRequestInternal.operationCallbackUri = reader.getString();
                } else if ("customCallingContext".equals(fieldName)) {
                    deserializedAddParticipantRequestInternal.customCallingContext
                        = CustomCallingContext.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAddParticipantRequestInternal;
        });
    }
}
