// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation;

import com.azure.communication.callautomation.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.callautomation.implementation.models.RecordingStateResponseInternal;
import com.azure.communication.callautomation.implementation.models.StartCallRecordingRequestInternal;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in CallRecordings.
 */
public final class CallRecordingsImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final CallRecordingsService service;

    /**
     * The service client containing this operation class.
     */
    private final AzureCommunicationCallAutomationServiceImpl client;

    /**
     * Initializes an instance of CallRecordingsImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    CallRecordingsImpl(AzureCommunicationCallAutomationServiceImpl client) {
        this.service
            = RestProxy.create(CallRecordingsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureCommunicationCallAutomationServiceCallRecordings to be used by
     * the proxy service to perform REST calls.
     */
    @Host("{endpoint}")
    @ServiceInterface(name = "AzureCommunicationCallAutomationServiceCallRecordings")
    public interface CallRecordingsService {
        @Post("/calling/recordings")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<RecordingStateResponseInternal>> startRecording(@HostParam("endpoint") String endpoint,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StartCallRecordingRequestInternal startCallRecording,
            @HeaderParam("Accept") String accept,
            @HeaderParam("repeatability-request-id") String repeatabilityRequestId,
            @HeaderParam("repeatability-first-sent") String repeatabilityFirstSent, Context context);

        @Get("/calling/recordings/{recordingId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<RecordingStateResponseInternal>> getRecordingProperties(@HostParam("endpoint") String endpoint,
            @PathParam("recordingId") String recordingId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/calling/recordings/{recordingId}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<Void>> stopRecording(@HostParam("endpoint") String endpoint,
            @PathParam("recordingId") String recordingId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/calling/recordings/{recordingId}:pause")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<Void>> pauseRecording(@HostParam("endpoint") String endpoint,
            @PathParam("recordingId") String recordingId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/calling/recordings/{recordingId}:resume")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<Void>> resumeRecording(@HostParam("endpoint") String endpoint,
            @PathParam("recordingId") String recordingId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Start recording the call.
     * 
     * @param startCallRecording The request body of start call recording request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RecordingStateResponseInternal>>
        startRecordingWithResponseAsync(StartCallRecordingRequestInternal startCallRecording) {
        return FluxUtil.withContext(context -> startRecordingWithResponseAsync(startCallRecording, context));
    }

    /**
     * Start recording the call.
     * 
     * @param startCallRecording The request body of start call recording request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RecordingStateResponseInternal>>
        startRecordingWithResponseAsync(StartCallRecordingRequestInternal startCallRecording, Context context) {
        final String accept = "application/json";
        return service.startRecording(this.client.getEndpoint(), this.client.getApiVersion(), startCallRecording,
            accept, CoreUtils.randomUuid().toString(), DateTimeRfc1123.toRfc1123String(OffsetDateTime.now()), context);
    }

    /**
     * Start recording the call.
     * 
     * @param startCallRecording The request body of start call recording request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RecordingStateResponseInternal>
        startRecordingAsync(StartCallRecordingRequestInternal startCallRecording) {
        return startRecordingWithResponseAsync(startCallRecording).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Start recording the call.
     * 
     * @param startCallRecording The request body of start call recording request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RecordingStateResponseInternal>
        startRecordingAsync(StartCallRecordingRequestInternal startCallRecording, Context context) {
        return startRecordingWithResponseAsync(startCallRecording, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Start recording the call.
     * 
     * @param startCallRecording The request body of start call recording request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RecordingStateResponseInternal>
        startRecordingWithResponse(StartCallRecordingRequestInternal startCallRecording, Context context) {
        return startRecordingWithResponseAsync(startCallRecording, context).block();
    }

    /**
     * Start recording the call.
     * 
     * @param startCallRecording The request body of start call recording request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RecordingStateResponseInternal startRecording(StartCallRecordingRequestInternal startCallRecording) {
        return startRecordingWithResponse(startCallRecording, Context.NONE).getValue();
    }

    /**
     * Get call recording properties.
     * 
     * @param recordingId The recording id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return call recording properties along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RecordingStateResponseInternal>> getRecordingPropertiesWithResponseAsync(String recordingId) {
        return FluxUtil.withContext(context -> getRecordingPropertiesWithResponseAsync(recordingId, context));
    }

    /**
     * Get call recording properties.
     * 
     * @param recordingId The recording id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return call recording properties along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RecordingStateResponseInternal>> getRecordingPropertiesWithResponseAsync(String recordingId,
        Context context) {
        final String accept = "application/json";
        return service.getRecordingProperties(this.client.getEndpoint(), recordingId, this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Get call recording properties.
     * 
     * @param recordingId The recording id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return call recording properties on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RecordingStateResponseInternal> getRecordingPropertiesAsync(String recordingId) {
        return getRecordingPropertiesWithResponseAsync(recordingId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get call recording properties.
     * 
     * @param recordingId The recording id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return call recording properties on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RecordingStateResponseInternal> getRecordingPropertiesAsync(String recordingId, Context context) {
        return getRecordingPropertiesWithResponseAsync(recordingId, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get call recording properties.
     * 
     * @param recordingId The recording id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return call recording properties along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RecordingStateResponseInternal> getRecordingPropertiesWithResponse(String recordingId,
        Context context) {
        return getRecordingPropertiesWithResponseAsync(recordingId, context).block();
    }

    /**
     * Get call recording properties.
     * 
     * @param recordingId The recording id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return call recording properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RecordingStateResponseInternal getRecordingProperties(String recordingId) {
        return getRecordingPropertiesWithResponse(recordingId, Context.NONE).getValue();
    }

    /**
     * Stop recording the call.
     * 
     * @param recordingId The recording id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> stopRecordingWithResponseAsync(String recordingId) {
        return FluxUtil.withContext(context -> stopRecordingWithResponseAsync(recordingId, context));
    }

    /**
     * Stop recording the call.
     * 
     * @param recordingId The recording id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> stopRecordingWithResponseAsync(String recordingId, Context context) {
        final String accept = "application/json";
        return service.stopRecording(this.client.getEndpoint(), recordingId, this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Stop recording the call.
     * 
     * @param recordingId The recording id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> stopRecordingAsync(String recordingId) {
        return stopRecordingWithResponseAsync(recordingId).flatMap(ignored -> Mono.empty());
    }

    /**
     * Stop recording the call.
     * 
     * @param recordingId The recording id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> stopRecordingAsync(String recordingId, Context context) {
        return stopRecordingWithResponseAsync(recordingId, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Stop recording the call.
     * 
     * @param recordingId The recording id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> stopRecordingWithResponse(String recordingId, Context context) {
        return stopRecordingWithResponseAsync(recordingId, context).block();
    }

    /**
     * Stop recording the call.
     * 
     * @param recordingId The recording id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void stopRecording(String recordingId) {
        stopRecordingWithResponse(recordingId, Context.NONE);
    }

    /**
     * Pause recording the call.
     * 
     * @param recordingId The recording id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> pauseRecordingWithResponseAsync(String recordingId) {
        return FluxUtil.withContext(context -> pauseRecordingWithResponseAsync(recordingId, context));
    }

    /**
     * Pause recording the call.
     * 
     * @param recordingId The recording id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> pauseRecordingWithResponseAsync(String recordingId, Context context) {
        final String accept = "application/json";
        return service.pauseRecording(this.client.getEndpoint(), recordingId, this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Pause recording the call.
     * 
     * @param recordingId The recording id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> pauseRecordingAsync(String recordingId) {
        return pauseRecordingWithResponseAsync(recordingId).flatMap(ignored -> Mono.empty());
    }

    /**
     * Pause recording the call.
     * 
     * @param recordingId The recording id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> pauseRecordingAsync(String recordingId, Context context) {
        return pauseRecordingWithResponseAsync(recordingId, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Pause recording the call.
     * 
     * @param recordingId The recording id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> pauseRecordingWithResponse(String recordingId, Context context) {
        return pauseRecordingWithResponseAsync(recordingId, context).block();
    }

    /**
     * Pause recording the call.
     * 
     * @param recordingId The recording id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void pauseRecording(String recordingId) {
        pauseRecordingWithResponse(recordingId, Context.NONE);
    }

    /**
     * Resume recording the call.
     * 
     * @param recordingId The recording id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> resumeRecordingWithResponseAsync(String recordingId) {
        return FluxUtil.withContext(context -> resumeRecordingWithResponseAsync(recordingId, context));
    }

    /**
     * Resume recording the call.
     * 
     * @param recordingId The recording id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> resumeRecordingWithResponseAsync(String recordingId, Context context) {
        final String accept = "application/json";
        return service.resumeRecording(this.client.getEndpoint(), recordingId, this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Resume recording the call.
     * 
     * @param recordingId The recording id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> resumeRecordingAsync(String recordingId) {
        return resumeRecordingWithResponseAsync(recordingId).flatMap(ignored -> Mono.empty());
    }

    /**
     * Resume recording the call.
     * 
     * @param recordingId The recording id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> resumeRecordingAsync(String recordingId, Context context) {
        return resumeRecordingWithResponseAsync(recordingId, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Resume recording the call.
     * 
     * @param recordingId The recording id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> resumeRecordingWithResponse(String recordingId, Context context) {
        return resumeRecordingWithResponseAsync(recordingId, context).block();
    }

    /**
     * Resume recording the call.
     * 
     * @param recordingId The recording id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void resumeRecording(String recordingId) {
        resumeRecordingWithResponse(recordingId, Context.NONE);
    }
}
