// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation;

import com.azure.communication.callautomation.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.callautomation.implementation.models.ContinuousDtmfRecognitionRequestInternal;
import com.azure.communication.callautomation.implementation.models.HoldRequest;
import com.azure.communication.callautomation.implementation.models.PlayRequest;
import com.azure.communication.callautomation.implementation.models.RecognizeRequest;
import com.azure.communication.callautomation.implementation.models.SendDtmfTonesRequestInternal;
import com.azure.communication.callautomation.implementation.models.SendDtmfTonesResultInternal;
import com.azure.communication.callautomation.implementation.models.StartMediaStreamingRequest;
import com.azure.communication.callautomation.implementation.models.StartTranscriptionRequestInternal;
import com.azure.communication.callautomation.implementation.models.StopMediaStreamingRequest;
import com.azure.communication.callautomation.implementation.models.StopTranscriptionRequestInternal;
import com.azure.communication.callautomation.implementation.models.UnholdRequest;
import com.azure.communication.callautomation.implementation.models.UpdateTranscriptionRequestInternal;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in CallMedias.
 */
public final class CallMediasImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final CallMediasService service;

    /**
     * The service client containing this operation class.
     */
    private final AzureCommunicationCallAutomationServiceImpl client;

    /**
     * Initializes an instance of CallMediasImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    CallMediasImpl(AzureCommunicationCallAutomationServiceImpl client) {
        this.service
            = RestProxy.create(CallMediasService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureCommunicationCallAutomationServiceCallMedias to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{endpoint}")
    @ServiceInterface(name = "AzureCommunicationCallAutomationServiceCallMedias")
    public interface CallMediasService {
        @Post("/calling/callConnections/{callConnectionId}:play")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<Void>> play(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") PlayRequest playRequest, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/calling/callConnections/{callConnectionId}:startTranscription")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<Void>> startTranscription(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StartTranscriptionRequestInternal startTranscriptionRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/calling/callConnections/{callConnectionId}:stopTranscription")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<Void>> stopTranscription(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StopTranscriptionRequestInternal stopTranscriptionRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/calling/callConnections/{callConnectionId}:updateTranscription")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<Void>> updateTranscription(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") UpdateTranscriptionRequestInternal updateTranscriptionRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/calling/callConnections/{callConnectionId}:cancelAllMediaOperations")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<Void>> cancelAllMediaOperations(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/calling/callConnections/{callConnectionId}:recognize")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<Void>> recognize(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") RecognizeRequest recognizeRequest, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/calling/callConnections/{callConnectionId}:startContinuousDtmfRecognition")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<Void>> startContinuousDtmfRecognition(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/calling/callConnections/{callConnectionId}:stopContinuousDtmfRecognition")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<Void>> stopContinuousDtmfRecognition(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/calling/callConnections/{callConnectionId}:sendDtmfTones")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<SendDtmfTonesResultInternal>> sendDtmfTones(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SendDtmfTonesRequestInternal sendDtmfTonesRequest,
            @HeaderParam("Accept") String accept,
            @HeaderParam("repeatability-request-id") String repeatabilityRequestId,
            @HeaderParam("repeatability-first-sent") String repeatabilityFirstSent, Context context);

        @Post("/calling/callConnections/{callConnectionId}:hold")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<Void>> hold(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") HoldRequest holdRequest, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/calling/callConnections/{callConnectionId}:unhold")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<Void>> unhold(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") UnholdRequest unholdRequest, @HeaderParam("Accept") String accept,
            Context context);

        @Post("/calling/callConnections/{callConnectionId}:startMediaStreaming")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<Void>> startMediaStreaming(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StartMediaStreamingRequest startMediaStreamingRequest,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/calling/callConnections/{callConnectionId}:stopMediaStreaming")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<Void>> stopMediaStreaming(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") StopMediaStreamingRequest stopMediaStreamingRequest,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Plays audio to participants in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param playRequest play request payload.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> playWithResponseAsync(String callConnectionId, PlayRequest playRequest) {
        return FluxUtil.withContext(context -> playWithResponseAsync(callConnectionId, playRequest, context));
    }

    /**
     * Plays audio to participants in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param playRequest play request payload.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> playWithResponseAsync(String callConnectionId, PlayRequest playRequest,
        Context context) {
        final String accept = "application/json";
        return service.play(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), playRequest,
            accept, context);
    }

    /**
     * Plays audio to participants in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param playRequest play request payload.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> playAsync(String callConnectionId, PlayRequest playRequest) {
        return playWithResponseAsync(callConnectionId, playRequest).flatMap(ignored -> Mono.empty());
    }

    /**
     * Plays audio to participants in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param playRequest play request payload.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> playAsync(String callConnectionId, PlayRequest playRequest, Context context) {
        return playWithResponseAsync(callConnectionId, playRequest, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Plays audio to participants in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param playRequest play request payload.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> playWithResponse(String callConnectionId, PlayRequest playRequest, Context context) {
        return playWithResponseAsync(callConnectionId, playRequest, context).block();
    }

    /**
     * Plays audio to participants in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param playRequest play request payload.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void play(String callConnectionId, PlayRequest playRequest) {
        playWithResponse(callConnectionId, playRequest, Context.NONE);
    }

    /**
     * Starts transcription in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param startTranscriptionRequest The startTranscriptionRequest parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> startTranscriptionWithResponseAsync(String callConnectionId,
        StartTranscriptionRequestInternal startTranscriptionRequest) {
        return FluxUtil.withContext(
            context -> startTranscriptionWithResponseAsync(callConnectionId, startTranscriptionRequest, context));
    }

    /**
     * Starts transcription in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param startTranscriptionRequest The startTranscriptionRequest parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> startTranscriptionWithResponseAsync(String callConnectionId,
        StartTranscriptionRequestInternal startTranscriptionRequest, Context context) {
        final String accept = "application/json";
        return service.startTranscription(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(),
            startTranscriptionRequest, accept, context);
    }

    /**
     * Starts transcription in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param startTranscriptionRequest The startTranscriptionRequest parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> startTranscriptionAsync(String callConnectionId,
        StartTranscriptionRequestInternal startTranscriptionRequest) {
        return startTranscriptionWithResponseAsync(callConnectionId, startTranscriptionRequest)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Starts transcription in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param startTranscriptionRequest The startTranscriptionRequest parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> startTranscriptionAsync(String callConnectionId,
        StartTranscriptionRequestInternal startTranscriptionRequest, Context context) {
        return startTranscriptionWithResponseAsync(callConnectionId, startTranscriptionRequest, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Starts transcription in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param startTranscriptionRequest The startTranscriptionRequest parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> startTranscriptionWithResponse(String callConnectionId,
        StartTranscriptionRequestInternal startTranscriptionRequest, Context context) {
        return startTranscriptionWithResponseAsync(callConnectionId, startTranscriptionRequest, context).block();
    }

    /**
     * Starts transcription in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param startTranscriptionRequest The startTranscriptionRequest parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void startTranscription(String callConnectionId,
        StartTranscriptionRequestInternal startTranscriptionRequest) {
        startTranscriptionWithResponse(callConnectionId, startTranscriptionRequest, Context.NONE);
    }

    /**
     * Stops transcription in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param stopTranscriptionRequest stop transcription request payload.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> stopTranscriptionWithResponseAsync(String callConnectionId,
        StopTranscriptionRequestInternal stopTranscriptionRequest) {
        return FluxUtil.withContext(
            context -> stopTranscriptionWithResponseAsync(callConnectionId, stopTranscriptionRequest, context));
    }

    /**
     * Stops transcription in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param stopTranscriptionRequest stop transcription request payload.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> stopTranscriptionWithResponseAsync(String callConnectionId,
        StopTranscriptionRequestInternal stopTranscriptionRequest, Context context) {
        final String accept = "application/json";
        return service.stopTranscription(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(),
            stopTranscriptionRequest, accept, context);
    }

    /**
     * Stops transcription in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param stopTranscriptionRequest stop transcription request payload.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> stopTranscriptionAsync(String callConnectionId,
        StopTranscriptionRequestInternal stopTranscriptionRequest) {
        return stopTranscriptionWithResponseAsync(callConnectionId, stopTranscriptionRequest)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Stops transcription in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param stopTranscriptionRequest stop transcription request payload.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> stopTranscriptionAsync(String callConnectionId,
        StopTranscriptionRequestInternal stopTranscriptionRequest, Context context) {
        return stopTranscriptionWithResponseAsync(callConnectionId, stopTranscriptionRequest, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Stops transcription in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param stopTranscriptionRequest stop transcription request payload.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> stopTranscriptionWithResponse(String callConnectionId,
        StopTranscriptionRequestInternal stopTranscriptionRequest, Context context) {
        return stopTranscriptionWithResponseAsync(callConnectionId, stopTranscriptionRequest, context).block();
    }

    /**
     * Stops transcription in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param stopTranscriptionRequest stop transcription request payload.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void stopTranscription(String callConnectionId, StopTranscriptionRequestInternal stopTranscriptionRequest) {
        stopTranscriptionWithResponse(callConnectionId, stopTranscriptionRequest, Context.NONE);
    }

    /**
     * UpdateTranscription Api.
     * 
     * API to change transcription language.
     * 
     * @param callConnectionId The call connection id.
     * @param updateTranscriptionRequest The UpdateTranscription request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateTranscriptionWithResponseAsync(String callConnectionId,
        UpdateTranscriptionRequestInternal updateTranscriptionRequest) {
        return FluxUtil.withContext(
            context -> updateTranscriptionWithResponseAsync(callConnectionId, updateTranscriptionRequest, context));
    }

    /**
     * UpdateTranscription Api.
     * 
     * API to change transcription language.
     * 
     * @param callConnectionId The call connection id.
     * @param updateTranscriptionRequest The UpdateTranscription request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateTranscriptionWithResponseAsync(String callConnectionId,
        UpdateTranscriptionRequestInternal updateTranscriptionRequest, Context context) {
        final String accept = "application/json";
        return service.updateTranscription(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(),
            updateTranscriptionRequest, accept, context);
    }

    /**
     * UpdateTranscription Api.
     * 
     * API to change transcription language.
     * 
     * @param callConnectionId The call connection id.
     * @param updateTranscriptionRequest The UpdateTranscription request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateTranscriptionAsync(String callConnectionId,
        UpdateTranscriptionRequestInternal updateTranscriptionRequest) {
        return updateTranscriptionWithResponseAsync(callConnectionId, updateTranscriptionRequest)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * UpdateTranscription Api.
     * 
     * API to change transcription language.
     * 
     * @param callConnectionId The call connection id.
     * @param updateTranscriptionRequest The UpdateTranscription request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateTranscriptionAsync(String callConnectionId,
        UpdateTranscriptionRequestInternal updateTranscriptionRequest, Context context) {
        return updateTranscriptionWithResponseAsync(callConnectionId, updateTranscriptionRequest, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * UpdateTranscription Api.
     * 
     * API to change transcription language.
     * 
     * @param callConnectionId The call connection id.
     * @param updateTranscriptionRequest The UpdateTranscription request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateTranscriptionWithResponse(String callConnectionId,
        UpdateTranscriptionRequestInternal updateTranscriptionRequest, Context context) {
        return updateTranscriptionWithResponseAsync(callConnectionId, updateTranscriptionRequest, context).block();
    }

    /**
     * UpdateTranscription Api.
     * 
     * API to change transcription language.
     * 
     * @param callConnectionId The call connection id.
     * @param updateTranscriptionRequest The UpdateTranscription request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateTranscription(String callConnectionId,
        UpdateTranscriptionRequestInternal updateTranscriptionRequest) {
        updateTranscriptionWithResponse(callConnectionId, updateTranscriptionRequest, Context.NONE);
    }

    /**
     * Cancel all media operations in a call.
     * 
     * @param callConnectionId The call connection id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> cancelAllMediaOperationsWithResponseAsync(String callConnectionId) {
        return FluxUtil.withContext(context -> cancelAllMediaOperationsWithResponseAsync(callConnectionId, context));
    }

    /**
     * Cancel all media operations in a call.
     * 
     * @param callConnectionId The call connection id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> cancelAllMediaOperationsWithResponseAsync(String callConnectionId, Context context) {
        final String accept = "application/json";
        return service.cancelAllMediaOperations(this.client.getEndpoint(), callConnectionId,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Cancel all media operations in a call.
     * 
     * @param callConnectionId The call connection id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> cancelAllMediaOperationsAsync(String callConnectionId) {
        return cancelAllMediaOperationsWithResponseAsync(callConnectionId).flatMap(ignored -> Mono.empty());
    }

    /**
     * Cancel all media operations in a call.
     * 
     * @param callConnectionId The call connection id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> cancelAllMediaOperationsAsync(String callConnectionId, Context context) {
        return cancelAllMediaOperationsWithResponseAsync(callConnectionId, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Cancel all media operations in a call.
     * 
     * @param callConnectionId The call connection id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> cancelAllMediaOperationsWithResponse(String callConnectionId, Context context) {
        return cancelAllMediaOperationsWithResponseAsync(callConnectionId, context).block();
    }

    /**
     * Cancel all media operations in a call.
     * 
     * @param callConnectionId The call connection id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void cancelAllMediaOperations(String callConnectionId) {
        cancelAllMediaOperationsWithResponse(callConnectionId, Context.NONE);
    }

    /**
     * Recognize media from call.
     * 
     * @param callConnectionId The call connection id.
     * @param recognizeRequest The media recognize request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> recognizeWithResponseAsync(String callConnectionId, RecognizeRequest recognizeRequest) {
        return FluxUtil.withContext(context -> recognizeWithResponseAsync(callConnectionId, recognizeRequest, context));
    }

    /**
     * Recognize media from call.
     * 
     * @param callConnectionId The call connection id.
     * @param recognizeRequest The media recognize request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> recognizeWithResponseAsync(String callConnectionId, RecognizeRequest recognizeRequest,
        Context context) {
        final String accept = "application/json";
        return service.recognize(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(),
            recognizeRequest, accept, context);
    }

    /**
     * Recognize media from call.
     * 
     * @param callConnectionId The call connection id.
     * @param recognizeRequest The media recognize request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> recognizeAsync(String callConnectionId, RecognizeRequest recognizeRequest) {
        return recognizeWithResponseAsync(callConnectionId, recognizeRequest).flatMap(ignored -> Mono.empty());
    }

    /**
     * Recognize media from call.
     * 
     * @param callConnectionId The call connection id.
     * @param recognizeRequest The media recognize request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> recognizeAsync(String callConnectionId, RecognizeRequest recognizeRequest, Context context) {
        return recognizeWithResponseAsync(callConnectionId, recognizeRequest, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Recognize media from call.
     * 
     * @param callConnectionId The call connection id.
     * @param recognizeRequest The media recognize request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> recognizeWithResponse(String callConnectionId, RecognizeRequest recognizeRequest,
        Context context) {
        return recognizeWithResponseAsync(callConnectionId, recognizeRequest, context).block();
    }

    /**
     * Recognize media from call.
     * 
     * @param callConnectionId The call connection id.
     * @param recognizeRequest The media recognize request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void recognize(String callConnectionId, RecognizeRequest recognizeRequest) {
        recognizeWithResponse(callConnectionId, recognizeRequest, Context.NONE);
    }

    /**
     * Start continuous Dtmf recognition by subscribing to tones.
     * 
     * @param callConnectionId The call connection id.
     * @param continuousDtmfRecognitionRequest The continuous recognize request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> startContinuousDtmfRecognitionWithResponseAsync(String callConnectionId,
        ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest) {
        return FluxUtil.withContext(context -> startContinuousDtmfRecognitionWithResponseAsync(callConnectionId,
            continuousDtmfRecognitionRequest, context));
    }

    /**
     * Start continuous Dtmf recognition by subscribing to tones.
     * 
     * @param callConnectionId The call connection id.
     * @param continuousDtmfRecognitionRequest The continuous recognize request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> startContinuousDtmfRecognitionWithResponseAsync(String callConnectionId,
        ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest, Context context) {
        final String accept = "application/json";
        return service.startContinuousDtmfRecognition(this.client.getEndpoint(), callConnectionId,
            this.client.getApiVersion(), continuousDtmfRecognitionRequest, accept, context);
    }

    /**
     * Start continuous Dtmf recognition by subscribing to tones.
     * 
     * @param callConnectionId The call connection id.
     * @param continuousDtmfRecognitionRequest The continuous recognize request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> startContinuousDtmfRecognitionAsync(String callConnectionId,
        ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest) {
        return startContinuousDtmfRecognitionWithResponseAsync(callConnectionId, continuousDtmfRecognitionRequest)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Start continuous Dtmf recognition by subscribing to tones.
     * 
     * @param callConnectionId The call connection id.
     * @param continuousDtmfRecognitionRequest The continuous recognize request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> startContinuousDtmfRecognitionAsync(String callConnectionId,
        ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest, Context context) {
        return startContinuousDtmfRecognitionWithResponseAsync(callConnectionId, continuousDtmfRecognitionRequest,
            context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Start continuous Dtmf recognition by subscribing to tones.
     * 
     * @param callConnectionId The call connection id.
     * @param continuousDtmfRecognitionRequest The continuous recognize request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> startContinuousDtmfRecognitionWithResponse(String callConnectionId,
        ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest, Context context) {
        return startContinuousDtmfRecognitionWithResponseAsync(callConnectionId, continuousDtmfRecognitionRequest,
            context).block();
    }

    /**
     * Start continuous Dtmf recognition by subscribing to tones.
     * 
     * @param callConnectionId The call connection id.
     * @param continuousDtmfRecognitionRequest The continuous recognize request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void startContinuousDtmfRecognition(String callConnectionId,
        ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest) {
        startContinuousDtmfRecognitionWithResponse(callConnectionId, continuousDtmfRecognitionRequest, Context.NONE);
    }

    /**
     * Stop continuous Dtmf recognition by unsubscribing to tones.
     * 
     * @param callConnectionId The call connection id.
     * @param continuousDtmfRecognitionRequest The continuous recognize request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> stopContinuousDtmfRecognitionWithResponseAsync(String callConnectionId,
        ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest) {
        return FluxUtil.withContext(context -> stopContinuousDtmfRecognitionWithResponseAsync(callConnectionId,
            continuousDtmfRecognitionRequest, context));
    }

    /**
     * Stop continuous Dtmf recognition by unsubscribing to tones.
     * 
     * @param callConnectionId The call connection id.
     * @param continuousDtmfRecognitionRequest The continuous recognize request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> stopContinuousDtmfRecognitionWithResponseAsync(String callConnectionId,
        ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest, Context context) {
        final String accept = "application/json";
        return service.stopContinuousDtmfRecognition(this.client.getEndpoint(), callConnectionId,
            this.client.getApiVersion(), continuousDtmfRecognitionRequest, accept, context);
    }

    /**
     * Stop continuous Dtmf recognition by unsubscribing to tones.
     * 
     * @param callConnectionId The call connection id.
     * @param continuousDtmfRecognitionRequest The continuous recognize request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> stopContinuousDtmfRecognitionAsync(String callConnectionId,
        ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest) {
        return stopContinuousDtmfRecognitionWithResponseAsync(callConnectionId, continuousDtmfRecognitionRequest)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Stop continuous Dtmf recognition by unsubscribing to tones.
     * 
     * @param callConnectionId The call connection id.
     * @param continuousDtmfRecognitionRequest The continuous recognize request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> stopContinuousDtmfRecognitionAsync(String callConnectionId,
        ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest, Context context) {
        return stopContinuousDtmfRecognitionWithResponseAsync(callConnectionId, continuousDtmfRecognitionRequest,
            context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Stop continuous Dtmf recognition by unsubscribing to tones.
     * 
     * @param callConnectionId The call connection id.
     * @param continuousDtmfRecognitionRequest The continuous recognize request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> stopContinuousDtmfRecognitionWithResponse(String callConnectionId,
        ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest, Context context) {
        return stopContinuousDtmfRecognitionWithResponseAsync(callConnectionId, continuousDtmfRecognitionRequest,
            context).block();
    }

    /**
     * Stop continuous Dtmf recognition by unsubscribing to tones.
     * 
     * @param callConnectionId The call connection id.
     * @param continuousDtmfRecognitionRequest The continuous recognize request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void stopContinuousDtmfRecognition(String callConnectionId,
        ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest) {
        stopContinuousDtmfRecognitionWithResponse(callConnectionId, continuousDtmfRecognitionRequest, Context.NONE);
    }

    /**
     * Send dtmf tones.
     * 
     * @param callConnectionId The call connection id.
     * @param sendDtmfTonesRequest The send dtmf tones request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SendDtmfTonesResultInternal>> sendDtmfTonesWithResponseAsync(String callConnectionId,
        SendDtmfTonesRequestInternal sendDtmfTonesRequest) {
        return FluxUtil
            .withContext(context -> sendDtmfTonesWithResponseAsync(callConnectionId, sendDtmfTonesRequest, context));
    }

    /**
     * Send dtmf tones.
     * 
     * @param callConnectionId The call connection id.
     * @param sendDtmfTonesRequest The send dtmf tones request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SendDtmfTonesResultInternal>> sendDtmfTonesWithResponseAsync(String callConnectionId,
        SendDtmfTonesRequestInternal sendDtmfTonesRequest, Context context) {
        final String accept = "application/json";
        return service.sendDtmfTones(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(),
            sendDtmfTonesRequest, accept, CoreUtils.randomUuid().toString(),
            DateTimeRfc1123.toRfc1123String(OffsetDateTime.now()), context);
    }

    /**
     * Send dtmf tones.
     * 
     * @param callConnectionId The call connection id.
     * @param sendDtmfTonesRequest The send dtmf tones request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SendDtmfTonesResultInternal> sendDtmfTonesAsync(String callConnectionId,
        SendDtmfTonesRequestInternal sendDtmfTonesRequest) {
        return sendDtmfTonesWithResponseAsync(callConnectionId, sendDtmfTonesRequest)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Send dtmf tones.
     * 
     * @param callConnectionId The call connection id.
     * @param sendDtmfTonesRequest The send dtmf tones request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SendDtmfTonesResultInternal> sendDtmfTonesAsync(String callConnectionId,
        SendDtmfTonesRequestInternal sendDtmfTonesRequest, Context context) {
        return sendDtmfTonesWithResponseAsync(callConnectionId, sendDtmfTonesRequest, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Send dtmf tones.
     * 
     * @param callConnectionId The call connection id.
     * @param sendDtmfTonesRequest The send dtmf tones request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SendDtmfTonesResultInternal> sendDtmfTonesWithResponse(String callConnectionId,
        SendDtmfTonesRequestInternal sendDtmfTonesRequest, Context context) {
        return sendDtmfTonesWithResponseAsync(callConnectionId, sendDtmfTonesRequest, context).block();
    }

    /**
     * Send dtmf tones.
     * 
     * @param callConnectionId The call connection id.
     * @param sendDtmfTonesRequest The send dtmf tones request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SendDtmfTonesResultInternal sendDtmfTones(String callConnectionId,
        SendDtmfTonesRequestInternal sendDtmfTonesRequest) {
        return sendDtmfTonesWithResponse(callConnectionId, sendDtmfTonesRequest, Context.NONE).getValue();
    }

    /**
     * Hold participant from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param holdRequest The participants to be hold from the call.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> holdWithResponseAsync(String callConnectionId, HoldRequest holdRequest) {
        return FluxUtil.withContext(context -> holdWithResponseAsync(callConnectionId, holdRequest, context));
    }

    /**
     * Hold participant from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param holdRequest The participants to be hold from the call.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> holdWithResponseAsync(String callConnectionId, HoldRequest holdRequest,
        Context context) {
        final String accept = "application/json";
        return service.hold(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), holdRequest,
            accept, context);
    }

    /**
     * Hold participant from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param holdRequest The participants to be hold from the call.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> holdAsync(String callConnectionId, HoldRequest holdRequest) {
        return holdWithResponseAsync(callConnectionId, holdRequest).flatMap(ignored -> Mono.empty());
    }

    /**
     * Hold participant from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param holdRequest The participants to be hold from the call.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> holdAsync(String callConnectionId, HoldRequest holdRequest, Context context) {
        return holdWithResponseAsync(callConnectionId, holdRequest, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Hold participant from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param holdRequest The participants to be hold from the call.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> holdWithResponse(String callConnectionId, HoldRequest holdRequest, Context context) {
        return holdWithResponseAsync(callConnectionId, holdRequest, context).block();
    }

    /**
     * Hold participant from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param holdRequest The participants to be hold from the call.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void hold(String callConnectionId, HoldRequest holdRequest) {
        holdWithResponse(callConnectionId, holdRequest, Context.NONE);
    }

    /**
     * Unhold participants from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param unholdRequest The participants to be hold from the call.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> unholdWithResponseAsync(String callConnectionId, UnholdRequest unholdRequest) {
        return FluxUtil.withContext(context -> unholdWithResponseAsync(callConnectionId, unholdRequest, context));
    }

    /**
     * Unhold participants from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param unholdRequest The participants to be hold from the call.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> unholdWithResponseAsync(String callConnectionId, UnholdRequest unholdRequest,
        Context context) {
        final String accept = "application/json";
        return service.unhold(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), unholdRequest,
            accept, context);
    }

    /**
     * Unhold participants from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param unholdRequest The participants to be hold from the call.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> unholdAsync(String callConnectionId, UnholdRequest unholdRequest) {
        return unholdWithResponseAsync(callConnectionId, unholdRequest).flatMap(ignored -> Mono.empty());
    }

    /**
     * Unhold participants from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param unholdRequest The participants to be hold from the call.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> unholdAsync(String callConnectionId, UnholdRequest unholdRequest, Context context) {
        return unholdWithResponseAsync(callConnectionId, unholdRequest, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Unhold participants from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param unholdRequest The participants to be hold from the call.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> unholdWithResponse(String callConnectionId, UnholdRequest unholdRequest, Context context) {
        return unholdWithResponseAsync(callConnectionId, unholdRequest, context).block();
    }

    /**
     * Unhold participants from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param unholdRequest The participants to be hold from the call.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void unhold(String callConnectionId, UnholdRequest unholdRequest) {
        unholdWithResponse(callConnectionId, unholdRequest, Context.NONE);
    }

    /**
     * Starts media streaming in the call
     * 
     * Starts media streaming in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param startMediaStreamingRequest The startMediaStreamingRequest parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> startMediaStreamingWithResponseAsync(String callConnectionId,
        StartMediaStreamingRequest startMediaStreamingRequest) {
        return FluxUtil.withContext(
            context -> startMediaStreamingWithResponseAsync(callConnectionId, startMediaStreamingRequest, context));
    }

    /**
     * Starts media streaming in the call
     * 
     * Starts media streaming in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param startMediaStreamingRequest The startMediaStreamingRequest parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> startMediaStreamingWithResponseAsync(String callConnectionId,
        StartMediaStreamingRequest startMediaStreamingRequest, Context context) {
        final String accept = "application/json";
        return service.startMediaStreaming(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(),
            startMediaStreamingRequest, accept, context);
    }

    /**
     * Starts media streaming in the call
     * 
     * Starts media streaming in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param startMediaStreamingRequest The startMediaStreamingRequest parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> startMediaStreamingAsync(String callConnectionId,
        StartMediaStreamingRequest startMediaStreamingRequest) {
        return startMediaStreamingWithResponseAsync(callConnectionId, startMediaStreamingRequest)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Starts media streaming in the call
     * 
     * Starts media streaming in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param startMediaStreamingRequest The startMediaStreamingRequest parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> startMediaStreamingAsync(String callConnectionId,
        StartMediaStreamingRequest startMediaStreamingRequest, Context context) {
        return startMediaStreamingWithResponseAsync(callConnectionId, startMediaStreamingRequest, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Starts media streaming in the call
     * 
     * Starts media streaming in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param startMediaStreamingRequest The startMediaStreamingRequest parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> startMediaStreamingWithResponse(String callConnectionId,
        StartMediaStreamingRequest startMediaStreamingRequest, Context context) {
        return startMediaStreamingWithResponseAsync(callConnectionId, startMediaStreamingRequest, context).block();
    }

    /**
     * Starts media streaming in the call
     * 
     * Starts media streaming in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param startMediaStreamingRequest The startMediaStreamingRequest parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void startMediaStreaming(String callConnectionId, StartMediaStreamingRequest startMediaStreamingRequest) {
        startMediaStreamingWithResponse(callConnectionId, startMediaStreamingRequest, Context.NONE);
    }

    /**
     * Stops media streaming in the call
     * 
     * Stops media streaming in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param stopMediaStreamingRequest stop media streaming request payload.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> stopMediaStreamingWithResponseAsync(String callConnectionId,
        StopMediaStreamingRequest stopMediaStreamingRequest) {
        return FluxUtil.withContext(
            context -> stopMediaStreamingWithResponseAsync(callConnectionId, stopMediaStreamingRequest, context));
    }

    /**
     * Stops media streaming in the call
     * 
     * Stops media streaming in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param stopMediaStreamingRequest stop media streaming request payload.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> stopMediaStreamingWithResponseAsync(String callConnectionId,
        StopMediaStreamingRequest stopMediaStreamingRequest, Context context) {
        final String accept = "application/json";
        return service.stopMediaStreaming(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(),
            stopMediaStreamingRequest, accept, context);
    }

    /**
     * Stops media streaming in the call
     * 
     * Stops media streaming in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param stopMediaStreamingRequest stop media streaming request payload.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> stopMediaStreamingAsync(String callConnectionId,
        StopMediaStreamingRequest stopMediaStreamingRequest) {
        return stopMediaStreamingWithResponseAsync(callConnectionId, stopMediaStreamingRequest)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Stops media streaming in the call
     * 
     * Stops media streaming in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param stopMediaStreamingRequest stop media streaming request payload.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> stopMediaStreamingAsync(String callConnectionId,
        StopMediaStreamingRequest stopMediaStreamingRequest, Context context) {
        return stopMediaStreamingWithResponseAsync(callConnectionId, stopMediaStreamingRequest, context)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Stops media streaming in the call
     * 
     * Stops media streaming in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param stopMediaStreamingRequest stop media streaming request payload.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> stopMediaStreamingWithResponse(String callConnectionId,
        StopMediaStreamingRequest stopMediaStreamingRequest, Context context) {
        return stopMediaStreamingWithResponseAsync(callConnectionId, stopMediaStreamingRequest, context).block();
    }

    /**
     * Stops media streaming in the call
     * 
     * Stops media streaming in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param stopMediaStreamingRequest stop media streaming request payload.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void stopMediaStreaming(String callConnectionId, StopMediaStreamingRequest stopMediaStreamingRequest) {
        stopMediaStreamingWithResponse(callConnectionId, stopMediaStreamingRequest, Context.NONE);
    }
}
