// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.communication.callautomation.implementation;

import com.azure.communication.callautomation.implementation.models.AddParticipantRequestInternal;
import com.azure.communication.callautomation.implementation.models.AddParticipantResponseInternal;
import com.azure.communication.callautomation.implementation.models.CallConnectionPropertiesInternal;
import com.azure.communication.callautomation.implementation.models.CallParticipantInternal;
import com.azure.communication.callautomation.implementation.models.CancelAddParticipantRequest;
import com.azure.communication.callautomation.implementation.models.CancelAddParticipantResponse;
import com.azure.communication.callautomation.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.callautomation.implementation.models.GetParticipantsResponseInternal;
import com.azure.communication.callautomation.implementation.models.MuteParticipantsRequestInternal;
import com.azure.communication.callautomation.implementation.models.MuteParticipantsResultInternal;
import com.azure.communication.callautomation.implementation.models.RemoveParticipantRequestInternal;
import com.azure.communication.callautomation.implementation.models.RemoveParticipantResponseInternal;
import com.azure.communication.callautomation.implementation.models.TransferCallResponseInternal;
import com.azure.communication.callautomation.implementation.models.TransferToParticipantRequestInternal;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in CallConnections.
 */
public final class CallConnectionsImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final CallConnectionsService service;

    /**
     * The service client containing this operation class.
     */
    private final AzureCommunicationCallAutomationServiceImpl client;

    /**
     * Initializes an instance of CallConnectionsImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    CallConnectionsImpl(AzureCommunicationCallAutomationServiceImpl client) {
        this.service
            = RestProxy.create(CallConnectionsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for AzureCommunicationCallAutomationServiceCallConnections to be used by
     * the proxy service to perform REST calls.
     */
    @Host("{endpoint}")
    @ServiceInterface(name = "AzureCommunicationCallAutomationServiceCallConnections")
    public interface CallConnectionsService {
        @Get("/calling/callConnections/{callConnectionId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<CallConnectionPropertiesInternal>> getCall(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Delete("/calling/callConnections/{callConnectionId}")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<Void>> hangupCall(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/calling/callConnections/{callConnectionId}:terminate")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<Void>> terminateCall(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            @HeaderParam("repeatability-request-id") String repeatabilityRequestId,
            @HeaderParam("repeatability-first-sent") String repeatabilityFirstSent, Context context);

        @Post("/calling/callConnections/{callConnectionId}:transferToParticipant")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<TransferCallResponseInternal>> transferToParticipant(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") TransferToParticipantRequestInternal transferToParticipantRequest,
            @HeaderParam("Accept") String accept,
            @HeaderParam("repeatability-request-id") String repeatabilityRequestId,
            @HeaderParam("repeatability-first-sent") String repeatabilityFirstSent, Context context);

        @Get("/calling/callConnections/{callConnectionId}/participants")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<GetParticipantsResponseInternal>> getParticipants(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Post("/calling/callConnections/{callConnectionId}/participants:add")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<AddParticipantResponseInternal>> addParticipant(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") AddParticipantRequestInternal addParticipantRequest,
            @HeaderParam("Accept") String accept,
            @HeaderParam("repeatability-request-id") String repeatabilityRequestId,
            @HeaderParam("repeatability-first-sent") String repeatabilityFirstSent, Context context);

        @Post("/calling/callConnections/{callConnectionId}/participants:remove")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<RemoveParticipantResponseInternal>> removeParticipant(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") RemoveParticipantRequestInternal removeParticipantRequest,
            @HeaderParam("Accept") String accept,
            @HeaderParam("repeatability-request-id") String repeatabilityRequestId,
            @HeaderParam("repeatability-first-sent") String repeatabilityFirstSent, Context context);

        @Post("/calling/callConnections/{callConnectionId}/participants:mute")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<MuteParticipantsResultInternal>> mute(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") MuteParticipantsRequestInternal muteParticipantsRequest,
            @HeaderParam("Accept") String accept,
            @HeaderParam("repeatability-request-id") String repeatabilityRequestId,
            @HeaderParam("repeatability-first-sent") String repeatabilityFirstSent, Context context);

        @Post("/calling/callConnections/{callConnectionId}/participants:cancelAddParticipant")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<CancelAddParticipantResponse>> cancelAddParticipant(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") CancelAddParticipantRequest cancelAddParticipantRequest,
            @HeaderParam("Accept") String accept,
            @HeaderParam("repeatability-request-id") String repeatabilityRequestId,
            @HeaderParam("repeatability-first-sent") String repeatabilityFirstSent, Context context);

        @Get("/calling/callConnections/{callConnectionId}/participants/{participantRawId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<CallParticipantInternal>> getParticipant(@HostParam("endpoint") String endpoint,
            @PathParam("callConnectionId") String callConnectionId,
            @PathParam(value = "participantRawId", encoded = true) String participantRawId,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(CommunicationErrorResponseException.class)
        Mono<Response<GetParticipantsResponseInternal>> getParticipantsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("endpoint") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Get the detail properties of an ongoing call.
     * 
     * @param callConnectionId The call connection id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the detail properties of an ongoing call along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CallConnectionPropertiesInternal>> getCallWithResponseAsync(String callConnectionId) {
        return FluxUtil.withContext(context -> getCallWithResponseAsync(callConnectionId, context));
    }

    /**
     * Get the detail properties of an ongoing call.
     * 
     * @param callConnectionId The call connection id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the detail properties of an ongoing call along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CallConnectionPropertiesInternal>> getCallWithResponseAsync(String callConnectionId,
        Context context) {
        final String accept = "application/json";
        return service.getCall(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Get the detail properties of an ongoing call.
     * 
     * @param callConnectionId The call connection id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the detail properties of an ongoing call on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CallConnectionPropertiesInternal> getCallAsync(String callConnectionId) {
        return getCallWithResponseAsync(callConnectionId).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the detail properties of an ongoing call.
     * 
     * @param callConnectionId The call connection id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the detail properties of an ongoing call on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CallConnectionPropertiesInternal> getCallAsync(String callConnectionId, Context context) {
        return getCallWithResponseAsync(callConnectionId, context).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the detail properties of an ongoing call.
     * 
     * @param callConnectionId The call connection id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the detail properties of an ongoing call along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CallConnectionPropertiesInternal> getCallWithResponse(String callConnectionId, Context context) {
        return getCallWithResponseAsync(callConnectionId, context).block();
    }

    /**
     * Get the detail properties of an ongoing call.
     * 
     * @param callConnectionId The call connection id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the detail properties of an ongoing call.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CallConnectionPropertiesInternal getCall(String callConnectionId) {
        return getCallWithResponse(callConnectionId, Context.NONE).getValue();
    }

    /**
     * Hang up call automation service from the call. This will make call automation service leave the call, but does
     * not terminate if there are more than 1 caller in the call.
     * 
     * @param callConnectionId The call connection id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> hangupCallWithResponseAsync(String callConnectionId) {
        return FluxUtil.withContext(context -> hangupCallWithResponseAsync(callConnectionId, context));
    }

    /**
     * Hang up call automation service from the call. This will make call automation service leave the call, but does
     * not terminate if there are more than 1 caller in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> hangupCallWithResponseAsync(String callConnectionId, Context context) {
        final String accept = "application/json";
        return service.hangupCall(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Hang up call automation service from the call. This will make call automation service leave the call, but does
     * not terminate if there are more than 1 caller in the call.
     * 
     * @param callConnectionId The call connection id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> hangupCallAsync(String callConnectionId) {
        return hangupCallWithResponseAsync(callConnectionId).flatMap(ignored -> Mono.empty());
    }

    /**
     * Hang up call automation service from the call. This will make call automation service leave the call, but does
     * not terminate if there are more than 1 caller in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> hangupCallAsync(String callConnectionId, Context context) {
        return hangupCallWithResponseAsync(callConnectionId, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Hang up call automation service from the call. This will make call automation service leave the call, but does
     * not terminate if there are more than 1 caller in the call.
     * 
     * @param callConnectionId The call connection id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> hangupCallWithResponse(String callConnectionId, Context context) {
        return hangupCallWithResponseAsync(callConnectionId, context).block();
    }

    /**
     * Hang up call automation service from the call. This will make call automation service leave the call, but does
     * not terminate if there are more than 1 caller in the call.
     * 
     * @param callConnectionId The call connection id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void hangupCall(String callConnectionId) {
        hangupCallWithResponse(callConnectionId, Context.NONE);
    }

    /**
     * Terminate a call using CallConnectionId.
     * 
     * @param callConnectionId The terminate call request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> terminateCallWithResponseAsync(String callConnectionId) {
        return FluxUtil.withContext(context -> terminateCallWithResponseAsync(callConnectionId, context));
    }

    /**
     * Terminate a call using CallConnectionId.
     * 
     * @param callConnectionId The terminate call request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> terminateCallWithResponseAsync(String callConnectionId, Context context) {
        final String accept = "application/json";
        return service.terminateCall(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), accept,
            CoreUtils.randomUuid().toString(), DateTimeRfc1123.toRfc1123String(OffsetDateTime.now()), context);
    }

    /**
     * Terminate a call using CallConnectionId.
     * 
     * @param callConnectionId The terminate call request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> terminateCallAsync(String callConnectionId) {
        return terminateCallWithResponseAsync(callConnectionId).flatMap(ignored -> Mono.empty());
    }

    /**
     * Terminate a call using CallConnectionId.
     * 
     * @param callConnectionId The terminate call request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> terminateCallAsync(String callConnectionId, Context context) {
        return terminateCallWithResponseAsync(callConnectionId, context).flatMap(ignored -> Mono.empty());
    }

    /**
     * Terminate a call using CallConnectionId.
     * 
     * @param callConnectionId The terminate call request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> terminateCallWithResponse(String callConnectionId, Context context) {
        return terminateCallWithResponseAsync(callConnectionId, context).block();
    }

    /**
     * Terminate a call using CallConnectionId.
     * 
     * @param callConnectionId The terminate call request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void terminateCall(String callConnectionId) {
        terminateCallWithResponse(callConnectionId, Context.NONE);
    }

    /**
     * Transfer the call to a participant.
     * 
     * @param callConnectionId The call connection id.
     * @param transferToParticipantRequest The transfer to participant request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response payload for transferring the call along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<TransferCallResponseInternal>> transferToParticipantWithResponseAsync(String callConnectionId,
        TransferToParticipantRequestInternal transferToParticipantRequest) {
        return FluxUtil.withContext(
            context -> transferToParticipantWithResponseAsync(callConnectionId, transferToParticipantRequest, context));
    }

    /**
     * Transfer the call to a participant.
     * 
     * @param callConnectionId The call connection id.
     * @param transferToParticipantRequest The transfer to participant request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response payload for transferring the call along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<TransferCallResponseInternal>> transferToParticipantWithResponseAsync(String callConnectionId,
        TransferToParticipantRequestInternal transferToParticipantRequest, Context context) {
        final String accept = "application/json";
        return service.transferToParticipant(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(),
            transferToParticipantRequest, accept, CoreUtils.randomUuid().toString(),
            DateTimeRfc1123.toRfc1123String(OffsetDateTime.now()), context);
    }

    /**
     * Transfer the call to a participant.
     * 
     * @param callConnectionId The call connection id.
     * @param transferToParticipantRequest The transfer to participant request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response payload for transferring the call on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<TransferCallResponseInternal> transferToParticipantAsync(String callConnectionId,
        TransferToParticipantRequestInternal transferToParticipantRequest) {
        return transferToParticipantWithResponseAsync(callConnectionId, transferToParticipantRequest)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Transfer the call to a participant.
     * 
     * @param callConnectionId The call connection id.
     * @param transferToParticipantRequest The transfer to participant request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response payload for transferring the call on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<TransferCallResponseInternal> transferToParticipantAsync(String callConnectionId,
        TransferToParticipantRequestInternal transferToParticipantRequest, Context context) {
        return transferToParticipantWithResponseAsync(callConnectionId, transferToParticipantRequest, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Transfer the call to a participant.
     * 
     * @param callConnectionId The call connection id.
     * @param transferToParticipantRequest The transfer to participant request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response payload for transferring the call along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<TransferCallResponseInternal> transferToParticipantWithResponse(String callConnectionId,
        TransferToParticipantRequestInternal transferToParticipantRequest, Context context) {
        return transferToParticipantWithResponseAsync(callConnectionId, transferToParticipantRequest, context).block();
    }

    /**
     * Transfer the call to a participant.
     * 
     * @param callConnectionId The call connection id.
     * @param transferToParticipantRequest The transfer to participant request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response payload for transferring the call.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public TransferCallResponseInternal transferToParticipant(String callConnectionId,
        TransferToParticipantRequestInternal transferToParticipantRequest) {
        return transferToParticipantWithResponse(callConnectionId, transferToParticipantRequest, Context.NONE)
            .getValue();
    }

    /**
     * Get participants from a call. Recording and transcription bots are omitted from this list.
     * 
     * @param callConnectionId The call connection Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return participants from a call along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<CallParticipantInternal>> getParticipantsSinglePageAsync(String callConnectionId) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getParticipants(this.client.getEndpoint(), callConnectionId,
                this.client.getApiVersion(), accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Get participants from a call. Recording and transcription bots are omitted from this list.
     * 
     * @param callConnectionId The call connection Id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return participants from a call along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<CallParticipantInternal>> getParticipantsSinglePageAsync(String callConnectionId,
        Context context) {
        final String accept = "application/json";
        return service
            .getParticipants(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Get participants from a call. Recording and transcription bots are omitted from this list.
     * 
     * @param callConnectionId The call connection Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return participants from a call as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<CallParticipantInternal> getParticipantsAsync(String callConnectionId) {
        return new PagedFlux<>(() -> getParticipantsSinglePageAsync(callConnectionId),
            nextLink -> getParticipantsNextSinglePageAsync(nextLink));
    }

    /**
     * Get participants from a call. Recording and transcription bots are omitted from this list.
     * 
     * @param callConnectionId The call connection Id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return participants from a call as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<CallParticipantInternal> getParticipantsAsync(String callConnectionId, Context context) {
        return new PagedFlux<>(() -> getParticipantsSinglePageAsync(callConnectionId, context),
            nextLink -> getParticipantsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get participants from a call. Recording and transcription bots are omitted from this list.
     * 
     * @param callConnectionId The call connection Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return participants from a call along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<CallParticipantInternal> getParticipantsSinglePage(String callConnectionId) {
        return getParticipantsSinglePageAsync(callConnectionId).block();
    }

    /**
     * Get participants from a call. Recording and transcription bots are omitted from this list.
     * 
     * @param callConnectionId The call connection Id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return participants from a call along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<CallParticipantInternal> getParticipantsSinglePage(String callConnectionId, Context context) {
        return getParticipantsSinglePageAsync(callConnectionId, context).block();
    }

    /**
     * Get participants from a call. Recording and transcription bots are omitted from this list.
     * 
     * @param callConnectionId The call connection Id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return participants from a call as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CallParticipantInternal> getParticipants(String callConnectionId) {
        return new PagedIterable<>(getParticipantsAsync(callConnectionId));
    }

    /**
     * Get participants from a call. Recording and transcription bots are omitted from this list.
     * 
     * @param callConnectionId The call connection Id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return participants from a call as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<CallParticipantInternal> getParticipants(String callConnectionId, Context context) {
        return new PagedIterable<>(getParticipantsAsync(callConnectionId, context));
    }

    /**
     * Add a participant to the call.
     * 
     * @param callConnectionId The call connection Id.
     * @param addParticipantRequest The addParticipantRequest parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response payload for adding participants to the call along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AddParticipantResponseInternal>> addParticipantWithResponseAsync(String callConnectionId,
        AddParticipantRequestInternal addParticipantRequest) {
        return FluxUtil
            .withContext(context -> addParticipantWithResponseAsync(callConnectionId, addParticipantRequest, context));
    }

    /**
     * Add a participant to the call.
     * 
     * @param callConnectionId The call connection Id.
     * @param addParticipantRequest The addParticipantRequest parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response payload for adding participants to the call along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AddParticipantResponseInternal>> addParticipantWithResponseAsync(String callConnectionId,
        AddParticipantRequestInternal addParticipantRequest, Context context) {
        final String accept = "application/json";
        return service.addParticipant(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(),
            addParticipantRequest, accept, CoreUtils.randomUuid().toString(),
            DateTimeRfc1123.toRfc1123String(OffsetDateTime.now()), context);
    }

    /**
     * Add a participant to the call.
     * 
     * @param callConnectionId The call connection Id.
     * @param addParticipantRequest The addParticipantRequest parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response payload for adding participants to the call on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AddParticipantResponseInternal> addParticipantAsync(String callConnectionId,
        AddParticipantRequestInternal addParticipantRequest) {
        return addParticipantWithResponseAsync(callConnectionId, addParticipantRequest)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Add a participant to the call.
     * 
     * @param callConnectionId The call connection Id.
     * @param addParticipantRequest The addParticipantRequest parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response payload for adding participants to the call on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AddParticipantResponseInternal> addParticipantAsync(String callConnectionId,
        AddParticipantRequestInternal addParticipantRequest, Context context) {
        return addParticipantWithResponseAsync(callConnectionId, addParticipantRequest, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Add a participant to the call.
     * 
     * @param callConnectionId The call connection Id.
     * @param addParticipantRequest The addParticipantRequest parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response payload for adding participants to the call along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AddParticipantResponseInternal> addParticipantWithResponse(String callConnectionId,
        AddParticipantRequestInternal addParticipantRequest, Context context) {
        return addParticipantWithResponseAsync(callConnectionId, addParticipantRequest, context).block();
    }

    /**
     * Add a participant to the call.
     * 
     * @param callConnectionId The call connection Id.
     * @param addParticipantRequest The addParticipantRequest parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response payload for adding participants to the call.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AddParticipantResponseInternal addParticipant(String callConnectionId,
        AddParticipantRequestInternal addParticipantRequest) {
        return addParticipantWithResponse(callConnectionId, addParticipantRequest, Context.NONE).getValue();
    }

    /**
     * Remove a participant from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param removeParticipantRequest The participant to be removed from the call.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response payload for removing participants of the call along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RemoveParticipantResponseInternal>> removeParticipantWithResponseAsync(String callConnectionId,
        RemoveParticipantRequestInternal removeParticipantRequest) {
        return FluxUtil.withContext(
            context -> removeParticipantWithResponseAsync(callConnectionId, removeParticipantRequest, context));
    }

    /**
     * Remove a participant from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param removeParticipantRequest The participant to be removed from the call.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response payload for removing participants of the call along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RemoveParticipantResponseInternal>> removeParticipantWithResponseAsync(String callConnectionId,
        RemoveParticipantRequestInternal removeParticipantRequest, Context context) {
        final String accept = "application/json";
        return service.removeParticipant(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(),
            removeParticipantRequest, accept, CoreUtils.randomUuid().toString(),
            DateTimeRfc1123.toRfc1123String(OffsetDateTime.now()), context);
    }

    /**
     * Remove a participant from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param removeParticipantRequest The participant to be removed from the call.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response payload for removing participants of the call on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RemoveParticipantResponseInternal> removeParticipantAsync(String callConnectionId,
        RemoveParticipantRequestInternal removeParticipantRequest) {
        return removeParticipantWithResponseAsync(callConnectionId, removeParticipantRequest)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Remove a participant from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param removeParticipantRequest The participant to be removed from the call.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response payload for removing participants of the call on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RemoveParticipantResponseInternal> removeParticipantAsync(String callConnectionId,
        RemoveParticipantRequestInternal removeParticipantRequest, Context context) {
        return removeParticipantWithResponseAsync(callConnectionId, removeParticipantRequest, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Remove a participant from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param removeParticipantRequest The participant to be removed from the call.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response payload for removing participants of the call along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RemoveParticipantResponseInternal> removeParticipantWithResponse(String callConnectionId,
        RemoveParticipantRequestInternal removeParticipantRequest, Context context) {
        return removeParticipantWithResponseAsync(callConnectionId, removeParticipantRequest, context).block();
    }

    /**
     * Remove a participant from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param removeParticipantRequest The participant to be removed from the call.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response payload for removing participants of the call.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RemoveParticipantResponseInternal removeParticipant(String callConnectionId,
        RemoveParticipantRequestInternal removeParticipantRequest) {
        return removeParticipantWithResponse(callConnectionId, removeParticipantRequest, Context.NONE).getValue();
    }

    /**
     * Mute participants from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param muteParticipantsRequest The participants to be muted from the call.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result payload for muting participants from the call along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MuteParticipantsResultInternal>> muteWithResponseAsync(String callConnectionId,
        MuteParticipantsRequestInternal muteParticipantsRequest) {
        return FluxUtil
            .withContext(context -> muteWithResponseAsync(callConnectionId, muteParticipantsRequest, context));
    }

    /**
     * Mute participants from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param muteParticipantsRequest The participants to be muted from the call.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result payload for muting participants from the call along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MuteParticipantsResultInternal>> muteWithResponseAsync(String callConnectionId,
        MuteParticipantsRequestInternal muteParticipantsRequest, Context context) {
        final String accept = "application/json";
        return service.mute(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(),
            muteParticipantsRequest, accept, CoreUtils.randomUuid().toString(),
            DateTimeRfc1123.toRfc1123String(OffsetDateTime.now()), context);
    }

    /**
     * Mute participants from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param muteParticipantsRequest The participants to be muted from the call.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result payload for muting participants from the call on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MuteParticipantsResultInternal> muteAsync(String callConnectionId,
        MuteParticipantsRequestInternal muteParticipantsRequest) {
        return muteWithResponseAsync(callConnectionId, muteParticipantsRequest)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Mute participants from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param muteParticipantsRequest The participants to be muted from the call.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result payload for muting participants from the call on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MuteParticipantsResultInternal> muteAsync(String callConnectionId,
        MuteParticipantsRequestInternal muteParticipantsRequest, Context context) {
        return muteWithResponseAsync(callConnectionId, muteParticipantsRequest, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Mute participants from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param muteParticipantsRequest The participants to be muted from the call.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result payload for muting participants from the call along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MuteParticipantsResultInternal> muteWithResponse(String callConnectionId,
        MuteParticipantsRequestInternal muteParticipantsRequest, Context context) {
        return muteWithResponseAsync(callConnectionId, muteParticipantsRequest, context).block();
    }

    /**
     * Mute participants from the call using identifier.
     * 
     * @param callConnectionId The call connection id.
     * @param muteParticipantsRequest The participants to be muted from the call.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the result payload for muting participants from the call.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MuteParticipantsResultInternal mute(String callConnectionId,
        MuteParticipantsRequestInternal muteParticipantsRequest) {
        return muteWithResponse(callConnectionId, muteParticipantsRequest, Context.NONE).getValue();
    }

    /**
     * Cancel add participant operation.
     * 
     * @param callConnectionId The call connection Id.
     * @param cancelAddParticipantRequest Cancellation request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response payload for cancel add participant request along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CancelAddParticipantResponse>> cancelAddParticipantWithResponseAsync(String callConnectionId,
        CancelAddParticipantRequest cancelAddParticipantRequest) {
        return FluxUtil.withContext(
            context -> cancelAddParticipantWithResponseAsync(callConnectionId, cancelAddParticipantRequest, context));
    }

    /**
     * Cancel add participant operation.
     * 
     * @param callConnectionId The call connection Id.
     * @param cancelAddParticipantRequest Cancellation request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response payload for cancel add participant request along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CancelAddParticipantResponse>> cancelAddParticipantWithResponseAsync(String callConnectionId,
        CancelAddParticipantRequest cancelAddParticipantRequest, Context context) {
        final String accept = "application/json";
        return service.cancelAddParticipant(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(),
            cancelAddParticipantRequest, accept, CoreUtils.randomUuid().toString(),
            DateTimeRfc1123.toRfc1123String(OffsetDateTime.now()), context);
    }

    /**
     * Cancel add participant operation.
     * 
     * @param callConnectionId The call connection Id.
     * @param cancelAddParticipantRequest Cancellation request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response payload for cancel add participant request on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CancelAddParticipantResponse> cancelAddParticipantAsync(String callConnectionId,
        CancelAddParticipantRequest cancelAddParticipantRequest) {
        return cancelAddParticipantWithResponseAsync(callConnectionId, cancelAddParticipantRequest)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Cancel add participant operation.
     * 
     * @param callConnectionId The call connection Id.
     * @param cancelAddParticipantRequest Cancellation request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response payload for cancel add participant request on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CancelAddParticipantResponse> cancelAddParticipantAsync(String callConnectionId,
        CancelAddParticipantRequest cancelAddParticipantRequest, Context context) {
        return cancelAddParticipantWithResponseAsync(callConnectionId, cancelAddParticipantRequest, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Cancel add participant operation.
     * 
     * @param callConnectionId The call connection Id.
     * @param cancelAddParticipantRequest Cancellation request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response payload for cancel add participant request along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CancelAddParticipantResponse> cancelAddParticipantWithResponse(String callConnectionId,
        CancelAddParticipantRequest cancelAddParticipantRequest, Context context) {
        return cancelAddParticipantWithResponseAsync(callConnectionId, cancelAddParticipantRequest, context).block();
    }

    /**
     * Cancel add participant operation.
     * 
     * @param callConnectionId The call connection Id.
     * @param cancelAddParticipantRequest Cancellation request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response payload for cancel add participant request.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CancelAddParticipantResponse cancelAddParticipant(String callConnectionId,
        CancelAddParticipantRequest cancelAddParticipantRequest) {
        return cancelAddParticipantWithResponse(callConnectionId, cancelAddParticipantRequest, Context.NONE).getValue();
    }

    /**
     * Get participant from a call.
     * 
     * @param callConnectionId The call connection Id.
     * @param participantRawId Raw id of the participant to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return participant from a call along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CallParticipantInternal>> getParticipantWithResponseAsync(String callConnectionId,
        String participantRawId) {
        return FluxUtil
            .withContext(context -> getParticipantWithResponseAsync(callConnectionId, participantRawId, context));
    }

    /**
     * Get participant from a call.
     * 
     * @param callConnectionId The call connection Id.
     * @param participantRawId Raw id of the participant to retrieve.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return participant from a call along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<CallParticipantInternal>> getParticipantWithResponseAsync(String callConnectionId,
        String participantRawId, Context context) {
        final String accept = "application/json";
        return service.getParticipant(this.client.getEndpoint(), callConnectionId, participantRawId,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Get participant from a call.
     * 
     * @param callConnectionId The call connection Id.
     * @param participantRawId Raw id of the participant to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return participant from a call on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CallParticipantInternal> getParticipantAsync(String callConnectionId, String participantRawId) {
        return getParticipantWithResponseAsync(callConnectionId, participantRawId)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get participant from a call.
     * 
     * @param callConnectionId The call connection Id.
     * @param participantRawId Raw id of the participant to retrieve.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return participant from a call on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CallParticipantInternal> getParticipantAsync(String callConnectionId, String participantRawId,
        Context context) {
        return getParticipantWithResponseAsync(callConnectionId, participantRawId, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get participant from a call.
     * 
     * @param callConnectionId The call connection Id.
     * @param participantRawId Raw id of the participant to retrieve.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return participant from a call along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<CallParticipantInternal> getParticipantWithResponse(String callConnectionId,
        String participantRawId, Context context) {
        return getParticipantWithResponseAsync(callConnectionId, participantRawId, context).block();
    }

    /**
     * Get participant from a call.
     * 
     * @param callConnectionId The call connection Id.
     * @param participantRawId Raw id of the participant to retrieve.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return participant from a call.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public CallParticipantInternal getParticipant(String callConnectionId, String participantRawId) {
        return getParticipantWithResponse(callConnectionId, participantRawId, Context.NONE).getValue();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response payload for getting participants of the call along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<CallParticipantInternal>> getParticipantsNextSinglePageAsync(String nextLink) {
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getParticipantsNext(nextLink, this.client.getEndpoint(), accept, context))
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response payload for getting participants of the call along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<CallParticipantInternal>> getParticipantsNextSinglePageAsync(String nextLink,
        Context context) {
        final String accept = "application/json";
        return service.getParticipantsNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().getValue(), res.getValue().getNextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response payload for getting participants of the call along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<CallParticipantInternal> getParticipantsNextSinglePage(String nextLink) {
        return getParticipantsNextSinglePageAsync(nextLink).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws CommunicationErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response payload for getting participants of the call along with {@link PagedResponse}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PagedResponse<CallParticipantInternal> getParticipantsNextSinglePage(String nextLink, Context context) {
        return getParticipantsNextSinglePageAsync(nextLink, context).block();
    }
}
