/*
 * Decompiled with CFR 0.152.
 */
package com.azure.aot.graalvm.support.implementation;

import com.azure.aot.graalvm.support.implementation.ClassReflectionAttributes;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public final class GraalVMFeatureUtils {
    public static void addProxyClass(Feature.FeatureAccess access, String ... interfaces) {
        ArrayList<Class> classList = new ArrayList<Class>();
        for (String anInterface : interfaces) {
            Class clazz = access.findClassByName(anInterface);
            if (clazz == null) continue;
            classList.add(clazz);
        }
        if (classList.size() == interfaces.length) {
            ((DynamicProxyRegistry)ImageSingletons.lookup(DynamicProxyRegistry.class)).addProxyClass(classList.toArray(new Class[interfaces.length]));
        }
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... s) {
        LinkedHashSet<T> set = new LinkedHashSet<T>(s.length);
        set.addAll(Arrays.asList(s));
        return set;
    }

    @SafeVarargs
    public static <T> Set<T[]> setsOf(T[] ... s) {
        LinkedHashSet<T[]> set = new LinkedHashSet<T[]>(s.length);
        Collections.addAll(set, s);
        return set;
    }

    public static Optional<Class<?>> findClass(Feature.FeatureAccess access, String className) {
        return Optional.ofNullable(access.findClassByName(className));
    }

    public static String[] interfaces(String ... strings) {
        return strings;
    }

    public static void registerClass(Feature.FeatureAccess access, ClassReflectionAttributes reflectiveClass) {
        GraalVMFeatureUtils.findClass(access, reflectiveClass.getName()).ifPresent(cls -> {
            RuntimeReflection.register((Class[])new Class[]{cls});
            if (reflectiveClass.includeDeclaredFields()) {
                RuntimeReflection.register((Field[])cls.getDeclaredFields());
            }
            if (reflectiveClass.includePublicFields()) {
                RuntimeReflection.register((Field[])cls.getFields());
            }
            if (reflectiveClass.includeDeclaredConstructors()) {
                RuntimeReflection.register((Executable[])cls.getDeclaredConstructors());
            }
            if (reflectiveClass.includePublicConstructors()) {
                RuntimeReflection.register((Executable[])cls.getConstructors());
            }
            if (reflectiveClass.includeDeclaredMethods()) {
                RuntimeReflection.register((Executable[])cls.getDeclaredMethods());
            }
            if (reflectiveClass.includePublicMethods()) {
                RuntimeReflection.register((Executable[])cls.getMethods());
            }
            if (reflectiveClass.includeDeclaredClasses()) {
                RuntimeReflection.register((Class[])cls.getDeclaredClasses());
            }
            if (reflectiveClass.includePublicClasses()) {
                RuntimeReflection.register((Class[])cls.getClasses());
            }
        });
    }

    public static Stream<String> getClassesForPackage(Feature.FeatureAccess access, String packageName, boolean recursive) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String packagePath = packageName.replace('.', '/');
        try {
            Enumeration<URL> resources = classLoader.getResources(packagePath);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                URLConnection connection = url.openConnection();
                if (!(connection instanceof JarURLConnection)) continue;
                return GraalVMFeatureUtils.findClassesInJar(access, ((JarURLConnection)connection).getJarFile(), packageName, recursive);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not enable reflective access to classes from package " + packageName, e);
        }
        return Stream.empty();
    }

    private static Stream<String> findClassesInJar(Feature.FeatureAccess access, JarFile jarFile, String packageName, boolean recursive) {
        ArrayList<String> classNames = new ArrayList<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        int packageDepth = GraalVMFeatureUtils.countInString(packageName, '.');
        while (entries.hasMoreElements()) {
            String fqcn;
            String entryName = entries.nextElement().getName();
            if (!recursive && GraalVMFeatureUtils.countInString(entryName, '/') - 1 != packageDepth || !entryName.endsWith(".class") || !(fqcn = entryName.replace('/', '.').replace(".class", "")).startsWith(packageName)) continue;
            classNames.add(fqcn);
        }
        return classNames.stream();
    }

    private static int countInString(String haystack, char needle) {
        int count = 0;
        for (int i = 0; i < haystack.length(); ++i) {
            if (haystack.charAt(i) != needle) continue;
            ++count;
        }
        return count;
    }

    private GraalVMFeatureUtils() {
    }
}

