/*
 * Decompiled with CFR 0.152.
 */
package com.azure.aot.graalvm.support.implementation;

import com.azure.aot.graalvm.support.implementation.ClassReflectionAttributes;
import com.azure.aot.graalvm.support.implementation.GraalVMFeatureUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.graalvm.nativeimage.hosted.Feature;

public interface GraalVMFeature
extends Feature {
    default public Set<String[]> getDynamicProxies() {
        return Collections.emptySet();
    }

    default public Set<ClassReflectionAttributes> getReflectionClasses() {
        return Collections.emptySet();
    }

    public String getRootPackage();

    default public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        super.beforeAnalysis(access);
        Set<ClassReflectionAttributes> reflectionClasses = this.getReflectionClasses();
        Set<String[]> dynamicProxies = this.getDynamicProxies();
        TreeSet missingClasses = new TreeSet(String::compareTo);
        reflectionClasses.forEach(cls -> {
            if (!GraalVMFeatureUtils.findClass((Feature.FeatureAccess)access, cls.getName()).isPresent()) {
                missingClasses.add(cls.getName());
            }
        });
        dynamicProxies.forEach(interfaces -> Arrays.stream(interfaces).forEach(cls -> {
            if (!GraalVMFeatureUtils.findClass((Feature.FeatureAccess)access, cls).isPresent()) {
                missingClasses.add(cls);
            }
        }));
        if (!missingClasses.isEmpty()) {
            System.out.println("AZURE SDK: Not registering Azure GraalVM support for " + this.getClass() + " as not all specified classes were found on classpath. Missing classes are:");
            missingClasses.forEach(cls -> System.out.println("  - " + cls));
        } else {
            System.out.println("AZURE SDK: Registering Azure GraalVM support for " + this.getClass());
            reflectionClasses.forEach(reflectiveClass -> GraalVMFeatureUtils.registerClass((Feature.FeatureAccess)access, reflectiveClass));
            dynamicProxies.forEach(interfaces -> GraalVMFeatureUtils.addProxyClass((Feature.FeatureAccess)access, interfaces));
            GraalVMFeatureUtils.getClassesForPackage((Feature.FeatureAccess)access, this.getRootPackage(), true).sorted().map(ClassReflectionAttributes::createWithAllDeclared).filter(reflectiveClass -> !reflectionClasses.contains(reflectiveClass)).forEach(reflectiveClass -> GraalVMFeatureUtils.registerClass((Feature.FeatureAccess)access, reflectiveClass));
        }
    }
}

