/*
 * Decompiled with CFR 0.152.
 */
package com.azure.aot.graalvm.support.implementation;

import java.util.EnumSet;
import java.util.Objects;

public final class ClassReflectionAttributes {
    private final String name;
    private final EnumSet<ReflectionAttributes> set;

    private ClassReflectionAttributes(String name, EnumSet<ReflectionAttributes> set) {
        this.name = Objects.requireNonNull(name);
        this.set = set;
    }

    public static ClassReflectionAttributes createWithAll(String name) {
        return ClassReflectionAttributes.create(name, EnumSet.allOf(ReflectionAttributes.class));
    }

    public static ClassReflectionAttributes create(String name, EnumSet<ReflectionAttributes> attributes) {
        return new ClassReflectionAttributes(name, attributes);
    }

    public static ClassReflectionAttributes createWithAllDeclared(String name) {
        return new ClassReflectionAttributes(name, EnumSet.of(ReflectionAttributes.DECLARED_CLASSES, ReflectionAttributes.DECLARED_FIELDS, ReflectionAttributes.DECLARED_CONSTRUCTORS, ReflectionAttributes.DECLARED_METHODS));
    }

    public static ClassReflectionAttributes createWithAllPublic(String name) {
        return new ClassReflectionAttributes(name, EnumSet.of(ReflectionAttributes.PUBLIC_CLASSES, ReflectionAttributes.PUBLIC_FIELDS, ReflectionAttributes.PUBLIC_CONSTRUCTORS, ReflectionAttributes.PUBLIC_METHODS));
    }

    public String getName() {
        return this.name;
    }

    public boolean includeDeclaredFields() {
        return this.set.contains((Object)ReflectionAttributes.DECLARED_FIELDS);
    }

    public boolean includePublicFields() {
        return this.set.contains((Object)ReflectionAttributes.PUBLIC_FIELDS);
    }

    public boolean includeDeclaredConstructors() {
        return this.set.contains((Object)ReflectionAttributes.DECLARED_CONSTRUCTORS);
    }

    public boolean includePublicConstructors() {
        return this.set.contains((Object)ReflectionAttributes.PUBLIC_CONSTRUCTORS);
    }

    public boolean includeDeclaredMethods() {
        return this.set.contains((Object)ReflectionAttributes.DECLARED_METHODS);
    }

    public boolean includePublicMethods() {
        return this.set.contains((Object)ReflectionAttributes.PUBLIC_METHODS);
    }

    public boolean includeDeclaredClasses() {
        return this.set.contains((Object)ReflectionAttributes.DECLARED_CLASSES);
    }

    public boolean includePublicClasses() {
        return this.set.contains((Object)ReflectionAttributes.PUBLIC_CLASSES);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassReflectionAttributes that = (ClassReflectionAttributes)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static enum ReflectionAttributes {
        DECLARED_FIELDS,
        PUBLIC_FIELDS,
        DECLARED_CONSTRUCTORS,
        PUBLIC_CONSTRUCTORS,
        DECLARED_METHODS,
        PUBLIC_METHODS,
        DECLARED_CLASSES,
        PUBLIC_CLASSES;

    }
}

