// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A specific representation of configurable options for Azure Machine Learning vector index when using it as an Azure
 * OpenAI chat extension.
 */
@Immutable
public final class AzureMachineLearningIndexChatExtensionConfiguration extends AzureChatExtensionConfiguration {

    /*
     * The parameters for the Azure Machine Learning vector index chat extension.
     */
    @Generated
    private final AzureMachineLearningIndexChatExtensionParameters parameters;

    /**
     * Get the parameters property: The parameters for the Azure Machine Learning vector index chat extension.
     *
     * @return the parameters value.
     */
    @Generated
    public AzureMachineLearningIndexChatExtensionParameters getParameters() {
        return this.parameters;
    }

    /**
     * Creates an instance of AzureMachineLearningIndexChatExtensionConfiguration class.
     *
     * @param parameters the parameters value to set.
     */
    @Generated
    public AzureMachineLearningIndexChatExtensionConfiguration(
        AzureMachineLearningIndexChatExtensionParameters parameters) {
        this.parameters = parameters;
    }

    /*
     * The label for the type of an Azure chat extension. This typically corresponds to a matching Azure resource.
     * Azure chat extensions are only compatible with Azure OpenAI.
     */
    @Generated
    private AzureChatExtensionType type = AzureChatExtensionType.AZURE_MACHINE_LEARNING_INDEX;

    /**
     * Get the type property: The label for the type of an Azure chat extension. This typically corresponds to a
     * matching Azure resource.
     * Azure chat extensions are only compatible with Azure OpenAI.
     *
     * @return the type value.
     */
    @Generated
    @Override
    public AzureChatExtensionType getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", this.parameters);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureMachineLearningIndexChatExtensionConfiguration from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureMachineLearningIndexChatExtensionConfiguration if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureMachineLearningIndexChatExtensionConfiguration.
     */
    @Generated
    public static AzureMachineLearningIndexChatExtensionConfiguration fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            AzureMachineLearningIndexChatExtensionParameters parameters = null;
            AzureChatExtensionType type = AzureChatExtensionType.AZURE_MACHINE_LEARNING_INDEX;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("parameters".equals(fieldName)) {
                    parameters = AzureMachineLearningIndexChatExtensionParameters.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = AzureChatExtensionType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            AzureMachineLearningIndexChatExtensionConfiguration deserializedAzureMachineLearningIndexChatExtensionConfiguration
                = new AzureMachineLearningIndexChatExtensionConfiguration(parameters);
            deserializedAzureMachineLearningIndexChatExtensionConfiguration.type = type;
            return deserializedAzureMachineLearningIndexChatExtensionConfiguration;
        });
    }
}
