/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.EmbeddingItem;
import com.azure.ai.openai.models.EmbeddingsUsage;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class Embeddings
implements JsonSerializable<Embeddings> {
    private final List<EmbeddingItem> data;
    private final EmbeddingsUsage usage;

    private Embeddings(List<EmbeddingItem> data, EmbeddingsUsage usage) {
        this.data = data;
        this.usage = usage;
    }

    public List<EmbeddingItem> getData() {
        return this.data;
    }

    public EmbeddingsUsage getUsage() {
        return this.usage;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("usage", (JsonSerializable)this.usage);
        return jsonWriter.writeEndObject();
    }

    public static Embeddings fromJson(JsonReader jsonReader) throws IOException {
        return (Embeddings)jsonReader.readObject(reader -> {
            List data = null;
            EmbeddingsUsage usage = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("data".equals(fieldName)) {
                    data = reader.readArray(reader1 -> EmbeddingItem.fromJson(reader1));
                    continue;
                }
                if ("usage".equals(fieldName)) {
                    usage = EmbeddingsUsage.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new Embeddings(data, usage);
        });
    }
}

