// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The state of the file.
 */
public final class FileState extends ExpandableStringEnum<FileState> {

    /**
     * The file has been uploaded but it's not yet processed. This state is not returned by Azure OpenAI and exposed
     * only for
     * compatibility. It can be categorized as an inactive state.
     */
    @Generated
    public static final FileState UPLOADED = fromString("uploaded");

    /**
     * The operation was created and is not queued to be processed in the future. It can be categorized as an inactive
     * state.
     */
    @Generated
    public static final FileState PENDING = fromString("pending");

    /**
     * The operation has started to be processed. It can be categorized as an active state.
     */
    @Generated
    public static final FileState RUNNING = fromString("running");

    /**
     * The operation has successfully processed and is ready for consumption. It can be categorized as a terminal state.
     */
    @Generated
    public static final FileState PROCESSED = fromString("processed");

    /**
     * The operation has completed processing with a failure and cannot be further consumed. It can be categorized as a
     * terminal state.
     */
    @Generated
    public static final FileState ERROR = fromString("error");

    /**
     * The entity is in the process to be deleted. This state is not returned by Azure OpenAI and exposed only for
     * compatibility.
     * It can be categorized as an active state.
     */
    @Generated
    public static final FileState DELETING = fromString("deleting");

    /**
     * The entity has been deleted but may still be referenced by other entities predating the deletion. It can be
     * categorized as a
     * terminal state.
     */
    @Generated
    public static final FileState DELETED = fromString("deleted");

    /**
     * Creates a new instance of FileState value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public FileState() {
    }

    /**
     * Creates or finds a FileState from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding FileState.
     */
    @Generated
    public static FileState fromString(String name) {
        return fromString(name, FileState.class);
    }

    /**
     * Gets known FileState values.
     *
     * @return known FileState values.
     */
    @Generated
    public static Collection<FileState> values() {
        return values(FileState.class);
    }
}
