// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The possible values denoting the intended usage of a file.
 */
public final class FilePurpose extends ExpandableStringEnum<FilePurpose> {

    /**
     * Indicates a file is used for fine tuning input.
     */
    @Generated
    public static final FilePurpose FINE_TUNE = fromString("fine-tune");

    /**
     * Indicates a file is used for fine tuning results.
     */
    @Generated
    public static final FilePurpose FINE_TUNE_RESULTS = fromString("fine-tune-results");

    /**
     * Indicates a file is used as input to assistants.
     */
    @Generated
    public static final FilePurpose ASSISTANTS = fromString("assistants");

    /**
     * Indicates a file is used as output by assistants.
     */
    @Generated
    public static final FilePurpose ASSISTANTS_OUTPUT = fromString("assistants_output");

    /**
     * Indicates a file is used as input to .
     */
    @Generated
    public static final FilePurpose BATCH = fromString("batch");

    /**
     * Indicates a file is used as output by a vector store batch operation.
     */
    @Generated
    public static final FilePurpose BATCH_OUTPUT = fromString("batch_output");

    /**
     * Indicates a file is used as input to a vision operation.
     */
    @Generated
    public static final FilePurpose VISION = fromString("vision");

    /**
     * Creates a new instance of FilePurpose value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public FilePurpose() {
    }

    /**
     * Creates or finds a FilePurpose from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding FilePurpose.
     */
    @Generated
    public static FilePurpose fromString(String name) {
        return fromString(name, FilePurpose.class);
    }

    /**
     * Gets known FilePurpose values.
     *
     * @return known FilePurpose values.
     */
    @Generated
    public static Collection<FilePurpose> values() {
        return values(FilePurpose.class);
    }
}
