// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import static com.azure.ai.openai.implementation.EmbeddingsUtils.convertBase64ToFloatList;
import static com.azure.ai.openai.implementation.EmbeddingsUtils.convertFloatListToBase64;

/**
 * Representation of a single embeddings relatedness comparison.
 */
@Immutable
public final class EmbeddingItem implements JsonSerializable<EmbeddingItem> {

    /**
     * Get the embedding property: List of embeddings value for the input prompt. These represent a measurement of the
     * vector-based relatedness of the provided input.
     *
     * @return the embedding value.
     */
    public List<Float> getEmbedding() {
        if (embeddingInFloat == null && embeddingBase64 != null) {
            embeddingInFloat = convertBase64ToFloatList(embeddingBase64);
        }
        return embeddingInFloat;
    }

    /**
     * Get the embedding property: List of embeddings value in base64 format for the input prompt.
     *
     * @return the embedding base64 encoded string.
     */
    public String getEmbeddingAsString() {
        if (embeddingBase64 == null && embeddingInFloat != null) {
            embeddingBase64 = convertFloatListToBase64(embeddingInFloat);
        }
        return embeddingBase64;
    }

    /*
     * Index of the prompt to which the EmbeddingItem corresponds.
     */
    @Generated
    private final int promptIndex;

    /**
     * Get the promptIndex property: Index of the prompt to which the EmbeddingItem corresponds.
     *
     * @return the promptIndex value.
     */
    @Generated
    public int getPromptIndex() {
        return this.promptIndex;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", promptIndex);
        if (embeddingBase64 != null) {
            jsonWriter.writeStringField("embedding", embeddingBase64);
        } else if (embeddingInFloat != null) {
            jsonWriter.writeArrayField("embedding", embeddingInFloat, JsonWriter::writeFloat);
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EmbeddingItem from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of EmbeddingItem if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the EmbeddingItem.
     */
    public static EmbeddingItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String embedding = null;
            List<Float> embeddingInFloat = null;
            int promptIndex = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("embedding".equals(fieldName)) {
                    JsonToken jsonToken = reader.currentToken();
                    if (jsonToken == JsonToken.STRING) {
                        embedding = reader.getString();
                    } else if (jsonToken == JsonToken.START_ARRAY) {
                        embeddingInFloat = reader.readArray(JsonReader::getFloat);
                    } else {
                        throw new IllegalStateException("Unexpected 'embedding' type found when deserializing"
                            + " EmbeddingItem JSON object: " + jsonToken);
                    }
                } else if ("index".equals(fieldName)) {
                    promptIndex = reader.getInt();
                } else {
                    reader.skipChildren();
                }
            }
            EmbeddingItem embeddingItem = new EmbeddingItem(embedding, promptIndex);
            embeddingItem.embeddingInFloat = embeddingInFloat;
            return embeddingItem;
        });
    }

    /**
     * Creates an instance of EmbeddingItem class.
     *
     * @param embeddingBase64 the embedding value to set.
     * @param promptIndex the promptIndex value to set.
     */
    private EmbeddingItem(String embeddingBase64, int promptIndex) {
        this.embeddingBase64 = embeddingBase64;
        this.promptIndex = promptIndex;
    }

    // Generated field, keep it to pass TypeSpec validation
    private List<Double> embedding;

    /*
     * List of embeddings value for the input prompt. These represent a measurement of the
     * vector-based relatedness of the provided input.
     */
    private List<Float> embeddingInFloat;

    /*
     * List of embeddings value in base64 format for the input prompt.
     */
    private String embeddingBase64;
}
