// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A list of Batch errors.
 */
@Immutable
public final class BatchErrorList implements JsonSerializable<BatchErrorList> {

    /*
     * The object type, which is always `list`.
     */
    @Generated
    private final String object = "list";

    /*
     * The list of Batch error data.
     */
    @Generated
    private List<BatchErrorDatum> data;

    /**
     * Creates an instance of BatchErrorList class.
     */
    @Generated
    private BatchErrorList() {
    }

    /**
     * Get the object property: The object type, which is always `list`.
     *
     * @return the object value.
     */
    @Generated
    public String getObject() {
        return this.object;
    }

    /**
     * Get the data property: The list of Batch error data.
     *
     * @return the data value.
     */
    @Generated
    public List<BatchErrorDatum> getData() {
        return this.data;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BatchErrorList from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of BatchErrorList if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BatchErrorList.
     */
    @Generated
    public static BatchErrorList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BatchErrorList deserializedBatchErrorList = new BatchErrorList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("data".equals(fieldName)) {
                    List<BatchErrorDatum> data = reader.readArray(reader1 -> BatchErrorDatum.fromJson(reader1));
                    deserializedBatchErrorList.data = data;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedBatchErrorList;
        });
    }
}
