/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.chaintest.domain;

import com.aventstack.chaintest.domain.ChainTestEntity;
import com.aventstack.chaintest.domain.ExecutionStage;
import com.aventstack.chaintest.domain.Result;
import com.aventstack.chaintest.domain.RunStats;
import com.aventstack.chaintest.domain.SystemInfo;
import com.aventstack.chaintest.domain.Tag;
import com.aventstack.chaintest.domain.TagStats;
import com.aventstack.chaintest.domain.Test;
import com.aventstack.chaintest.util.TimeUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Build
implements ChainTestEntity {
    private long id;
    private int projectId;
    private String projectName;
    private long startedAt = System.currentTimeMillis();
    private long endedAt;
    private long durationMs;
    private ExecutionStage executionStage = ExecutionStage.IN_PROGRESS;
    private String testRunner;
    private String name;
    private String result = Result.PASSED.getResult();
    @JsonIgnore
    private final Queue<RunStats> runStats = new ConcurrentLinkedQueue<RunStats>();
    @JsonIgnore
    private final Set<TagStats> tagStats = ConcurrentHashMap.newKeySet();
    private final Map<String, TagStats> tagStatsMonitor = new ConcurrentHashMap<String, TagStats>();
    private Set<Tag> tags = ConcurrentHashMap.newKeySet();
    private String gitRepository;
    private String gitBranch;
    private String gitCommitHash;
    private String gitTags;
    private String gitCommitMessage;
    private boolean isBDD;
    private List<SystemInfo> systemInfo;

    public Build() {
    }

    public Build(int projectId, String testRunner) {
        this(testRunner);
        this.projectId = projectId;
    }

    public Build(String projectName, String testRunner) {
        this(testRunner);
        this.projectName = projectName;
    }

    public Build(String testRunner) {
        this.testRunner = testRunner;
    }

    public void updateStats(Test test) {
        this.setEndedAt(System.currentTimeMillis());
        this.setResult(Result.computePriority(this.getResult(), test.getResult()).getResult());
        this.updateRunStats(test);
        this.updateTagStats(test);
        test.setIsBdd(this.isBDD());
    }

    private synchronized void updateRunStats(Test test) {
        RunStats stat = this.runStats.stream().filter(x -> x.getDepth() == test.getDepth()).findAny().orElseGet(() -> this.addRunStatsDepth(test.getDepth()));
        stat.update(test);
        for (Test t : test.getChildren()) {
            this.updateRunStats(t);
        }
    }

    private RunStats addRunStatsDepth(int depth) {
        RunStats stat = new RunStats(depth);
        this.runStats.add(stat);
        return stat;
    }

    private void updateTagStats(Test test) {
        if (null != test.getTags()) {
            this.addTags((Collection<Tag>)test.getTags());
            for (Tag tag : test.getTags()) {
                if (!this.tagStatsMonitor.containsKey(tag.getName() + test.getDepth())) {
                    TagStats ts = new TagStats(test.getDepth());
                    ts.setName(tag.getName());
                    this.tagStats.add(ts);
                    this.tagStatsMonitor.put(tag.getName() + test.getDepth(), ts);
                }
                this.tagStatsMonitor.get(tag.getName() + test.getDepth()).update(test);
                for (Test child : test.getChildren()) {
                    this.updateTagStats(child);
                }
            }
        }
    }

    public void complete(Result result) {
        this.setEndedAt(System.currentTimeMillis());
        this.setResult(result.getResult());
    }

    public void complete() {
        this.complete(Result.valueOf(this.result));
    }

    public void setEndedAt(long endedAt) {
        this.endedAt = endedAt;
        this.setDurationMs(endedAt - this.startedAt);
    }

    public String getDurationPretty() {
        return TimeUtil.getPrettyTime(this.getDurationMs());
    }

    public void addTags(List<String> tags) {
        if (null != tags) {
            Stream<Tag> t = tags.stream().map(Tag::new);
            this.addTags(t);
        }
    }

    public void addTags(Set<String> tags) {
        if (null != tags) {
            Stream<Tag> t = tags.stream().map(Tag::new);
            this.addTags(t);
        }
    }

    public void addTags(Collection<Tag> tags) {
        if (null != tags && !tags.isEmpty()) {
            this.tags.addAll(tags);
        }
    }

    public void addTags(Stream<Tag> tags) {
        if (null != tags) {
            tags.forEach(this.tags::add);
        }
    }

    public void setIsBdd(boolean val) {
        this.isBDD = val;
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public int getProjectId() {
        return this.projectId;
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public long getStartedAt() {
        return this.startedAt;
    }

    @Generated
    public long getEndedAt() {
        return this.endedAt;
    }

    @Generated
    public long getDurationMs() {
        return this.durationMs;
    }

    @Generated
    public ExecutionStage getExecutionStage() {
        return this.executionStage;
    }

    @Generated
    public String getTestRunner() {
        return this.testRunner;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getResult() {
        return this.result;
    }

    @Generated
    public Queue<RunStats> getRunStats() {
        return this.runStats;
    }

    @Generated
    public Set<TagStats> getTagStats() {
        return this.tagStats;
    }

    @Generated
    public Map<String, TagStats> getTagStatsMonitor() {
        return this.tagStatsMonitor;
    }

    @Generated
    public Set<Tag> getTags() {
        return this.tags;
    }

    @Generated
    public String getGitRepository() {
        return this.gitRepository;
    }

    @Generated
    public String getGitBranch() {
        return this.gitBranch;
    }

    @Generated
    public String getGitCommitHash() {
        return this.gitCommitHash;
    }

    @Generated
    public String getGitTags() {
        return this.gitTags;
    }

    @Generated
    public String getGitCommitMessage() {
        return this.gitCommitMessage;
    }

    @Generated
    public boolean isBDD() {
        return this.isBDD;
    }

    @Generated
    public List<SystemInfo> getSystemInfo() {
        return this.systemInfo;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setProjectId(int projectId) {
        this.projectId = projectId;
    }

    @Generated
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Generated
    public void setStartedAt(long startedAt) {
        this.startedAt = startedAt;
    }

    @Generated
    public void setDurationMs(long durationMs) {
        this.durationMs = durationMs;
    }

    @Generated
    public void setExecutionStage(ExecutionStage executionStage) {
        this.executionStage = executionStage;
    }

    @Generated
    public void setTestRunner(String testRunner) {
        this.testRunner = testRunner;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setResult(String result) {
        this.result = result;
    }

    @Generated
    public void setTags(Set<Tag> tags) {
        this.tags = tags;
    }

    @Generated
    public void setGitRepository(String gitRepository) {
        this.gitRepository = gitRepository;
    }

    @Generated
    public void setGitBranch(String gitBranch) {
        this.gitBranch = gitBranch;
    }

    @Generated
    public void setGitCommitHash(String gitCommitHash) {
        this.gitCommitHash = gitCommitHash;
    }

    @Generated
    public void setGitTags(String gitTags) {
        this.gitTags = gitTags;
    }

    @Generated
    public void setGitCommitMessage(String gitCommitMessage) {
        this.gitCommitMessage = gitCommitMessage;
    }

    @Generated
    public void setSystemInfo(List<SystemInfo> systemInfo) {
        this.systemInfo = systemInfo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Build)) {
            return false;
        }
        Build other = (Build)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getProjectId() != other.getProjectId()) {
            return false;
        }
        if (this.getStartedAt() != other.getStartedAt()) {
            return false;
        }
        if (this.getEndedAt() != other.getEndedAt()) {
            return false;
        }
        if (this.getDurationMs() != other.getDurationMs()) {
            return false;
        }
        if (this.isBDD() != other.isBDD()) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        ExecutionStage this$executionStage = this.getExecutionStage();
        ExecutionStage other$executionStage = other.getExecutionStage();
        if (this$executionStage == null ? other$executionStage != null : !((Object)((Object)this$executionStage)).equals((Object)other$executionStage)) {
            return false;
        }
        String this$testRunner = this.getTestRunner();
        String other$testRunner = other.getTestRunner();
        if (this$testRunner == null ? other$testRunner != null : !this$testRunner.equals(other$testRunner)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$result = this.getResult();
        String other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        Queue<RunStats> this$runStats = this.getRunStats();
        Queue<RunStats> other$runStats = other.getRunStats();
        if (this$runStats == null ? other$runStats != null : !this$runStats.equals(other$runStats)) {
            return false;
        }
        Set<TagStats> this$tagStats = this.getTagStats();
        Set<TagStats> other$tagStats = other.getTagStats();
        if (this$tagStats == null ? other$tagStats != null : !((Object)this$tagStats).equals(other$tagStats)) {
            return false;
        }
        Map<String, TagStats> this$tagStatsMonitor = this.getTagStatsMonitor();
        Map<String, TagStats> other$tagStatsMonitor = other.getTagStatsMonitor();
        if (this$tagStatsMonitor == null ? other$tagStatsMonitor != null : !((Object)this$tagStatsMonitor).equals(other$tagStatsMonitor)) {
            return false;
        }
        Set<Tag> this$tags = this.getTags();
        Set<Tag> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$gitRepository = this.getGitRepository();
        String other$gitRepository = other.getGitRepository();
        if (this$gitRepository == null ? other$gitRepository != null : !this$gitRepository.equals(other$gitRepository)) {
            return false;
        }
        String this$gitBranch = this.getGitBranch();
        String other$gitBranch = other.getGitBranch();
        if (this$gitBranch == null ? other$gitBranch != null : !this$gitBranch.equals(other$gitBranch)) {
            return false;
        }
        String this$gitCommitHash = this.getGitCommitHash();
        String other$gitCommitHash = other.getGitCommitHash();
        if (this$gitCommitHash == null ? other$gitCommitHash != null : !this$gitCommitHash.equals(other$gitCommitHash)) {
            return false;
        }
        String this$gitTags = this.getGitTags();
        String other$gitTags = other.getGitTags();
        if (this$gitTags == null ? other$gitTags != null : !this$gitTags.equals(other$gitTags)) {
            return false;
        }
        String this$gitCommitMessage = this.getGitCommitMessage();
        String other$gitCommitMessage = other.getGitCommitMessage();
        if (this$gitCommitMessage == null ? other$gitCommitMessage != null : !this$gitCommitMessage.equals(other$gitCommitMessage)) {
            return false;
        }
        List<SystemInfo> this$systemInfo = this.getSystemInfo();
        List<SystemInfo> other$systemInfo = other.getSystemInfo();
        return !(this$systemInfo == null ? other$systemInfo != null : !((Object)this$systemInfo).equals(other$systemInfo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Build;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + this.getProjectId();
        long $startedAt = this.getStartedAt();
        result = result * 59 + (int)($startedAt >>> 32 ^ $startedAt);
        long $endedAt = this.getEndedAt();
        result = result * 59 + (int)($endedAt >>> 32 ^ $endedAt);
        long $durationMs = this.getDurationMs();
        result = result * 59 + (int)($durationMs >>> 32 ^ $durationMs);
        result = result * 59 + (this.isBDD() ? 79 : 97);
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        ExecutionStage $executionStage = this.getExecutionStage();
        result = result * 59 + ($executionStage == null ? 43 : ((Object)((Object)$executionStage)).hashCode());
        String $testRunner = this.getTestRunner();
        result = result * 59 + ($testRunner == null ? 43 : $testRunner.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        Queue<RunStats> $runStats = this.getRunStats();
        result = result * 59 + ($runStats == null ? 43 : $runStats.hashCode());
        Set<TagStats> $tagStats = this.getTagStats();
        result = result * 59 + ($tagStats == null ? 43 : ((Object)$tagStats).hashCode());
        Map<String, TagStats> $tagStatsMonitor = this.getTagStatsMonitor();
        result = result * 59 + ($tagStatsMonitor == null ? 43 : ((Object)$tagStatsMonitor).hashCode());
        Set<Tag> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $gitRepository = this.getGitRepository();
        result = result * 59 + ($gitRepository == null ? 43 : $gitRepository.hashCode());
        String $gitBranch = this.getGitBranch();
        result = result * 59 + ($gitBranch == null ? 43 : $gitBranch.hashCode());
        String $gitCommitHash = this.getGitCommitHash();
        result = result * 59 + ($gitCommitHash == null ? 43 : $gitCommitHash.hashCode());
        String $gitTags = this.getGitTags();
        result = result * 59 + ($gitTags == null ? 43 : $gitTags.hashCode());
        String $gitCommitMessage = this.getGitCommitMessage();
        result = result * 59 + ($gitCommitMessage == null ? 43 : $gitCommitMessage.hashCode());
        List<SystemInfo> $systemInfo = this.getSystemInfo();
        result = result * 59 + ($systemInfo == null ? 43 : ((Object)$systemInfo).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Build(id=" + this.getId() + ", projectId=" + this.getProjectId() + ", projectName=" + this.getProjectName() + ", startedAt=" + this.getStartedAt() + ", endedAt=" + this.getEndedAt() + ", durationMs=" + this.getDurationMs() + ", executionStage=" + String.valueOf((Object)this.getExecutionStage()) + ", testRunner=" + this.getTestRunner() + ", name=" + this.getName() + ", result=" + this.getResult() + ", runStats=" + String.valueOf(this.getRunStats()) + ", tagStats=" + String.valueOf(this.getTagStats()) + ", tagStatsMonitor=" + String.valueOf(this.getTagStatsMonitor()) + ", tags=" + String.valueOf(this.getTags()) + ", gitRepository=" + this.getGitRepository() + ", gitBranch=" + this.getGitBranch() + ", gitCommitHash=" + this.getGitCommitHash() + ", gitTags=" + this.getGitTags() + ", gitCommitMessage=" + this.getGitCommitMessage() + ", isBDD=" + this.isBDD() + ", systemInfo=" + String.valueOf(this.getSystemInfo()) + ")";
    }
}

