/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa.session;

import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.session.BranchEnlistedStateHandler;
import com.atomikos.datasource.xa.session.InvalidSessionHandleStateException;
import com.atomikos.datasource.xa.session.TerminatedStateHandler;
import com.atomikos.datasource.xa.session.TransactionContextStateHandler;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.recovery.TxState;
import javax.transaction.xa.XAResource;

class NotInBranchStateHandler
extends TransactionContextStateHandler {
    NotInBranchStateHandler(XATransactionalResource resource, XAResource xaResource) {
        super(resource, xaResource);
    }

    @Override
    TransactionContextStateHandler checkEnlistBeforeUse(CompositeTransaction ct) throws InvalidSessionHandleStateException {
        BranchEnlistedStateHandler ret = null;
        if (ct != null && TransactionManagerImp.isJtaTransaction(ct)) {
            if (TxState.MARKED_ABORT.equals((Object)ct.getState())) {
                throw new InvalidSessionHandleStateException("Transaction is marked for rollback only or has timed out");
            }
            ret = new BranchEnlistedStateHandler(this.getXATransactionalResource(), ct, this.getXAResource());
        }
        return ret;
    }

    @Override
    TransactionContextStateHandler sessionClosed() {
        return new TerminatedStateHandler();
    }

    @Override
    TransactionContextStateHandler transactionTerminated(CompositeTransaction ct) {
        return null;
    }
}

