/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.spring.environment;

import com.groupcdg.arcmutate.spring.environment.AddAnnotationVisitor;
import com.groupcdg.arcmutate.spring.environment.SpringAnnotationScan;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.pitest.bytecode.FrameOptions;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classinfo.ComputeClassWriter;
import org.pitest.classpath.ClassloaderByteArraySource;
import org.pitest.reloc.asm.ClassReader;
import org.pitest.reloc.asm.ClassVisitor;

public class DirtyContextTransformer
implements ClassFileTransformer {
    private final Map<String, String> computeCache = new ConcurrentHashMap<String, String>();

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (DirtyContextTransformer.platformClass(className)) {
            return null;
        }
        try {
            return this.transformBytes(this.pickLoader(loader), classfileBuffer);
        }
        catch (RuntimeException t) {
            System.err.println("RuntimeException while transforming  " + className);
            t.printStackTrace();
            throw t;
        }
    }

    private byte[] transformBytes(ClassLoader loader, byte[] classfileBuffer) {
        ClassReader reader = new ClassReader(classfileBuffer);
        ComputeClassWriter writer = new ComputeClassWriter((ClassByteArraySource)new ClassloaderByteArraySource(loader), this.computeCache, FrameOptions.pickFlags((byte[])classfileBuffer));
        SpringAnnotationScan scan = new SpringAnnotationScan();
        reader.accept((ClassVisitor)scan, 4);
        if (scan.isSpringTest()) {
            reader.accept((ClassVisitor)new AddAnnotationVisitor((ClassVisitor)writer), 8);
            return writer.toByteArray();
        }
        return null;
    }

    private ClassLoader pickLoader(ClassLoader loader) {
        if (loader != null) {
            return loader;
        }
        return ClassLoader.getSystemClassLoader();
    }

    private static boolean platformClass(String className) {
        return className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("org.junit.") || className.startsWith("org.springframework.") || className.startsWith("sun.") || className.startsWith("jdk.");
    }
}

