/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.spring;

import com.groupcdg.arcmutate.spring.Group;
import com.groupcdg.arcmutate.spring.testtargetting.Inherit;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassName;

public enum MutableAnnotation {
    JAKARTA_MIN("jakarta/validation/constraints/Min", Group.VALIDATION, true, Inherit.NO_INHERIT),
    JAKARTA_MAX("jakarta/validation/constraints/Max", Group.VALIDATION, true, Inherit.NO_INHERIT),
    JAKARTA_NOT_EMPTY("jakarta/validation/constraints/NotEmpty", Group.VALIDATION, true, Inherit.NO_INHERIT),
    JAKARTA_PATTERN("jakarta/validation/constraints/Pattern", Group.VALIDATION, true, Inherit.NO_INHERIT),
    JAVAX_MIN("javax/validation/constraints/Min", Group.VALIDATION, true, Inherit.NO_INHERIT),
    JAVAX_MAX("javax/validation/constraints/Max", Group.VALIDATION, true, Inherit.NO_INHERIT),
    JAVAX_NOT_EMPTY("javax/validation/constraints/NotEmpty", Group.VALIDATION, true, Inherit.NO_INHERIT),
    JAVAX_PATTERN("javax/validation/constraints/Pattern", Group.VALIDATION, true, Inherit.NO_INHERIT),
    PRE_AUTHORIZE("org.springframework.security.access.prepost.PreAuthorize", Group.SECURITY, true, Inherit.INHERIT),
    POST_AUTHORIZE("org.springframework.security.access.prepost.PostAuthorize", Group.SECURITY, false, Inherit.INHERIT),
    ROLES_ALLOWED("jakarta.annotation.security.RolesAllowed", Group.SECURITY, true, Inherit.INHERIT),
    PRE_FILTER("org.springframework.security.access.prepost.PreFilter", Group.SECURITY, true, Inherit.INHERIT),
    POST_FILTER("org.springframework.security.access.prepost.PostFilter", Group.SECURITY, false, Inherit.INHERIT),
    SECURED("org.springframework.security.access.annotation.Secured", Group.SECURITY, true, Inherit.INHERIT),
    RESPONSE_STATUS("org.springframework.web.bind.annotation.ResponseStatus", Group.RESPONSE, false, Inherit.NO_INHERIT),
    RESPONSE_BODY("org.springframework.web.bind.annotation.ResponseBody", Group.RESPONSE, false, Inherit.NO_INHERIT);

    private final ClassName name;
    private final Group group;
    private final Inherit inherit;
    private final boolean rewriteCoverage;
    private static Map<ClassName, MutableAnnotation> VALUES;

    public static Optional<MutableAnnotation> fromMutator(String id) {
        int start = id.indexOf(95);
        ClassName clazz = ClassName.fromString((String)id.substring(start + 1));
        return Optional.ofNullable(VALUES.get(clazz));
    }

    public static List<MutableAnnotation> forGroup(Group group) {
        return Arrays.stream(MutableAnnotation.values()).filter(a -> a.group == group).collect(Collectors.toList());
    }

    private MutableAnnotation(String name, Group group, boolean rewriteCoverage, Inherit inherit) {
        this.name = ClassName.fromString((String)name);
        this.group = group;
        this.rewriteCoverage = rewriteCoverage;
        this.inherit = inherit;
    }

    public ClassName className() {
        return this.name;
    }

    public boolean rewriteCoverage() {
        return this.rewriteCoverage;
    }

    public Inherit inherit() {
        return this.inherit;
    }

    static {
        VALUES = Arrays.stream(MutableAnnotation.values()).collect(Collectors.toMap(v -> v.className(), v -> v));
    }
}

