/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.http.ws;

import com.arcadedb.server.http.ws.ChangeEvent;
import io.undertow.websockets.core.WebSocketChannel;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class EventWatcherSubscription {
    private final String database;
    private final WebSocketChannel channel;
    private final Map<String, Set<ChangeEvent.TYPE>> typeSubscriptions = new ConcurrentHashMap<String, Set<ChangeEvent.TYPE>>();
    private static final Set<ChangeEvent.TYPE> allTypes = Arrays.stream(ChangeEvent.TYPE.values()).collect(Collectors.toSet());

    public EventWatcherSubscription(String database, WebSocketChannel channel) {
        this.database = database;
        this.channel = channel;
    }

    public void close() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.typeSubscriptions.clear();
    }

    public void add(String type, Set<ChangeEvent.TYPE> changeTypes) {
        String key = type == null ? "*" : type;
        this.typeSubscriptions.computeIfAbsent(key, k -> new HashSet()).addAll(changeTypes == null ? allTypes : changeTypes);
    }

    public WebSocketChannel getChannel() {
        return this.channel;
    }

    public boolean isMatch(ChangeEvent event) {
        Set<ChangeEvent.TYPE> databaseEventTypes = this.typeSubscriptions.get("*");
        Set<ChangeEvent.TYPE> typeEventTypes = this.typeSubscriptions.get(event.getRecord().asDocument().getTypeName());
        return databaseEventTypes != null && databaseEventTypes.contains((Object)event.getType()) || typeEventTypes != null && typeEventTypes.contains((Object)event.getType());
    }

    public String toString() {
        return "EventWatcherSubscription{database='" + this.database + "', typeSubscriptions=" + String.valueOf(this.typeSubscriptions) + "}";
    }
}

