/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.remote;

import com.arcadedb.database.Binary;
import com.arcadedb.database.Database;
import com.arcadedb.database.Document;
import com.arcadedb.database.Identifiable;
import com.arcadedb.database.JSONSerializer;
import com.arcadedb.database.MutableDocument;
import com.arcadedb.exception.RecordNotFoundException;
import com.arcadedb.graph.Edge;
import com.arcadedb.graph.ImmutableLightEdge;
import com.arcadedb.graph.MutableEdge;
import com.arcadedb.graph.MutableVertex;
import com.arcadedb.graph.Vertex;
import com.arcadedb.query.sql.executor.ResultSet;
import com.arcadedb.remote.RemoteDatabase;
import com.arcadedb.remote.RemoteImmutableVertex;
import com.arcadedb.remote.RemoteVertex;
import com.arcadedb.schema.DocumentType;
import com.arcadedb.schema.VertexType;
import com.arcadedb.serializer.json.JSONObject;
import java.util.HashMap;
import java.util.Map;

public class RemoteMutableVertex
extends MutableVertex {
    private final RemoteVertex internal;
    protected final RemoteDatabase remoteDatabase;

    protected RemoteMutableVertex(RemoteDatabase database, String typeName) {
        super(null, (VertexType)database.getSchema().getType(typeName), null);
        this.internal = new RemoteVertex((Vertex)this, database);
        this.remoteDatabase = database;
    }

    protected RemoteMutableVertex(RemoteImmutableVertex source) {
        super(null, (VertexType)source.getType(), source.getIdentity());
        this.internal = new RemoteVertex((Vertex)this, source.getRemoteDatabase());
        this.remoteDatabase = source.remoteDatabase;
        this.map.putAll(source.map);
    }

    public MutableVertex save() {
        this.rid = this.remoteDatabase.saveRecord((MutableDocument)this);
        this.dirty = false;
        return this;
    }

    public MutableVertex save(String bucketName) {
        this.rid = this.remoteDatabase.saveRecord((MutableDocument)this, bucketName);
        this.dirty = false;
        return this;
    }

    public void reload() {
        ResultSet resultSet = this.remoteDatabase.query("sql", "select from " + this.rid, new Object[0]);
        if (!resultSet.hasNext()) {
            throw new RecordNotFoundException("Record " + this.rid + " not found", this.rid);
        }
        Document document = resultSet.next().toElement();
        this.map.clear();
        this.map.putAll(document.propertiesAsMap());
        this.dirty = false;
    }

    public Map<String, Object> toMap(boolean includeMetadata) {
        HashMap<String, Object> result = new HashMap<String, Object>(this.map);
        if (includeMetadata) {
            result.put("@cat", "v");
            result.put("@type", this.getTypeName());
            if (this.getIdentity() != null) {
                result.put("@rid", this.getIdentity().toString());
            }
        }
        return result;
    }

    public JSONObject toJSON(boolean includeMetadata) {
        JSONObject result = new JSONSerializer((Database)this.database).map2json(this.map, null, new String[0]);
        if (includeMetadata) {
            result.put("@cat", "v");
            result.put("@type", this.getTypeName());
            if (this.getIdentity() != null) {
                result.put("@rid", this.getIdentity().toString());
            }
        }
        return result;
    }

    public DocumentType getType() {
        throw new UnsupportedOperationException("Schema API are not supported in remote database");
    }

    public Database getDatabase() {
        throw new UnsupportedOperationException("Embedded Database API not supported in remote database");
    }

    public Binary getBuffer() {
        throw new UnsupportedOperationException("Raw buffer API not supported in remote database");
    }

    public void setBuffer(Binary buffer) {
        throw new UnsupportedOperationException("Raw buffer API not supported in remote database");
    }

    protected void checkForLazyLoadingProperties() {
    }

    protected Object convertValueToSchemaType(String name, Object value, DocumentType type) {
        return value;
    }

    public RemoteDatabase getRemoteDatabase() {
        return this.internal.remoteDatabase;
    }

    public void delete() {
        this.internal.delete();
    }

    public long countEdges(Vertex.DIRECTION direction, String edgeType) {
        return this.internal.countEdges(direction, edgeType);
    }

    public Iterable<Edge> getEdges() {
        return this.internal.getEdges(Vertex.DIRECTION.BOTH, new String[0]);
    }

    public Iterable<Edge> getEdges(Vertex.DIRECTION direction, String ... edgeTypes) {
        return this.internal.getEdges(Vertex.DIRECTION.BOTH, edgeTypes);
    }

    public Iterable<Vertex> getVertices() {
        return this.internal.getVertices(Vertex.DIRECTION.BOTH, new String[0]);
    }

    public Iterable<Vertex> getVertices(Vertex.DIRECTION direction, String ... edgeTypes) {
        return this.internal.getVertices(direction, edgeTypes);
    }

    public boolean isConnectedTo(Identifiable toVertex) {
        return this.internal.isConnectedTo(toVertex);
    }

    public boolean isConnectedTo(Identifiable toVertex, Vertex.DIRECTION direction) {
        return this.internal.isConnectedTo(toVertex, direction);
    }

    public boolean isConnectedTo(Identifiable toVertex, Vertex.DIRECTION direction, String edgeType) {
        return this.internal.isConnectedTo(toVertex, direction, edgeType);
    }

    public MutableEdge newEdge(String edgeType, Identifiable toVertex, boolean bidirectional, Object ... properties) {
        return this.internal.newEdge(edgeType, toVertex, bidirectional, properties);
    }

    public ImmutableLightEdge newLightEdge(String edgeType, Identifiable toVertex, boolean bidirectional) {
        return this.internal.newLightEdge(edgeType, toVertex, bidirectional);
    }

    public Vertex asVertex() {
        return this;
    }

    public Vertex asVertex(boolean loadContent) {
        return this;
    }
}

