/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.remote;

import com.arcadedb.database.Identifiable;
import com.arcadedb.database.RID;
import com.arcadedb.graph.Edge;
import com.arcadedb.graph.ImmutableLightEdge;
import com.arcadedb.graph.MutableEdge;
import com.arcadedb.graph.Vertex;
import com.arcadedb.remote.RemoteDatabase;
import com.arcadedb.remote.RemoteImmutableDocument;
import com.arcadedb.remote.RemoteMutableVertex;
import com.arcadedb.remote.RemoteVertex;
import java.util.Map;

public class RemoteImmutableVertex
extends RemoteImmutableDocument
implements Vertex {
    private final RemoteVertex internal;

    protected RemoteImmutableVertex(RemoteDatabase database, Map<String, Object> properties) {
        super(database, properties);
        this.internal = new RemoteVertex(this, database);
    }

    public RemoteMutableVertex modify() {
        return new RemoteMutableVertex(this);
    }

    public RemoteDatabase getRemoteDatabase() {
        return this.internal.remoteDatabase;
    }

    public void delete() {
        this.internal.delete();
    }

    public long countEdges(Vertex.DIRECTION direction, String edgeType) {
        return this.internal.countEdges(direction, edgeType);
    }

    public Iterable<Edge> getEdges() {
        return this.internal.getEdges(Vertex.DIRECTION.BOTH, new String[0]);
    }

    public Iterable<Edge> getEdges(Vertex.DIRECTION direction, String ... edgeTypes) {
        return this.internal.getEdges(direction, edgeTypes);
    }

    public Iterable<Vertex> getVertices() {
        return this.internal.getVertices(Vertex.DIRECTION.BOTH, new String[0]);
    }

    public Iterable<Vertex> getVertices(Vertex.DIRECTION direction, String ... edgeTypes) {
        return this.internal.getVertices(direction, edgeTypes);
    }

    public boolean isConnectedTo(Identifiable toVertex) {
        return this.internal.isConnectedTo(toVertex);
    }

    public boolean isConnectedTo(Identifiable toVertex, Vertex.DIRECTION direction) {
        return this.internal.isConnectedTo(toVertex, direction);
    }

    public boolean isConnectedTo(Identifiable toVertex, Vertex.DIRECTION direction, String edgeType) {
        return this.internal.isConnectedTo(toVertex, direction, edgeType);
    }

    public RID moveToType(String targetType) {
        return this.internal.vertex.moveToType(targetType);
    }

    public RID moveToBucket(String targetBucket) {
        return this.internal.vertex.moveToBucket(targetBucket);
    }

    public MutableEdge newEdge(String edgeType, Identifiable toVertex, boolean bidirectional, Object ... properties) {
        return this.internal.newEdge(edgeType, toVertex, bidirectional, properties);
    }

    public ImmutableLightEdge newLightEdge(String edgeType, Identifiable toVertex, boolean bidirectional) {
        return this.internal.newLightEdge(edgeType, toVertex, bidirectional);
    }

    public Vertex asVertex() {
        return this;
    }

    public Vertex asVertex(boolean loadContent) {
        if (loadContent) {
            this.checkForLazyLoading();
        }
        return this;
    }
}

