/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.remote;

import com.arcadedb.database.Binary;
import com.arcadedb.database.Database;
import com.arcadedb.database.Document;
import com.arcadedb.database.JSONSerializer;
import com.arcadedb.database.MutableDocument;
import com.arcadedb.query.sql.executor.ResultSet;
import com.arcadedb.remote.RemoteDatabase;
import com.arcadedb.remote.RemoteImmutableDocument;
import com.arcadedb.schema.DocumentType;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class RemoteMutableDocument
extends MutableDocument {
    protected final RemoteDatabase remoteDatabase;
    protected final String typeName;

    protected RemoteMutableDocument(RemoteImmutableDocument source) {
        super(null, null, source.getIdentity());
        this.remoteDatabase = source.remoteDatabase;
        this.typeName = source.typeName;
        this.map.putAll(source.map);
        this.map.remove("@cat");
        this.map.remove("@type");
    }

    public String getTypeName() {
        return this.typeName;
    }

    public synchronized MutableDocument save() {
        this.dirty = true;
        if (this.rid != null) {
            this.remoteDatabase.command("sql", "update " + this.rid + " content " + this.toJSON(), new Object[0]);
        } else {
            this.remoteDatabase.command("sql", "insert into " + this.typeName + " content " + this.toJSON(), new Object[0]);
        }
        return this;
    }

    public synchronized MutableDocument save(String bucketName) {
        this.dirty = true;
        if (this.rid != null) {
            throw new IllegalStateException("Cannot update a record in a custom bucket");
        }
        this.remoteDatabase.command("sql", "insert into " + this.typeName + " bucket " + bucketName + " content " + this.toJSON(), new Object[0]);
        return this;
    }

    public void delete() {
        this.remoteDatabase.command("sql", "delete from " + this.rid, new Object[0]);
    }

    public synchronized void reload() {
        ResultSet resultSet = this.remoteDatabase.query("sql", "select from " + this.rid, new Object[0]);
        if (resultSet.hasNext()) {
            Document document = resultSet.next().toElement();
            this.map.clear();
            this.map.putAll(document.propertiesAsMap());
            this.dirty = false;
        }
    }

    public synchronized JSONObject toJSON() {
        JSONObject result = new JSONSerializer((Database)this.database).map2json(this.map);
        result.put("@cat", (Object)"d");
        result.put("@type", (Object)this.typeName);
        if (this.getIdentity() != null) {
            result.put("@rid", (Object)this.getIdentity().toString());
        }
        return result;
    }

    public synchronized Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.map);
        result.put("@cat", "d");
        result.put("@type", this.typeName);
        if (this.getIdentity() != null) {
            result.put("@rid", this.getIdentity().toString());
        }
        return result;
    }

    public DocumentType getType() {
        throw new UnsupportedOperationException("Schema API are not supported in remote database");
    }

    public Database getDatabase() {
        throw new UnsupportedOperationException("Embedded Database API not supported in remote database");
    }

    public Binary getBuffer() {
        throw new UnsupportedOperationException("Raw buffer API not supported in remote database");
    }

    public synchronized void setBuffer(Binary buffer) {
        throw new UnsupportedOperationException("Raw buffer API not supported in remote database");
    }

    protected void checkForLazyLoadingProperties() {
    }

    protected Object convertValueToSchemaType(String name, Object value, DocumentType type) {
        return value;
    }
}

