/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.remote;

import com.arcadedb.database.Identifiable;
import com.arcadedb.graph.Edge;
import com.arcadedb.graph.ImmutableLightEdge;
import com.arcadedb.graph.MutableEdge;
import com.arcadedb.graph.MutableVertex;
import com.arcadedb.graph.Vertex;
import com.arcadedb.query.sql.executor.ResultSet;
import com.arcadedb.remote.RemoteDatabase;
import com.arcadedb.remote.RemoteImmutableDocument;
import com.arcadedb.remote.RemoteImmutableEdge;
import com.arcadedb.remote.RemoteMutableEdge;
import com.arcadedb.remote.RemoteMutableVertex;
import java.util.Iterator;
import java.util.Map;

public class RemoteImmutableVertex
extends RemoteImmutableDocument
implements Vertex {
    protected RemoteImmutableVertex(RemoteDatabase database, Map<String, Object> properties) {
        super(database, properties);
    }

    public long countEdges(Vertex.DIRECTION direction, String edgeType) {
        String query = "select " + direction.toString().toLowerCase() + "(";
        if (edgeType != null) {
            query = query + "'" + edgeType + "'";
        }
        query = query + ").size() as count from " + this.rid;
        ResultSet resultSet = this.remoteDatabase.query("sql", query, new Object[0]);
        return ((Number)resultSet.next().getProperty("count")).longValue();
    }

    public Iterable<Edge> getEdges() {
        return this.getEdges(Vertex.DIRECTION.BOTH, new String[0]);
    }

    public Iterable<Edge> getEdges(Vertex.DIRECTION direction, String ... edgeTypes) {
        final ResultSet resultSet = this.fetch("E", direction, edgeTypes);
        return () -> new Iterator<Edge>(){

            @Override
            public boolean hasNext() {
                return resultSet.hasNext();
            }

            @Override
            public Edge next() {
                return (Edge)resultSet.next().getEdge().get();
            }
        };
    }

    public Iterable<Vertex> getVertices() {
        return this.getVertices(Vertex.DIRECTION.BOTH, new String[0]);
    }

    public Iterable<Vertex> getVertices(Vertex.DIRECTION direction, String ... edgeTypes) {
        final ResultSet resultSet = this.fetch("", direction, edgeTypes);
        return () -> new Iterator<Vertex>(){

            @Override
            public boolean hasNext() {
                return resultSet.hasNext();
            }

            @Override
            public Vertex next() {
                return (Vertex)resultSet.next().getVertex().get();
            }
        };
    }

    public boolean isConnectedTo(Identifiable toVertex) {
        String query = "select from ( select both() as vertices from " + this.rid + " ) where vertices contains " + toVertex;
        ResultSet resultSet = this.remoteDatabase.query("sql", query, new Object[0]);
        return resultSet.hasNext();
    }

    public boolean isConnectedTo(Identifiable toVertex, Vertex.DIRECTION direction) {
        String query = "select from ( select " + direction.toString().toLowerCase() + "() as vertices from " + this.rid + " ) where vertices contains " + toVertex;
        ResultSet resultSet = this.remoteDatabase.query("sql", query, new Object[0]);
        return resultSet.hasNext();
    }

    public MutableEdge newEdge(String edgeType, Identifiable toVertex, boolean bidirectional, Object ... properties) {
        if (!bidirectional) {
            throw new UnsupportedOperationException("Creating unidirectional edges is not supported from remote database");
        }
        String query = "create edge " + edgeType + " from " + this.rid + " to " + toVertex.getIdentity();
        if (properties.length > 0) {
            query = query + " set ";
            for (int i = 0; i < properties.length; i += 2) {
                String propName = (String)properties[i];
                Object propValue = properties[i + 1];
                if (i > 0) {
                    query = query + ", ";
                }
                query = query + propName + " = ";
                if (propValue instanceof String) {
                    query = query + "'";
                }
                query = query + propValue;
                if (!(propValue instanceof String)) continue;
                query = query + "'";
            }
        }
        ResultSet resultSet = this.remoteDatabase.command("sql", query, new Object[0]);
        return new RemoteMutableEdge((RemoteImmutableEdge)((Object)resultSet.next().getEdge().get()));
    }

    public ImmutableLightEdge newLightEdge(String edgeType, Identifiable toVertex, boolean bidirectional) {
        throw new UnsupportedOperationException("Creating light edges is not supported from remote database");
    }

    public synchronized MutableVertex modify() {
        return new RemoteMutableVertex(this);
    }

    public void delete() {
        this.remoteDatabase.command("sql", "delete from " + this.rid, new Object[0]);
    }

    private ResultSet fetch(String suffix, Vertex.DIRECTION direction, String[] types) {
        String query = "select expand( " + direction.toString().toLowerCase() + suffix + "(";
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                query = query + ",";
            }
            query = query + "'" + types[i] + "'";
        }
        query = query + ") ) from " + this.rid;
        return this.remoteDatabase.query("sql", query, new Object[0]);
    }
}

