/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.remote;

import com.arcadedb.database.RID;
import com.arcadedb.graph.Edge;
import com.arcadedb.graph.MutableEdge;
import com.arcadedb.graph.Vertex;
import com.arcadedb.query.sql.executor.ResultSet;
import com.arcadedb.remote.RemoteDatabase;
import com.arcadedb.remote.RemoteImmutableDocument;
import com.arcadedb.remote.RemoteMutableEdge;
import java.util.Map;

public class RemoteImmutableEdge
extends RemoteImmutableDocument
implements Edge {
    private final RID out;
    private final RID in;

    public RemoteImmutableEdge(RemoteDatabase database, Map<String, Object> properties) {
        super(database, properties);
        this.out = new RID(null, (String)properties.get("@out"));
        this.in = new RID(null, (String)properties.get("@in"));
        this.map.remove("@cat");
        this.map.remove("@type");
    }

    public RID getOut() {
        return this.out;
    }

    public Vertex getOutVertex() {
        return this.loadVertex(this.out);
    }

    public RID getIn() {
        return this.in;
    }

    public Vertex getInVertex() {
        return this.loadVertex(this.in);
    }

    public Vertex getVertex(Vertex.DIRECTION iDirection) {
        if (iDirection == Vertex.DIRECTION.OUT) {
            return this.getOutVertex();
        }
        return this.getInVertex();
    }

    public synchronized MutableEdge modify() {
        return new RemoteMutableEdge(this);
    }

    public void delete() {
        this.remoteDatabase.command("sql", "delete from " + this.rid, new Object[0]);
    }

    private Vertex loadVertex(RID rid) {
        ResultSet result = this.remoteDatabase.query("sql", "select from " + rid, new Object[0]);
        if (result.hasNext()) {
            return (Vertex)result.next().getVertex().get();
        }
        return null;
    }
}

