/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.remote;

import com.arcadedb.database.Binary;
import com.arcadedb.database.Database;
import com.arcadedb.database.ImmutableDocument;
import com.arcadedb.database.JSONSerializer;
import com.arcadedb.database.MutableDocument;
import com.arcadedb.database.RID;
import com.arcadedb.remote.RemoteDatabase;
import com.arcadedb.remote.RemoteMutableDocument;
import com.arcadedb.schema.DocumentType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class RemoteImmutableDocument
extends ImmutableDocument {
    protected final RemoteDatabase remoteDatabase;
    protected final String typeName;
    protected final Map<String, Object> map;

    protected RemoteImmutableDocument(RemoteDatabase remoteDatabase, Map<String, Object> attributes) {
        super(null, null, null, null);
        this.remoteDatabase = remoteDatabase;
        this.map = new HashMap<String, Object>(attributes);
        String ridAsString = (String)this.map.remove("@rid");
        this.rid = ridAsString != null ? new RID(null, ridAsString) : null;
        this.typeName = (String)this.map.remove("@type");
        this.map.remove("@out");
        this.map.remove("@in");
        this.map.remove("@cat");
    }

    protected RemoteImmutableDocument(RemoteDatabase remoteDatabase, Map<String, Object> attributes, String typeName, RID rid) {
        super(null, null, rid, null);
        this.remoteDatabase = remoteDatabase;
        this.map = new HashMap<String, Object>(attributes);
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public synchronized Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public synchronized boolean has(String propertyName) {
        return this.map.containsKey(propertyName);
    }

    public synchronized Object get(String propertyName) {
        return this.map.get(propertyName);
    }

    public synchronized MutableDocument modify() {
        return new RemoteMutableDocument(this);
    }

    public synchronized Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.map);
        result.put("@cat", "d");
        result.put("@type", this.typeName);
        if (this.getIdentity() != null) {
            result.put("@rid", this.getIdentity().toString());
        }
        return result;
    }

    public synchronized JSONObject toJSON() {
        JSONObject result = new JSONSerializer((Database)this.database).map2json(this.map);
        result.put("@cat", (Object)"d");
        result.put("@type", (Object)this.typeName);
        if (this.getIdentity() != null) {
            result.put("@rid", (Object)this.getIdentity().toString());
        }
        return result;
    }

    public DocumentType getType() {
        throw new UnsupportedOperationException("Schema API are not supported in remote database");
    }

    public Database getDatabase() {
        throw new UnsupportedOperationException("Embedded Database API not supported in remote database");
    }

    public Binary getBuffer() {
        throw new UnsupportedOperationException("Raw buffer API not supported in remote database");
    }

    public void reload() {
        throw new UnsupportedOperationException("Unable to reload an immutable document");
    }

    protected boolean checkForLazyLoading() {
        return false;
    }
}

