/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.remote;

import com.arcadedb.ContextConfiguration;
import com.arcadedb.GlobalConfiguration;
import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.database.Identifiable;
import com.arcadedb.database.RID;
import com.arcadedb.database.Record;
import com.arcadedb.exception.ConcurrentModificationException;
import com.arcadedb.exception.DatabaseOperationException;
import com.arcadedb.exception.DuplicatedKeyException;
import com.arcadedb.exception.NeedRetryException;
import com.arcadedb.exception.RecordNotFoundException;
import com.arcadedb.exception.SchemaException;
import com.arcadedb.exception.TimeoutException;
import com.arcadedb.exception.TransactionException;
import com.arcadedb.log.LogManager;
import com.arcadedb.network.binary.QuorumNotReachedException;
import com.arcadedb.network.binary.ServerIsNotTheLeaderException;
import com.arcadedb.query.sql.executor.InternalResultSet;
import com.arcadedb.query.sql.executor.Result;
import com.arcadedb.query.sql.executor.ResultInternal;
import com.arcadedb.query.sql.executor.ResultSet;
import com.arcadedb.remote.RemoteException;
import com.arcadedb.remote.RemoteImmutableDocument;
import com.arcadedb.remote.RemoteImmutableEdge;
import com.arcadedb.remote.RemoteImmutableVertex;
import com.arcadedb.utility.FileUtils;
import com.arcadedb.utility.Pair;
import com.arcadedb.utility.RWLockContext;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.json.JSONArray;
import org.json.JSONObject;

public class RemoteDatabase
extends RWLockContext {
    public static final int DEFAULT_PORT = 2480;
    private final String originalServer;
    private final int originalPort;
    private int apiVersion = 1;
    private final ContextConfiguration configuration;
    private final String databaseName;
    private final String userName;
    private final String userPassword;
    private final List<Pair<String, Integer>> replicaServerList = new ArrayList<Pair<String, Integer>>();
    private String currentServer;
    private int currentPort;
    private CONNECTION_STRATEGY connectionStrategy = CONNECTION_STRATEGY.ROUND_ROBIN;
    private Pair<String, Integer> leaderServer;
    private int currentReplicaServerIndex = -1;
    private int timeout;
    private static final String protocol = "http";
    private static final String charset = "UTF-8";
    private String sessionId;

    public RemoteDatabase(String server, int port, String databaseName, String userName, String userPassword) {
        this(server, port, databaseName, userName, userPassword, new ContextConfiguration());
    }

    public RemoteDatabase(String server, int port, String databaseName, String userName, String userPassword, ContextConfiguration configuration) {
        this.originalServer = server;
        this.originalPort = port;
        this.currentServer = this.originalServer;
        this.currentPort = this.originalPort;
        this.databaseName = databaseName;
        this.userName = userName;
        this.userPassword = userPassword;
        this.configuration = configuration;
        this.timeout = this.configuration.getValueAsInteger(GlobalConfiguration.NETWORK_SOCKET_TIMEOUT);
        this.requestClusterConfiguration();
    }

    public String getName() {
        return this.databaseName;
    }

    public void create() {
        this.databaseCommand("create", "SQL", null, null, true, null);
    }

    public boolean exists() {
        return (Boolean)this.databaseCommand("exists", "SQL", null, null, true, (connection, response) -> {
            boolean exists = response.getBoolean("result");
            return exists;
        });
    }

    public void close() {
    }

    public void drop() {
        this.databaseCommand("drop", "SQL", null, null, true, null);
        this.close();
    }

    public void transaction(Database.TransactionScope txBlock) {
        this.transaction(txBlock, this.configuration.getValueAsInteger(GlobalConfiguration.TX_RETRIES));
    }

    public void transaction(Database.TransactionScope txBlock, int attempts) {
        if (txBlock == null) {
            throw new IllegalArgumentException("Transaction block is null");
        }
        Throwable lastException = null;
        if (attempts < 1) {
            attempts = 1;
        }
        for (int retry = 0; retry < attempts; ++retry) {
            try {
                this.begin();
                txBlock.execute();
                this.commit();
                return;
            }
            catch (DuplicatedKeyException | NeedRetryException e) {
                lastException = e;
                continue;
            }
            catch (Exception e) {
                try {
                    this.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
        }
        throw lastException;
    }

    public void begin() {
        if (this.sessionId != null) {
            throw new TransactionException("Transaction already begun");
        }
        try {
            HttpURLConnection connection = this.createConnection("POST", this.getUrl("begin", this.databaseName));
            connection.connect();
            if (connection.getResponseCode() != 204) {
                throw new TransactionException("Error on transaction begin");
            }
            this.sessionId = connection.getHeaderField("arcadedb-session-id");
        }
        catch (Exception e) {
            throw new TransactionException("Error on transaction begin", (Throwable)e);
        }
    }

    public void commit() {
        if (this.sessionId == null) {
            throw new TransactionException("Transaction not begun");
        }
        try {
            HttpURLConnection connection = this.createConnection("POST", this.getUrl("commit", this.databaseName));
            connection.connect();
            if (connection.getResponseCode() != 204) {
                throw new TransactionException("Error on transaction commit");
            }
            this.sessionId = null;
        }
        catch (Exception e) {
            throw new TransactionException("Error on transaction commit", (Throwable)e);
        }
    }

    public void rollback() {
        if (this.sessionId == null) {
            throw new TransactionException("Transaction not begun");
        }
        try {
            HttpURLConnection connection = this.createConnection("POST", this.getUrl("rollback", this.databaseName));
            connection.connect();
            if (connection.getResponseCode() != 204) {
                throw new TransactionException("Error on transaction rollback");
            }
            this.sessionId = null;
        }
        catch (Exception e) {
            throw new TransactionException("Error on transaction rollback", (Throwable)e);
        }
    }

    public Record lookupByRID(RID rid) {
        if (rid == null) {
            throw new IllegalArgumentException("Record is null");
        }
        try {
            HttpURLConnection connection = this.createConnection("GET", this.getUrl("document", this.databaseName + "/" + rid.getBucketId() + ":" + rid.getPosition()));
            connection.connect();
            if (connection.getResponseCode() == 404) {
                throw new RecordNotFoundException("Record " + rid + " not found", rid);
            }
            JSONObject response = new JSONObject(FileUtils.readStreamAsString((InputStream)connection.getInputStream(), (String)charset));
            if (response.has("result")) {
                return this.json2Record(response.getJSONObject("result"));
            }
            return null;
        }
        catch (RecordNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DatabaseOperationException("Error on loading record " + rid, (Throwable)e);
        }
    }

    public ResultSet command(String language, String command, Object ... args) {
        Map<String, Object> params = this.mapArgs(args);
        return (ResultSet)this.databaseCommand("command", language, command, params, true, (connection, response) -> this.createResultSet(response));
    }

    public ResultSet query(String language, String command, Object ... args) {
        Map<String, Object> params = this.mapArgs(args);
        return (ResultSet)this.databaseCommand("query", language, command, params, false, (connection, response) -> this.createResultSet(response));
    }

    public CONNECTION_STRATEGY getConnectionStrategy() {
        return this.connectionStrategy;
    }

    public void setConnectionStrategy(CONNECTION_STRATEGY connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        return this.databaseName;
    }

    private Object serverCommand(String method, String operation, String language, String payloadCommand, Map<String, Object> params, boolean leaderIsPreferable, boolean autoReconnect, Callback callback) {
        return this.httpCommand(method, null, operation, language, payloadCommand, params, leaderIsPreferable, autoReconnect, callback);
    }

    private Object databaseCommand(String operation, String language, String payloadCommand, Map<String, Object> params, boolean requiresLeader, Callback callback) {
        return this.httpCommand("POST", this.databaseName, operation, language, payloadCommand, params, requiresLeader, true, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object httpCommand(String method, String extendedURL, String operation, String language, String payloadCommand, Map<String, Object> params, boolean leaderIsPreferable, boolean autoReconnect, Callback callback) {
        void var10_11;
        Object var10_10 = null;
        int maxRetry = leaderIsPreferable ? 3 : this.replicaServerList.size() + 1;
        Pair<String, Integer> connectToServer = leaderIsPreferable ? this.leaderServer : new Pair<String, Integer>((Object)this.currentServer, (Object)this.currentPort);
        String server = null;
        for (int retry = 0; retry < maxRetry && connectToServer != null; ++retry) {
            server = (String)connectToServer.getFirst() + ":" + connectToServer.getSecond();
            String url = "http://" + server + "/api/v" + this.apiVersion + "/" + operation;
            if (extendedURL != null) {
                url = url + "/" + extendedURL;
            }
            try {
                HttpURLConnection connection = this.createConnection(method, url);
                connection.setDoOutput(true);
                if (payloadCommand != null) {
                    JSONObject jsonRequest = new JSONObject();
                    jsonRequest.put("language", (Object)language);
                    jsonRequest.put("command", (Object)payloadCommand);
                    jsonRequest.put("serializer", (Object)"record");
                    if (params != null) {
                        JSONObject jsonParams = new JSONObject(params);
                        jsonRequest.put("params", (Object)jsonParams);
                    }
                    byte[] postData = jsonRequest.toString().getBytes(StandardCharsets.UTF_8);
                    connection.setRequestProperty("Content-Length", Integer.toString(postData.length));
                    try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
                        wr.write(postData);
                    }
                }
                connection.connect();
                if (connection.getResponseCode() != 200) {
                    String cmd;
                    String detail = null;
                    String reason = null;
                    String exception = null;
                    String exceptionArgs = null;
                    String responsePayload = null;
                    if (connection.getErrorStream() != null) {
                        try {
                            responsePayload = FileUtils.readStreamAsString((InputStream)connection.getErrorStream(), (String)charset);
                            JSONObject response = new JSONObject(responsePayload);
                            reason = response.getString("error");
                            detail = response.has("detail") ? response.getString("detail") : null;
                            exception = response.has("exception") ? response.getString("exception") : null;
                            exceptionArgs = response.has("exceptionArgs") ? response.getString("exceptionArgs") : null;
                        }
                        catch (Exception e) {
                            Exception exception2 = e;
                            LogManager.instance().log((Object)this, Level.WARNING, "Error on executing command, retrying... (payload=%s, error=%s)", null, (Object)responsePayload, (Object)e.toString());
                            connection.disconnect();
                            continue;
                        }
                    }
                    if ((cmd = payloadCommand) == null) {
                        cmd = operation;
                    }
                    if (exception != null) {
                        if (detail == null) {
                            detail = "Unknown";
                        }
                        if (exception.equals(ServerIsNotTheLeaderException.class.getName())) {
                            String string;
                            int sep = detail.lastIndexOf(46);
                            if (sep > -1) {
                                string = detail.substring(0, sep);
                                throw new ServerIsNotTheLeaderException(string, exceptionArgs);
                            }
                            string = detail;
                            throw new ServerIsNotTheLeaderException(string, exceptionArgs);
                        }
                        if (exception.equals(QuorumNotReachedException.class.getName())) {
                            QuorumNotReachedException quorumNotReachedException = new QuorumNotReachedException(detail);
                            continue;
                        }
                        if (exception.equals(DuplicatedKeyException.class.getName()) && exceptionArgs != null) {
                            String[] exceptionArgsParts = exceptionArgs.split("\\|");
                            throw new DuplicatedKeyException(exceptionArgsParts[0], exceptionArgsParts[1], new RID(null, exceptionArgsParts[2]));
                        }
                        if (exception.equals(ConcurrentModificationException.class.getName())) {
                            throw new ConcurrentModificationException(detail);
                        }
                        if (exception.equals(TransactionException.class.getName())) {
                            throw new TransactionException(detail);
                        }
                        if (exception.equals(TimeoutException.class.getName())) {
                            throw new TimeoutException(detail);
                        }
                        if (!exception.equals(SchemaException.class.getName())) throw new RemoteException("Error on executing remote operation " + operation + " (cause:" + exception + " detail:" + detail + ")");
                        throw new SchemaException(detail);
                    }
                    String httpErrorDescription = connection.getResponseMessage();
                    if (connection.getResponseCode() != 400) throw new RemoteException("Error on executing remote command '" + cmd + "' (httpErrorCode=" + connection.getResponseCode() + " httpErrorDescription=" + httpErrorDescription + " reason=" + reason + " detail=" + detail + " exception=" + exception + ")");
                    if (!"Bad Request".equals(httpErrorDescription)) throw new RemoteException("Error on executing remote command '" + cmd + "' (httpErrorCode=" + connection.getResponseCode() + " httpErrorDescription=" + httpErrorDescription + " reason=" + reason + " detail=" + detail + " exception=" + exception + ")");
                    if (!"Command text is null".equals(reason)) throw new RemoteException("Error on executing remote command '" + cmd + "' (httpErrorCode=" + connection.getResponseCode() + " httpErrorDescription=" + httpErrorDescription + " reason=" + reason + " detail=" + detail + " exception=" + exception + ")");
                    LogManager.instance().log((Object)this, Level.FINE, "Empty payload received, retrying (retry=%d/%d)...", null, (Object)retry, (Object)maxRetry);
                    continue;
                }
                JSONObject response = new JSONObject(FileUtils.readStreamAsString((InputStream)connection.getInputStream(), (String)charset));
                if (callback != null) return callback.call(connection, response);
                return null;
            }
            catch (ServerIsNotTheLeaderException | IOException e) {
                Object object = e;
                if (!autoReconnect) break;
                if (!this.reloadClusterConfiguration()) {
                    throw new RemoteException("Error on executing remote operation " + operation + ", no server available", (Throwable)e);
                }
                Pair<String, Integer> currentConnectToServer = connectToServer;
                connectToServer = leaderIsPreferable && !currentConnectToServer.equals(this.leaderServer) ? this.leaderServer : this.getNextReplicaAddress();
                if (connectToServer == null) continue;
                LogManager.instance().log((Object)this, Level.WARNING, "Remote server (%s:%d) seems unreachable, switching to server %s:%d...", null, currentConnectToServer.getFirst(), currentConnectToServer.getSecond(), connectToServer.getFirst(), connectToServer.getSecond());
                continue;
            }
            catch (DuplicatedKeyException | NeedRetryException | TimeoutException | TransactionException | RemoteException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RemoteException("Error on executing remote operation " + operation + " (cause: " + e.getMessage() + ")", e);
            }
        }
        if (!(var10_11 instanceof RuntimeException)) throw new RemoteException("Error on executing remote operation '" + operation + "' (server=" + server + " retry=" + maxRetry + ")", (Throwable)var10_11);
        throw (RuntimeException)var10_11;
    }

    public int getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(int apiVersion) {
        this.apiVersion = apiVersion;
    }

    protected HttpURLConnection createConnection(String httpMethod, String url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestProperty("charset", "utf-8");
        connection.setRequestMethod(httpMethod);
        String authorization = this.userName + ":" + this.userPassword;
        connection.setRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString(authorization.getBytes(DatabaseFactory.getDefaultCharset())));
        connection.setConnectTimeout(this.timeout);
        connection.setReadTimeout(this.timeout);
        if (this.sessionId != null) {
            connection.setRequestProperty("arcadedb-session-id", this.sessionId);
        }
        return connection;
    }

    private void requestClusterConfiguration() {
        this.serverCommand("GET", "server", "SQL", null, null, false, false, new Callback(){

            @Override
            public Object call(HttpURLConnection connection, JSONObject response) {
                LogManager.instance().log((Object)this, Level.FINE, "Configuring remote database: %s", null, (Object)response);
                if (!response.has("leaderServer")) {
                    RemoteDatabase.this.leaderServer = new Pair((Object)RemoteDatabase.this.originalServer, (Object)RemoteDatabase.this.originalPort);
                    RemoteDatabase.this.replicaServerList.clear();
                    return null;
                }
                String cfgLeaderServer = (String)response.get("leaderServer");
                String[] leaderServerParts = cfgLeaderServer.split(":");
                RemoteDatabase.this.leaderServer = new Pair((Object)leaderServerParts[0], (Object)Integer.parseInt(leaderServerParts[1]));
                String cfgReplicaServers = (String)response.get("replicaServers");
                RemoteDatabase.this.replicaServerList.clear();
                if (cfgReplicaServers != null && !cfgReplicaServers.isEmpty()) {
                    String[] serverEntries;
                    for (String serverEntry : serverEntries = cfgReplicaServers.split(",")) {
                        String[] serverParts = serverEntry.split(":");
                        if (serverParts.length != 2) {
                            LogManager.instance().log((Object)this, Level.WARNING, "No port specified on remote server URL '%s'", null, (Object)serverEntry);
                        }
                        String sHost = serverParts[0];
                        int sPort = Integer.parseInt(serverParts[1]);
                        RemoteDatabase.this.replicaServerList.add((Pair<String, Integer>)new Pair((Object)sHost, (Object)sPort));
                    }
                }
                LogManager.instance().log((Object)this, Level.INFO, "Remote Database configured with leader=%s and replicas=%s", null, RemoteDatabase.this.leaderServer, RemoteDatabase.this.replicaServerList);
                return null;
            }
        });
    }

    private Pair<String, Integer> getNextReplicaAddress() {
        if (this.replicaServerList.isEmpty()) {
            return this.leaderServer;
        }
        ++this.currentReplicaServerIndex;
        if (this.currentReplicaServerIndex > this.replicaServerList.size() - 1) {
            this.currentReplicaServerIndex = 0;
        }
        return this.replicaServerList.get(this.currentReplicaServerIndex);
    }

    private boolean reloadClusterConfiguration() {
        Pair<String, Integer> oldLeader = this.leaderServer;
        for (int replicaIdx = 0; replicaIdx < this.replicaServerList.size(); ++replicaIdx) {
            Pair<String, Integer> connectToServer = this.replicaServerList.get(replicaIdx);
            this.currentServer = (String)connectToServer.getFirst();
            this.currentPort = (Integer)connectToServer.getSecond();
            try {
                this.requestClusterConfiguration();
            }
            catch (Exception e) {
                continue;
            }
            if (this.leaderServer == null) continue;
            return true;
        }
        if (oldLeader != null) {
            this.leaderServer = null;
            this.currentServer = (String)oldLeader.getFirst();
            this.currentPort = (Integer)oldLeader.getSecond();
            this.requestClusterConfiguration();
        }
        return this.leaderServer != null;
    }

    private Map<String, Object> mapArgs(Object[] args) {
        Map<CallSite, Object> params = null;
        if (args != null && args.length > 0) {
            if (args.length == 1 && args[0] instanceof Map) {
                params = (Map)args[0];
            } else {
                params = new HashMap();
                for (Object o : args) {
                    params.put((CallSite)((Object)("" + params.size())), o);
                }
            }
        }
        return params;
    }

    private String getUrl(String command, String databaseName) {
        return "http://" + this.currentServer + ":" + this.currentPort + "/api/v" + this.apiVersion + "/" + command + "/" + databaseName;
    }

    protected ResultSet createResultSet(JSONObject response) {
        InternalResultSet resultSet = new InternalResultSet();
        JSONArray resultArray = response.getJSONArray("result");
        for (int i = 0; i < resultArray.length(); ++i) {
            JSONObject result = resultArray.getJSONObject(i);
            resultSet.add(this.json2Result(result));
        }
        return resultSet;
    }

    protected Result json2Result(JSONObject result) {
        Record record = this.json2Record(result);
        if (record == null) {
            return new ResultInternal(result.toMap());
        }
        return new ResultInternal((Identifiable)record);
    }

    protected Record json2Record(JSONObject result) {
        Map map = result.toMap();
        if (map.containsKey("@cat")) {
            String cat;
            switch (cat = result.getString("@cat")) {
                case "d": {
                    return new RemoteImmutableDocument(this, map);
                }
                case "v": {
                    return new RemoteImmutableVertex(this, map);
                }
                case "e": {
                    return new RemoteImmutableEdge(this, map);
                }
            }
        }
        return null;
    }

    public static interface Callback {
        public Object call(HttpURLConnection var1, JSONObject var2) throws Exception;
    }

    public static enum CONNECTION_STRATEGY {
        STICKY,
        ROUND_ROBIN;

    }
}

