/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.network.binary;

import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.database.RID;
import com.arcadedb.log.LogManager;
import com.arcadedb.network.binary.Channel;
import com.arcadedb.network.binary.ChannelDataInput;
import com.arcadedb.network.binary.ChannelDataOutput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.logging.Level;

public abstract class ChannelBinary
extends Channel
implements ChannelDataInput,
ChannelDataOutput {
    private static final int MAX_LENGTH_DEBUG = 150;
    protected final boolean debug;
    private final int maxChunkSize;
    protected DataInputStream in;
    protected DataOutputStream out;

    public ChannelBinary(Socket iSocket, int chunkMaxSize) throws IOException {
        super(iSocket);
        this.maxChunkSize = chunkMaxSize;
        this.debug = false;
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Connected", null, (Object)this.socket.getRemoteSocketAddress());
        }
    }

    @Override
    public boolean inputHasData() {
        if (this.in != null) {
            try {
                return this.in.available() > 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public byte readByte() throws IOException {
        this.updateMetricReceivedBytes(1);
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Reading byte (1 byte)...", null, (Object)this.socket.getRemoteSocketAddress());
            byte value = this.in.readByte();
            LogManager.instance().log((Object)this, Level.INFO, "%s - Read byte: %d", null, (Object)this.socket.getRemoteSocketAddress(), (Object)value);
            return value;
        }
        return this.in.readByte();
    }

    public int readUnsignedByte() throws IOException {
        this.updateMetricReceivedBytes(1);
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Reading byte (1 byte)...", null, (Object)this.socket.getRemoteSocketAddress());
            int value = this.in.readUnsignedByte();
            LogManager.instance().log((Object)this, Level.INFO, "%s - Read byte: %d", null, (Object)this.socket.getRemoteSocketAddress(), (Object)value);
            return value;
        }
        return this.in.readUnsignedByte();
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.updateMetricReceivedBytes(1);
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Reading boolean (1 byte)...", null, (Object)this.socket.getRemoteSocketAddress());
            boolean value = this.in.readBoolean();
            LogManager.instance().log((Object)this, Level.INFO, "%s - Read boolean: %b", null, (Object)this.socket.getRemoteSocketAddress(), (Object)value);
            return value;
        }
        return this.in.readBoolean();
    }

    @Override
    public int readInt() throws IOException {
        this.updateMetricReceivedBytes(4);
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Reading int (4 bytes)...", null, (Object)this.socket.getRemoteSocketAddress());
            int value = this.in.readInt();
            LogManager.instance().log((Object)this, Level.INFO, "%s - Read int: %d", null, (Object)this.socket.getRemoteSocketAddress(), (Object)value);
            return value;
        }
        return this.in.readInt();
    }

    public long readUnsignedInt() throws IOException {
        this.updateMetricReceivedBytes(4);
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Reading unsigned int (4 bytes)...", null, (Object)this.socket.getRemoteSocketAddress());
            long value = (long)this.in.readInt() & 0xFFFFFFFFL;
            LogManager.instance().log((Object)this, Level.INFO, "%s - Read unsigned int: %d", null, (Object)this.socket.getRemoteSocketAddress(), (Object)value);
            return value;
        }
        return (long)this.in.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() throws IOException {
        this.updateMetricReceivedBytes(8);
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Reading long (8 bytes)...", null, (Object)this.socket.getRemoteSocketAddress());
            long value = this.in.readLong();
            LogManager.instance().log((Object)this, Level.INFO, "%s - Read long: %d", null, (Object)this.socket.getRemoteSocketAddress(), (Object)value);
            return value;
        }
        return this.in.readLong();
    }

    @Override
    public short readShort() throws IOException {
        this.updateMetricReceivedBytes(2);
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Reading short (2 bytes)...", null, (Object)this.socket.getRemoteSocketAddress());
            short value = this.in.readShort();
            LogManager.instance().log((Object)this, Level.INFO, "%s - Read short: %d", null, (Object)this.socket.getRemoteSocketAddress(), (Object)value);
            return value;
        }
        return this.in.readShort();
    }

    public int readUnsignedShort() throws IOException {
        this.updateMetricReceivedBytes(2);
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Reading ushort (2 bytes)...", null, (Object)this.socket.getRemoteSocketAddress());
            int value = this.in.readUnsignedShort();
            LogManager.instance().log((Object)this, Level.INFO, "%s - Read ushort: %d", null, (Object)this.socket.getRemoteSocketAddress(), (Object)value);
            return value;
        }
        return this.in.readUnsignedShort();
    }

    @Override
    public String readString() throws IOException {
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Reading string (4+N bytes)...", null, (Object)this.socket.getRemoteSocketAddress());
            int len = this.in.readInt();
            if (len < 0) {
                return null;
            }
            byte[] tmp = new byte[len];
            this.in.readFully(tmp);
            this.updateMetricReceivedBytes(4 + len);
            String value = new String(tmp, StandardCharsets.UTF_8);
            LogManager.instance().log((Object)this, Level.INFO, "%s - Read string: %s", null, (Object)this.socket.getRemoteSocketAddress(), (Object)value);
            return value;
        }
        int len = this.in.readInt();
        if (len < 0) {
            return null;
        }
        byte[] tmp = new byte[len];
        this.in.readFully(tmp);
        this.updateMetricReceivedBytes(4 + len);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public void readBytes(byte[] buffer) throws IOException {
        this.in.readFully(buffer);
    }

    @Override
    public byte[] readBytes() throws IOException {
        int len;
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Reading chunk of bytes. Reading chunk length as int (4 bytes)...", null, (Object)this.socket.getRemoteSocketAddress());
        }
        if ((len = this.in.readInt()) > this.maxChunkSize) {
            throw new IOException("Impossible to read a chunk of length:" + len + " max allowed chunk length:" + this.maxChunkSize + " see NETWORK_BINARY_MAX_CONTENT_LENGTH settings ");
        }
        this.updateMetricReceivedBytes(4 + len);
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Read chunk length: %d", null, (Object)this.socket.getRemoteSocketAddress(), (Object)len);
        }
        if (len < 0) {
            return null;
        }
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Reading %d bytes...", null, (Object)this.socket.getRemoteSocketAddress(), (Object)len);
        }
        byte[] tmp = new byte[len];
        this.in.readFully(tmp);
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Read %d bytes: %s", null, (Object)this.socket.getRemoteSocketAddress(), (Object)len, (Object)new String(tmp, DatabaseFactory.getDefaultCharset()));
        }
        return tmp;
    }

    @Override
    public RID readRID(Database database) throws IOException {
        int bucketId = this.readInt();
        long clusterPosition = this.readLong();
        return new RID(database, bucketId, clusterPosition);
    }

    @Override
    public int readVersion() throws IOException {
        return this.readInt();
    }

    @Override
    public ChannelBinary writeByte(byte iContent) throws IOException {
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Writing byte (1 byte): %d", null, (Object)this.socket.getRemoteSocketAddress(), (Object)iContent);
        }
        this.out.write(iContent);
        this.updateMetricTransmittedBytes(1);
        return this;
    }

    @Override
    public ChannelBinary writeBoolean(boolean iContent) throws IOException {
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Writing boolean (1 byte): %b", null, (Object)this.socket.getRemoteSocketAddress(), (Object)iContent);
        }
        this.out.writeBoolean(iContent);
        this.updateMetricTransmittedBytes(1);
        return this;
    }

    @Override
    public ChannelBinary writeInt(int iContent) throws IOException {
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Writing int (4 bytes): %d", null, (Object)this.socket.getRemoteSocketAddress(), (Object)iContent);
        }
        this.out.writeInt(iContent);
        this.updateMetricTransmittedBytes(4);
        return this;
    }

    public ChannelBinary writeUnsignedInt(int iContent) throws IOException {
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Writing uint (4 bytes): %d", null, (Object)this.socket.getRemoteSocketAddress(), (Object)iContent);
        }
        this.out.writeInt((int)Integer.toUnsignedLong(iContent));
        this.updateMetricTransmittedBytes(4);
        return this;
    }

    @Override
    public ChannelBinary writeLong(long iContent) throws IOException {
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Writing long (8 bytes): %d", null, (Object)this.socket.getRemoteSocketAddress(), (Object)iContent);
        }
        this.out.writeLong(iContent);
        this.updateMetricTransmittedBytes(8);
        return this;
    }

    @Override
    public ChannelBinary writeShort(short iContent) throws IOException {
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Writing short (2 bytes): %d", null, (Object)this.socket.getRemoteSocketAddress(), (Object)iContent);
        }
        this.out.writeShort(iContent);
        this.updateMetricTransmittedBytes(2);
        return this;
    }

    public ChannelBinary writeUnsignedShort(short iContent) throws IOException {
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Writing ushort (2 bytes): %d", null, (Object)this.socket.getRemoteSocketAddress(), (Object)iContent);
        }
        this.out.writeShort(Short.toUnsignedInt(iContent));
        this.updateMetricTransmittedBytes(2);
        return this;
    }

    @Override
    public ChannelBinary writeString(String iContent) throws IOException {
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Writing string (4+%d=%d bytes): %s", null, (Object)this.socket.getRemoteSocketAddress(), (Object)(iContent != null ? iContent.length() : 0), (Object)(iContent != null ? iContent.length() + 4 : 4), (Object)iContent);
        }
        if (iContent == null) {
            this.out.writeInt(-1);
            this.updateMetricTransmittedBytes(4);
        } else {
            byte[] buffer = iContent.getBytes(StandardCharsets.UTF_8);
            this.out.writeInt(buffer.length);
            this.out.write(buffer, 0, buffer.length);
            this.updateMetricTransmittedBytes(4 + buffer.length);
        }
        return this;
    }

    @Override
    public ChannelBinary writeVarLengthBytes(byte[] iContent) throws IOException {
        return this.writeVarLengthBytes(iContent, iContent != null ? iContent.length : 0);
    }

    @Override
    public ChannelBinary writeVarLengthBytes(byte[] iContent, int iLength) throws IOException {
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Writing bytes (4+%d=%d bytes): %s", null, (Object)this.socket.getRemoteSocketAddress(), (Object)iLength, (Object)(iLength + 4), (Object)Arrays.toString(iContent));
        }
        if (iContent == null) {
            this.out.writeInt(-1);
            this.updateMetricTransmittedBytes(4);
        } else {
            if (iLength > this.maxChunkSize) {
                throw new IOException("Impossible to write a chunk of " + iLength + " bytes. Max allowed chunk is " + this.maxChunkSize + " bytes. See NETWORK_BINARY_MAX_CONTENT_LENGTH settings ");
            }
            this.out.writeInt(iLength);
            this.out.write(iContent, 0, iLength);
            this.updateMetricTransmittedBytes(4 + iLength);
        }
        return this;
    }

    public ChannelBinary writeBytes(byte[] content) throws IOException {
        if (content != null) {
            int length = content.length;
            if (this.debug) {
                LogManager.instance().log((Object)this, Level.INFO, "%s - Writing bytes (%d bytes): %s", null, (Object)this.socket.getRemoteSocketAddress(), (Object)length, (Object)Arrays.toString(content));
            }
            if (length > this.maxChunkSize) {
                throw new IOException("Impossible to write a chunk of " + length + " bytes. Max allowed chunk is " + this.maxChunkSize + " bytes. See NETWORK_BINARY_MAX_CONTENT_LENGTH settings ");
            }
            this.out.write(content, 0, length);
            this.updateMetricTransmittedBytes(length);
        }
        return this;
    }

    @Override
    public void writeRID(RID iRID) throws IOException {
        this.writeInt(iRID.getBucketId());
        this.writeLong(iRID.getPosition());
    }

    @Override
    public void writeVersion(int version) throws IOException {
        this.writeInt(version);
    }

    public void clearInput() throws IOException {
        if (this.in == null) {
            return;
        }
        StringBuilder dirtyBuffer = new StringBuilder(150);
        int i = 0;
        while (this.in.available() > 0) {
            char c = (char)this.in.read();
            ++i;
            if (dirtyBuffer.length() >= 150) continue;
            dirtyBuffer.append(c);
        }
        this.updateMetricReceivedBytes(i);
        String message = "Received unread response from " + this.socket.getRemoteSocketAddress() + " probably corrupted data from the network connection. Cleared dirty data in the buffer (" + i + " bytes): [" + dirtyBuffer + (i > dirtyBuffer.length() ? "..." : "") + "]";
        LogManager.instance().log((Object)this, Level.SEVERE, message);
        throw new IOException(message);
    }

    @Override
    public void flush() throws IOException {
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Flush", null, this.socket != null ? " null possible previous close" : this.socket.getRemoteSocketAddress());
        }
        this.updateMetricFlushes();
        if (this.out != null) {
            this.out.flush();
        } else {
            super.flush();
        }
    }

    @Override
    public synchronized void close() {
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Closing socket...", null, this.socket != null ? " null possible previous close" : this.socket.getRemoteSocketAddress());
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException e) {
            LogManager.instance().log((Object)this, Level.FINE, "Error during closing of input stream", (Throwable)e);
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException e) {
            LogManager.instance().log((Object)this, Level.FINE, "Error during closing of output stream", (Throwable)e);
        }
        super.close();
    }

    @Override
    public DataOutputStream getDataOutput() {
        return this.out;
    }

    @Override
    public DataInputStream getDataInput() {
        return this.in;
    }

    public ChannelBinary writeBuffer(ByteBuffer buffer) throws IOException {
        int length = buffer.limit();
        if (this.debug) {
            LogManager.instance().log((Object)this, Level.INFO, "%s - Writing bytes (%d bytes) from DirectBuffer", null, (Object)this.socket.getRemoteSocketAddress(), (Object)length);
        }
        if (length > this.maxChunkSize) {
            throw new IOException("Impossible to write a chunk of " + length + " bytes max allowed chunk is " + this.maxChunkSize + " bytes. See NETWORK_BINARY_MAX_CONTENT_LENGTH settings ");
        }
        this.out.write(buffer.array(), buffer.arrayOffset(), length);
        this.updateMetricTransmittedBytes(length);
        return this;
    }
}

