/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer;

import com.arcadedb.log.LogManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.logging.Level;

public class Source {
    public final String url;
    public InputStream inputStream;
    public final long totalSize;
    public final boolean compressed;
    private final com.arcadedb.utility.Callable<Void, Source> resetCallback;
    private final Callable<Void> closeCallback;

    public Source(String url, InputStream inputStream, long totalSize, boolean compressed, com.arcadedb.utility.Callable<Void, Source> resetCallback, Callable<Void> closeCallback) {
        this.url = url;
        this.inputStream = inputStream;
        this.totalSize = totalSize;
        this.compressed = compressed;
        this.resetCallback = resetCallback;
        this.closeCallback = closeCallback;
    }

    public void reset() throws IOException {
        if (this.resetCallback != null) {
            try {
                this.resetCallback.call((Object)this);
            }
            catch (Exception e) {
                LogManager.instance().log((Object)this, Level.SEVERE, "Error on resetting source %s", (Throwable)e, (Object)this);
            }
        }
    }

    public void close() {
        try {
            this.closeCallback.call();
        }
        catch (Exception e) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Error on closing source %s", (Throwable)e, (Object)this);
        }
    }

    public String toString() {
        return this.url + " (compressed=" + this.compressed + " size=" + this.totalSize + ")";
    }
}

