/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer;

import com.arcadedb.Constants;
import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.database.Identifiable;
import com.arcadedb.exception.DuplicatedKeyException;
import com.arcadedb.exception.NeedRetryException;
import com.arcadedb.graph.MutableEdge;
import com.arcadedb.graph.MutableVertex;
import com.arcadedb.graph.Vertex;
import com.arcadedb.index.IndexCursor;
import com.arcadedb.integration.importer.ImporterContext;
import com.arcadedb.schema.DocumentType;
import com.arcadedb.schema.Schema;
import com.arcadedb.schema.Type;
import com.arcadedb.schema.VertexType;
import com.arcadedb.serializer.json.JSONArray;
import com.arcadedb.serializer.json.JSONException;
import com.arcadedb.serializer.json.JSONObject;
import com.arcadedb.utility.Callable;
import com.arcadedb.utility.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;

public class Neo4jImporter {
    protected Database database;
    protected Callable<Void, JSONObject> parsingCallback;
    protected int indexPageSize = 262144;
    protected int bucketsPerType = 1;
    private boolean closeDatabaseAfterImport = true;
    private InputStream inputStream;
    private String databasePath;
    private String inputFile;
    private boolean overwriteDatabase = false;
    private Type typeForDecimals = Type.DECIMAL;
    private final Map<String, Long> totalVerticesByType = new HashMap<String, Long>();
    private long totalVerticesParsed = 0L;
    private final Map<String, Long> totalEdgesByType = new HashMap<String, Long>();
    private long totalEdgesParsed = 0L;
    private long totalAttributesParsed = 0L;
    private int batchSize = 10000;
    private long beginTimeVerticesCreation;
    private long beginTimeEdgesCreation;
    private boolean error = false;
    private final ImporterContext context;
    private final Map<String, Map<String, Type>> schemaProperties = new HashMap<String, Map<String, Type>>();
    private static final SimpleDateFormat dateTimeISO8601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static final int MAX_RETRIES = 3;

    public Neo4jImporter(InputStream inputStream, String ... args) {
        this.parseArguments(args);
        this.inputStream = inputStream;
        this.context = new ImporterContext();
        if (inputStream == null) {
            this.syntaxError("Input Stream is null");
        }
    }

    public Neo4jImporter(String ... args) {
        this.parseArguments(args);
        this.context = new ImporterContext();
        if (this.inputFile == null) {
            this.syntaxError("Missing input file. Use -f <file-path>");
        }
    }

    public Neo4jImporter(Database database, ImporterContext context) {
        this.database = database;
        this.context = context;
        this.closeDatabaseAfterImport = false;
    }

    public static void main(String[] args) throws IOException {
        new Neo4jImporter(args).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        if (this.databasePath == null) {
            this.log("Checking Neo4j database from file '%s'...", this.inputFile);
        } else {
            this.log("Importing Neo4j database from file '%s' to '%s'", this.inputFile, this.databasePath);
            DatabaseFactory factory = new DatabaseFactory(this.databasePath);
            if (factory.exists()) {
                if (!this.overwriteDatabase) {
                    this.error("Database already exists on path '%s'", this.databasePath);
                    return;
                }
                this.database = factory.open();
                this.error("Found existent database at '%s', dropping it and recreate a new one", this.databasePath);
                this.database.drop();
            }
            this.database = factory.create();
        }
        try {
            String additional;
            long entries;
            String typeName;
            this.context.startedOn = System.currentTimeMillis();
            this.log("- Creation of the schema: types, properties and indexes", new Object[0]);
            this.syncSchema();
            this.log("- Creation of vertices started", new Object[0]);
            this.beginTimeVerticesCreation = System.currentTimeMillis();
            this.parseVertices();
            this.log("- Creation of edges started: creating edges between vertices", new Object[0]);
            this.beginTimeEdgesCreation = System.currentTimeMillis();
            this.parseEdges();
            long elapsed = (System.currentTimeMillis() - this.context.startedOn) / 1000L;
            this.log("***************************************************************************************************", new Object[0]);
            this.log("Import of Neo4j database completed in %,d secs with %,d errors and %,d warnings.", elapsed, this.context.errors.get(), this.context.warnings.get());
            this.log("\nSUMMARY\n", new Object[0]);
            this.log("- Vertices.............: %,d", this.totalVerticesParsed);
            for (Map.Entry<String, Long> entry : this.totalVerticesByType.entrySet()) {
                typeName = entry.getKey();
                Long verticesByClass = this.totalVerticesByType.get(typeName);
                entries = verticesByClass != null ? verticesByClass : 0L;
                additional = "";
                this.log("-- %-20s: %,d %s", typeName, entries, "");
            }
            this.log("- Edges................: %,d", this.totalEdgesParsed);
            for (Map.Entry<String, Long> entry : this.totalEdgesByType.entrySet()) {
                typeName = entry.getKey();
                Long edgesByClass = this.totalEdgesByType.get(typeName);
                entries = edgesByClass != null ? edgesByClass : 0L;
                additional = "";
                this.log("-- %-20s: %,d %s", typeName, entries, "");
            }
            this.log("- Total attributes.....: %,d", this.totalAttributesParsed);
            this.log("***************************************************************************************************", new Object[0]);
            this.log("", new Object[0]);
            this.log("NOTES:", new Object[0]);
            if (this.database != null) {
                this.log("- you can find your new ArcadeDB database in '" + this.database.getDatabasePath() + "'", new Object[0]);
            }
        }
        finally {
            if (this.database != null && this.closeDatabaseAfterImport) {
                this.database.close();
            }
        }
    }

    public boolean isError() {
        return this.error;
    }

    private void syncSchema() throws IOException {
        VertexType rootNodeType = (VertexType)this.database.getSchema().buildVertexType().withName("Node").withTotalBuckets(this.bucketsPerType).withIgnoreIfExists(true).create();
        rootNodeType.getOrCreateProperty("id", Type.STRING);
        rootNodeType.getOrCreateTypeIndex(Schema.INDEX_TYPE.LSM_TREE, true, new String[]{"id"}, this.indexPageSize);
        this.readFile((Callable<Void, JSONObject>)((Callable)json -> {
            switch (json.getString("type")) {
                case "node": {
                    Pair<String, List<String>> labels = this.typeNameFromLabels((JSONObject)json);
                    if (!this.database.getSchema().existsType((String)labels.getFirst())) {
                        VertexType type = (VertexType)this.database.getSchema().buildVertexType().withName((String)labels.getFirst()).withTotalBuckets(this.bucketsPerType).withIgnoreIfExists(true).create();
                        if (labels.getSecond() != null) {
                            for (String parent : (List)labels.getSecond()) {
                                VertexType parentType = this.database.getSchema().getOrCreateVertexType(parent);
                                parentType.addSuperType((DocumentType)rootNodeType);
                                type.addSuperType((DocumentType)parentType);
                            }
                        } else {
                            type.addSuperType((DocumentType)rootNodeType);
                        }
                    }
                    this.inferPropertyType((JSONObject)json, (String)labels.getFirst());
                    break;
                }
                case "relationship": {
                    String edgeLabel;
                    String string = edgeLabel = json.has("label") && !json.isNull("label") ? json.getString("label") : null;
                    if (edgeLabel != null) {
                        this.database.getSchema().buildEdgeType().withName(edgeLabel).withTotalBuckets(this.bucketsPerType).withIgnoreIfExists(true).create();
                    }
                    this.inferPropertyType((JSONObject)json, edgeLabel);
                }
            }
            return null;
        }));
    }

    private void inferPropertyType(JSONObject json, String label) {
        if (!json.has("properties")) {
            return;
        }
        Map typeProperties = this.schemaProperties.computeIfAbsent(label, k -> new HashMap());
        JSONObject properties = json.getJSONObject("properties");
        for (String propName : properties.keySet()) {
            Object propValue;
            ++this.totalAttributesParsed;
            Type currentType = (Type)typeProperties.get(propName);
            if (currentType != null || (propValue = properties.get(propName)) == null || propValue.equals(JSONObject.NULL)) continue;
            if (propValue instanceof String) {
                String string = (String)propValue;
                try {
                    dateTimeISO8601Format.parse(string);
                    currentType = Type.DATETIME;
                }
                catch (ParseException e) {
                    currentType = Type.STRING;
                }
            } else {
                if (propValue instanceof JSONObject) {
                    JSONObject object = (JSONObject)propValue;
                    propValue = object.toMap();
                } else if (propValue instanceof JSONArray) {
                    JSONArray array = (JSONArray)propValue;
                    propValue = array.toList();
                }
                currentType = Type.getTypeByValue((Object)propValue);
            }
            typeProperties.put(propName, currentType);
        }
    }

    private void parseVertices() throws IOException {
        AtomicInteger lineNumber = new AtomicInteger();
        this.readFile((Callable<Void, JSONObject>)((Callable)json -> {
            lineNumber.incrementAndGet();
            switch (json.getString("type")) {
                case "node": {
                    Pair<String, List<String>> type;
                    this.context.parsed.incrementAndGet();
                    ++this.totalVerticesParsed;
                    if (this.context.parsed.get() > 0L && this.context.parsed.get() % 1000000L == 0L) {
                        long elapsed = System.currentTimeMillis() - this.beginTimeVerticesCreation;
                        this.log("- Status update: created %,d vertices, skipped %,d edges (%,d vertices/sec)", this.context.createdVertices.get(), this.context.skippedEdges.get(), this.context.createdVertices.get() / elapsed * 1000L);
                    }
                    if ((type = this.typeNameFromLabels((JSONObject)json)) == null) {
                        this.log("- found vertex in line %d without labels. Skip it.", lineNumber.get());
                        this.context.warnings.incrementAndGet();
                        return null;
                    }
                    String typeName = (String)type.getFirst();
                    String id = json.getString("id");
                    try {
                        MutableVertex vertex = this.database.newVertex(typeName);
                        if (json.has("properties")) {
                            vertex.fromMap(this.setProperties(json.getJSONObject("properties"), this.schemaProperties.get(typeName)));
                        }
                        vertex.set("id", (Object)id);
                        vertex.save();
                        this.context.createdVertices.incrementAndGet();
                        this.incrementVerticesByType(typeName);
                    }
                    catch (Exception e) {
                        this.error("- Error on saving vertex with id %s: %s", id, e.getMessage());
                        this.context.errors.incrementAndGet();
                    }
                    break;
                }
                case "relationship": {
                    this.context.skippedEdges.incrementAndGet();
                }
            }
            if (this.parsingCallback != null) {
                this.parsingCallback.call(json);
            }
            return null;
        }));
        long elapsedInSecs = (System.currentTimeMillis() - this.context.startedOn) / 1000L;
        this.log("- Creation of vertices completed: created %,d vertices, skipped %,d edges (%,d vertices/sec elapsed=%,d secs)", this.context.createdVertices.get(), this.context.skippedEdges.get(), elapsedInSecs > 0L ? this.context.createdVertices.get() / elapsedInSecs : 0L, elapsedInSecs);
    }

    private void parseEdges() throws IOException {
        this.database.begin();
        AtomicInteger lineNumber = new AtomicInteger();
        this.readFile((Callable<Void, JSONObject>)((Callable)json -> {
            lineNumber.incrementAndGet();
            switch (json.getString("type")) {
                case "node": {
                    break;
                }
                case "relationship": {
                    String type;
                    this.context.parsed.incrementAndGet();
                    ++this.totalEdgesParsed;
                    if (this.context.parsed.get() > 0L && this.context.parsed.get() % 1000000L == 0L) {
                        long elapsed = System.currentTimeMillis() - this.beginTimeEdgesCreation;
                        this.log("- Status update: created %,d edges %s (%,d edges/sec)", this.context.createdEdges.get(), this.totalEdgesByType, this.context.createdEdges.get() / elapsed * 1000L);
                    }
                    if ((type = json.getString("label")) == null) {
                        this.log("- found edge in line %d without labels. Skip it.", lineNumber.get());
                        this.context.warnings.incrementAndGet();
                        return null;
                    }
                    JSONObject start = json.getJSONObject("start");
                    Pair<String, List<String>> startType = this.typeNameFromLabels(start);
                    String startId = start.getString("id");
                    IndexCursor beginCursor = this.database.lookupByKey((String)startType.getFirst(), "id", (Object)startId);
                    if (!beginCursor.hasNext()) {
                        this.log("- cannot create relationship with id '%s'. Vertex id '%s' not found in type '%s'. Skip it.", json.getString("id"), startId, startType.getFirst());
                        this.context.warnings.incrementAndGet();
                        return null;
                    }
                    Vertex fromVertex = ((Identifiable)beginCursor.next()).asVertex();
                    JSONObject end = json.getJSONObject("end");
                    Pair<String, List<String>> endType = this.typeNameFromLabels(end);
                    String endId = end.getString("id");
                    IndexCursor endCursor = this.database.lookupByKey((String)endType.getFirst(), "id", (Object)endId);
                    if (!endCursor.hasNext()) {
                        this.log("- cannot create relationship with id '%s'. Vertex id '%s' not found for labels. Skip it.", json.getString("id"), endId);
                        this.context.warnings.incrementAndGet();
                        return null;
                    }
                    Identifiable toVertex = (Identifiable)endCursor.next();
                    try {
                        MutableEdge edge = fromVertex.newEdge(type, toVertex, new Object[0]);
                        if (json.has("properties")) {
                            edge.fromMap(this.setProperties(json.getJSONObject("properties"), this.schemaProperties.get(type)));
                        }
                        edge.save();
                        this.context.createdEdges.incrementAndGet();
                        this.incrementEdgesByType(type);
                    }
                    catch (Exception e) {
                        this.error("- Error on saving edge between %s and %s: %s", fromVertex, toVertex, e.getMessage());
                        this.context.errors.incrementAndGet();
                    }
                    if (this.context.parsed.get() <= 0L || this.context.parsed.get() % (long)this.batchSize != 0L) break;
                    this.database.commit();
                    this.database.begin();
                }
            }
            return null;
        }));
        this.database.commit();
        long elapsedInSecs = (System.currentTimeMillis() - this.context.startedOn) / 1000L;
        this.log("- Creation of edged completed: created %,d edges, (%,d edges/sec elapsed=%,d secs)", this.context.createdEdges.get(), elapsedInSecs > 0L ? this.context.createdEdges.get() / elapsedInSecs : 0L, elapsedInSecs);
    }

    /*
     * Unable to fully structure code
     */
    private Map<String, Object> setProperties(JSONObject properties, Map<String, Type> typeSchema) {
        result = new HashMap<String, Object>();
        for (String propName : properties.keySet()) {
            block7: {
                block9: {
                    block8: {
                        block6: {
                            propValue = properties.get(propName);
                            if (propValue != JSONObject.NULL) break block6;
                            propValue = null;
                            break block7;
                        }
                        if (!(propValue instanceof JSONObject)) break block8;
                        object = (JSONObject)propValue;
                        propValue = this.setProperties(object, null);
                        break block7;
                    }
                    if (!(propValue instanceof JSONArray)) break block9;
                    array = (JSONArray)propValue;
                    propValue = array.toList();
                    break block7;
                }
                if (!(propValue instanceof String)) ** GOTO lbl-1000
                string = (String)propValue;
                if (typeSchema != null && typeSchema.get(propName) == Type.DATETIME) {
                    try {
                        propValue = Neo4jImporter.dateTimeISO8601Format.parse(string).getTime();
                    }
                    catch (ParseException e) {
                        this.log("Invalid date '%s', ignoring conversion to timestamp and leaving it as string", new Object[]{propValue});
                        this.context.errors.incrementAndGet();
                    }
                } else if (propValue instanceof BigDecimal) {
                    propValue = this.typeForDecimals.newInstance((Object)propValue);
                }
            }
            result.put(propName, propValue);
        }
        return result;
    }

    public InputStream openInputStream() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.reset();
            return this.inputStream;
        }
        File file = new File(this.inputFile);
        if (!file.exists()) {
            this.error = true;
            throw new IllegalArgumentException("File '" + this.inputFile + "' not found");
        }
        return file.getName().endsWith("gz") ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
    }

    private void readFile(Callable<Void, JSONObject> callback) throws IOException {
        this.database.begin();
        try (InputStream inputStream = this.openInputStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, DatabaseFactory.getDefaultCharset()));){
            long lineNumberStartOfBatch = 0L;
            ArrayList<String> transactionBuffer = new ArrayList<String>(this.batchSize);
            String line = null;
            long lineNumber = 0L;
            while (true) {
                try {
                    line = reader.readLine();
                    if (line == null) {
                        if (this.database.isTransactionActive()) {
                            this.database.commit();
                        }
                        transactionBuffer.clear();
                        break;
                    }
                    transactionBuffer.add(line);
                    this.executeCallback(callback, line, lineNumber);
                    if (this.context.parsed.get() > 0L && this.context.parsed.get() % (long)this.batchSize == 0L && this.database.isTransactionActive()) {
                        this.database.commit();
                        transactionBuffer.clear();
                        lineNumberStartOfBatch = lineNumber;
                        this.database.begin();
                    }
                }
                catch (DuplicatedKeyException | NeedRetryException e) {
                    this.log("Transaction commit in error (%s), retrying the last transaction batch max %d times", e.getMessage(), 3);
                    for (int retry = 0; retry < 3; ++retry) {
                        try {
                            if (this.database.isTransactionActive()) {
                                this.database.rollback();
                            }
                            this.database.begin();
                            for (int i = 0; i < transactionBuffer.size(); ++i) {
                                line = (String)transactionBuffer.get(i);
                                this.executeCallback(callback, line, lineNumberStartOfBatch + (long)i);
                            }
                            this.database.commit();
                            transactionBuffer.clear();
                        }
                        catch (DuplicatedKeyException | NeedRetryException e2) {
                            this.log("Concurrent access to the database, retrying the last transaction batch (retry %d/%d)", retry + 1, 3);
                            continue;
                        }
                    }
                }
                catch (JSONException e) {
                    this.log("Error on parsing json on line %d of the input JSONL file. The line will be ignored. JSON: %s", lineNumber, line);
                    this.context.errors.incrementAndGet();
                }
                ++lineNumber;
            }
        }
    }

    private void executeCallback(Callable<Void, JSONObject> callback, String line, long lineNumber) {
        JSONObject json = new JSONObject(line);
        switch (json.getString("type")) {
            case "node": {
                callback.call((Object)json);
                break;
            }
            case "relationship": {
                callback.call((Object)json);
                break;
            }
            default: {
                this.log("Invalid 'type' content on line %d of the input JSONL file. The line will be ignored. JSON: %s", lineNumber, line);
                this.context.errors.incrementAndGet();
            }
        }
    }

    private void incrementVerticesByType(String label) {
        Long vertices = this.totalVerticesByType.get(label);
        this.totalVerticesByType.put(label, vertices == null ? 1L : vertices + 1L);
    }

    private void incrementEdgesByType(String label) {
        Long edges = this.totalEdgesByType.get(label);
        this.totalEdgesByType.put(label, edges == null ? 1L : edges + 1L);
    }

    private Pair<String, List<String>> typeNameFromLabels(JSONObject json) {
        JSONArray nodeLabels;
        JSONArray jSONArray = nodeLabels = json.has("labels") && !json.isNull("labels") ? json.getJSONArray("labels") : null;
        if (nodeLabels != null && !nodeLabels.isEmpty()) {
            if (nodeLabels.length() > 1) {
                List list = nodeLabels.toList().stream().map(String.class::cast).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
                return new Pair((Object)String.join((CharSequence)"_", list), list);
            }
            return new Pair((Object)((String)nodeLabels.get(0)), null);
        }
        return null;
    }

    private void log(String text, Object ... args) {
        if (args.length == 0) {
            System.out.println(text);
        } else {
            System.out.printf(text + "%n", args);
        }
    }

    private void error(String text, Object ... args) {
        if (args.length == 0) {
            System.out.println(text);
        } else {
            System.out.println(text.formatted(args));
        }
    }

    private void syntaxError(String s) {
        this.log("Syntax error: " + s, new Object[0]);
        this.error = true;
        this.printHelp();
    }

    private void printHeader() {
        this.log("ArcadeDB " + Constants.getVersion() + " - Neo4j Importer", new Object[0]);
    }

    private void printHelp() {
        this.log("Use:", new Object[0]);
        this.log("-d <database-path>: create a database from the Neo4j export", new Object[0]);
        this.log("-i <input-file>: path to the Neo4j export file in JSONL format", new Object[0]);
        this.log("-o: overwrite an existent database", new Object[0]);
        this.log("-decimalType <type>: use <type> for decimals. <type> can be FLOAT, DOUBLE and DECIMAL. By default decimalType is DECIMAL.", new Object[0]);
    }

    private void parseArguments(String ... args) {
        this.printHeader();
        String state = null;
        for (String arg : args) {
            if (arg.equals("-?")) {
                this.printHelp();
                continue;
            }
            if (arg.equals("-d")) {
                state = "databasePath";
                continue;
            }
            if (arg.equals("-i")) {
                state = "inputFile";
                continue;
            }
            if (arg.equals("-o")) {
                this.overwriteDatabase = true;
                continue;
            }
            if (arg.equals("-b")) {
                state = "batchSize";
                continue;
            }
            if (arg.equals("-decimalType")) {
                state = "decimalType";
                continue;
            }
            if (state == null) continue;
            if (state.equals("databasePath")) {
                this.databasePath = arg;
                continue;
            }
            if (state.equals("inputFile")) {
                this.inputFile = arg;
                continue;
            }
            if (state.equals("batchSize")) {
                this.batchSize = Integer.parseInt(arg);
                continue;
            }
            if (!state.equals("decimalType")) continue;
            this.typeForDecimals = Type.valueOf((String)arg.toUpperCase(Locale.ENGLISH));
        }
    }
}

