/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.backup;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class BackupSettings {
    public String format = "full";
    public String databaseURL;
    public String directory;
    public String file;
    public boolean overwriteFile = false;
    public int verboseLevel = 2;
    public final Map<String, String> options = new HashMap<String, String>();
    public String databaseName;

    protected void parseParameters(String[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; i += this.parseParameter(args[i].substring(1), i < args.length - 1 ? args[i + 1] : null)) {
            }
        }
        this.validateSettings();
    }

    public void validateSettings() {
        if (this.format == null) {
            throw new IllegalArgumentException("Missing backup format");
        }
        if (this.directory != null && this.file != null) {
            String f;
            String string = f = this.file.startsWith("file://") ? this.file.substring("file://".length()) : this.file;
            if (f.contains("..") || f.contains(File.separator)) {
                throw new IllegalArgumentException("Backup file cannot contain path change because the directory is specified");
            }
        }
        if (this.file == null) {
            switch (this.format) {
                case "full": {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmssSSS");
                    this.file = "%s-backup-%s.zip".formatted(this.databaseName, dateFormat.format(System.currentTimeMillis()));
                }
            }
        }
    }

    public int parseParameter(String name, String value) {
        if ("format".equals(name)) {
            if (value != null) {
                this.format = value.toLowerCase(Locale.ENGLISH);
            }
        } else if ("dir".equals(name)) {
            if (value != null) {
                this.directory = value.endsWith(File.separator) ? value : value + File.separator;
            }
        } else if ("f".equals(name)) {
            if (value != null) {
                this.file = value;
            }
        } else if ("d".equals(name)) {
            if (value != null) {
                this.databaseURL = value;
            }
        } else {
            if ("o".equals(name)) {
                this.overwriteFile = true;
                return 1;
            }
            this.options.put(name, value);
        }
        return 2;
    }
}

