/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.exporter;

import com.arcadedb.database.Database;
import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.integration.exporter.ExportException;
import com.arcadedb.integration.exporter.ExporterContext;
import com.arcadedb.integration.exporter.ExporterSettings;
import com.arcadedb.integration.exporter.format.AbstractExporterFormat;
import com.arcadedb.integration.exporter.format.JsonlExporterFormat;
import com.arcadedb.integration.importer.ConsoleLogger;
import com.arcadedb.log.LogManager;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;

public class Exporter {
    protected ExporterSettings settings = new ExporterSettings();
    protected ExporterContext context = new ExporterContext();
    protected DatabaseInternal database;
    protected Timer timer;
    protected ConsoleLogger logger;
    protected AbstractExporterFormat formatImplementation;
    protected boolean closeDatabaseAtEnd = true;

    public Exporter(String[] args) {
        this.settings.parseParameters(args);
    }

    public Exporter(Database database, String file) {
        this.database = (DatabaseInternal)database;
        this.settings.file = file;
        this.closeDatabaseAtEnd = false;
    }

    public static void main(String[] args) {
        new Exporter(args).exportDatabase();
        System.exit(0);
    }

    public void setSettings(Map<String, String> parameters) {
        if (parameters != null) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                this.settings.parseParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    public Exporter setFormat(String format) {
        this.settings.format = format;
        return this;
    }

    public Exporter setOverwrite(boolean overwrite) {
        this.settings.overwriteFile = overwrite;
        return this;
    }

    public Map<String, Object> exportDatabase() {
        try {
            this.startExporting();
            this.openDatabase();
            this.formatImplementation = this.createFormatImplementation();
            this.formatImplementation.exportDatabase();
            long elapsedInSecs = (System.currentTimeMillis() - this.context.startedOn) / 1000L;
            if (elapsedInSecs == 0L) {
                elapsedInSecs = 1L;
            }
            long totalRecords = this.context.vertices.get() + this.context.edges.get() + this.context.documents.get();
            this.logger.logLine(0, "Database exported successfully: %,d records exported in %s secs (%,d records/secs %,d documents %,d vertices %,d edges)", totalRecords, elapsedInSecs, totalRecords / elapsedInSecs, this.context.documents.get(), this.context.vertices.get(), this.context.edges.get());
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            if (totalRecords > 0L) {
                result.put("totalRecords", totalRecords);
            }
            result.put("elapsedInSecs", totalRecords);
            if (this.context.documents.get() > 0L) {
                result.put("documents", this.context.documents.get());
            }
            if (this.context.vertices.get() > 0L) {
                result.put("vertices", this.context.vertices.get());
            }
            if (this.context.edges.get() > 0L) {
                result.put("edges", this.context.edges.get());
            }
            LinkedHashMap<String, Object> linkedHashMap = result;
            return linkedHashMap;
        }
        catch (Exception e) {
            throw new ExportException("Error on writing to '" + this.settings.file + "'", e);
        }
        finally {
            if (this.database != null) {
                this.stopExporting();
                this.closeDatabase();
            }
        }
    }

    protected void startExporting() {
        if (this.logger == null) {
            this.logger = new ConsoleLogger(this.settings.verboseLevel);
        }
        this.context.startedOn = this.context.lastLapOn = System.currentTimeMillis();
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Exporter.this.printProgress();
            }
        }, 5000L, 5000L);
    }

    protected void stopExporting() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    protected void openDatabase() {
        if (this.database != null && this.database.isOpen()) {
            return;
        }
        DatabaseFactory factory = new DatabaseFactory(this.settings.databaseURL);
        if (!factory.exists()) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Database '%s' not found", null, (Object)this.settings.databaseURL);
            return;
        }
        this.logger.logLine(0, "Opening database '%s'...", this.settings.databaseURL);
        this.database = (DatabaseInternal)factory.open();
    }

    protected void printProgress() {
        if (this.settings.verboseLevel < 2) {
            return;
        }
        try {
            long deltaInSecs = (System.currentTimeMillis() - this.context.lastLapOn) / 1000L;
            if (deltaInSecs == 0L) {
                deltaInSecs = 1L;
            }
            this.logger.logLine(2, "- Status update: %,d documents (%,d/sec) - %,d vertices (%,d/sec) - %,d edges (%,d/sec)", this.context.documents.get(), (this.context.documents.get() - this.context.lastDocuments) / deltaInSecs, this.context.vertices.get(), (this.context.vertices.get() - this.context.lastVertices) / deltaInSecs, this.context.edges.get(), (this.context.edges.get() - this.context.lastEdges) / deltaInSecs);
            this.context.lastLapOn = System.currentTimeMillis();
            this.context.lastDocuments = this.context.documents.get();
            this.context.lastVertices = this.context.vertices.get();
            this.context.lastEdges = this.context.edges.get();
        }
        catch (Exception e) {
            this.logger.errorLine("Error on print statistics: " + e.getMessage(), new Object[0]);
        }
    }

    protected void closeDatabase() {
        if (this.database != null) {
            if (this.database.isTransactionActive()) {
                this.database.commit();
            }
            if (this.closeDatabaseAtEnd) {
                this.database.close();
            }
        }
    }

    protected AbstractExporterFormat createFormatImplementation() {
        switch (this.settings.format.toLowerCase(Locale.ENGLISH)) {
            case "jsonl": {
                return new JsonlExporterFormat(this.database, this.settings, this.context, this.logger);
            }
            case "graphml": {
                try {
                    Class<?> clazz = Class.forName("com.arcadedb.gremlin.integration.exporter.format.GraphMLExporterFormat");
                    return (AbstractExporterFormat)clazz.getConstructor(DatabaseInternal.class, ExporterSettings.class, ExporterContext.class, ConsoleLogger.class).newInstance(this.database, this.settings, this.context, this.logger);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    LogManager.instance().log((Object)this, Level.SEVERE, "Impossible to find exporter for 'graphml' ", (Throwable)e);
                }
            }
            case "graphson": {
                try {
                    Class<?> clazz = Class.forName("com.arcadedb.gremlin.integration.exporter.format.GraphSONExporterFormat");
                    return (AbstractExporterFormat)clazz.getConstructor(DatabaseInternal.class, ExporterSettings.class, ExporterContext.class, ConsoleLogger.class).newInstance(this.database, this.settings, this.context, this.logger);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    LogManager.instance().log((Object)this, Level.SEVERE, "Impossible to find exporter for 'graphson' ", (Throwable)e);
                }
            }
        }
        throw new ExportException("Format '" + this.settings.format + "' not supported");
    }
}

