/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.restore;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class RestoreSettings {
    public String format = "full";
    public String inputFileURL;
    public String databaseDirectory;
    public boolean overwriteDestination = false;
    public int verboseLevel = 2;
    public final Map<String, String> options = new HashMap<String, String>();

    protected void parseParameters(String[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; i += this.parseParameter(args[i].substring(1), i < args.length - 1 ? args[i + 1] : null)) {
            }
        }
        this.validate();
    }

    public int parseParameter(String name, String value) {
        if ("format".equals(name)) {
            if (value != null) {
                this.format = value.toLowerCase();
            }
        } else if ("f".equals(name)) {
            if (value != null) {
                this.inputFileURL = value;
            }
        } else if ("d".equals(name)) {
            if (value != null) {
                this.databaseDirectory = value;
            }
        } else {
            if ("o".equals(name)) {
                this.overwriteDestination = true;
                return 1;
            }
            this.options.put(name, value);
        }
        return 2;
    }

    public void validate() {
        if (this.format == null) {
            throw new IllegalArgumentException("Missing backup format");
        }
        if (this.inputFileURL == null) {
            throw new IllegalArgumentException("Missing input file url. Use -f <input-file-url>");
        }
        if (this.databaseDirectory == null) {
            throw new IllegalArgumentException("Missing database url. Use -d <database-directory>");
        }
        if (this.inputFileURL.contains("..") || this.inputFileURL.startsWith(File.separator)) {
            throw new IllegalArgumentException("Invalid backup file: cannot contain '..' or start with '/'");
        }
    }
}

