/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.restore;

import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.integration.importer.ConsoleLogger;
import com.arcadedb.integration.restore.RestoreException;
import com.arcadedb.integration.restore.RestoreSettings;
import com.arcadedb.integration.restore.format.AbstractRestoreFormat;
import com.arcadedb.integration.restore.format.FullRestoreFormat;
import java.util.Timer;

public class Restore {
    protected RestoreSettings settings = new RestoreSettings();
    protected DatabaseInternal database;
    protected Timer timer;
    protected ConsoleLogger logger;
    protected AbstractRestoreFormat formatImplementation;

    public Restore(String[] args) {
        this.settings.parseParameters(args);
    }

    public Restore(String file, String databaseURL) {
        this.settings.inputFileURL = file;
        this.settings.databaseDirectory = databaseURL;
    }

    public static void main(String[] args) {
        new Restore(args).restoreDatabase();
        System.exit(0);
    }

    public void restoreDatabase() {
        try {
            if (this.logger == null) {
                this.logger = new ConsoleLogger(this.settings.verboseLevel);
            }
            this.formatImplementation = this.createFormatImplementation();
            this.formatImplementation.restoreDatabase();
        }
        catch (Exception e) {
            throw new RestoreException("Error during restore of database from file '" + this.settings.inputFileURL + "'", e);
        }
    }

    public Restore setVerboseLevel(int verboseLevel) {
        this.settings.verboseLevel = verboseLevel;
        return this;
    }

    protected AbstractRestoreFormat createFormatImplementation() {
        switch (this.settings.format.toLowerCase()) {
            case "full": {
                return new FullRestoreFormat(this.database, this.settings, this.logger);
            }
        }
        throw new RestoreException("Format '" + this.settings.format + "' not supported");
    }
}

