/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.integration.importer.format;

import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.database.MutableDocument;
import com.arcadedb.graph.MutableVertex;
import com.arcadedb.integration.importer.AnalyzedEntity;
import com.arcadedb.integration.importer.AnalyzedSchema;
import com.arcadedb.integration.importer.ImportException;
import com.arcadedb.integration.importer.ImporterContext;
import com.arcadedb.integration.importer.ImporterSettings;
import com.arcadedb.integration.importer.Parser;
import com.arcadedb.integration.importer.SourceSchema;
import com.arcadedb.integration.importer.format.FormatImporter;
import com.arcadedb.log.LogManager;
import com.arcadedb.utility.FileUtils;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLImporterFormat
implements FormatImporter {
    @Override
    public void load(SourceSchema sourceSchema, AnalyzedEntity.ENTITY_TYPE entityType, Parser parser, DatabaseInternal database, ImporterContext context, ImporterSettings settings) throws IOException {
        try {
            int objectNestLevel = 1;
            for (Map.Entry<String, String> entry : settings.options.entrySet()) {
                if (!"objectNestLevel".equals(entry.getKey())) continue;
                objectNestLevel = Integer.parseInt(entry.getValue());
            }
            XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
            xmlFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            xmlFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            XMLStreamReader xmlReader = xmlFactory.createXMLStreamReader(parser.getInputStream());
            int nestLevel = 0;
            String entityName = null;
            String lastName = null;
            String lastContent = null;
            LinkedHashMap<String, String> object = new LinkedHashMap<String, String>();
            while (xmlReader.hasNext()) {
                int eventType = xmlReader.next();
                switch (eventType) {
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 1: {
                        if (nestLevel == objectNestLevel) {
                            entityName = "v_" + xmlReader.getName().toString();
                            for (int i = 0; i < xmlReader.getAttributeCount(); ++i) {
                                object.put(xmlReader.getAttributeName(i).toString(), xmlReader.getAttributeValue(i));
                                lastName = null;
                            }
                        } else if (nestLevel == objectNestLevel + 1) {
                            if (lastName != null) {
                                object.put(lastName, lastContent);
                            }
                            lastName = xmlReader.getName().toString();
                        }
                        ++nestLevel;
                        break;
                    }
                    case 2: {
                        if (lastName != null) {
                            object.put(lastName, lastContent);
                        }
                        LogManager.instance().log((Object)this, Level.FINE, "</%s> (nestLevel=%d)", null, (Object)xmlReader.getName(), (Object)nestLevel);
                        if (--nestLevel != objectNestLevel) break;
                        context.parsed.incrementAndGet();
                        MutableVertex record = database.newVertex(entityName);
                        record.fromMap(object);
                        database.async().createRecord((MutableDocument)record, newDocument -> context.createdVertices.incrementAndGet());
                        break;
                    }
                    case 10: {
                        LogManager.instance().log((Object)this, Level.FINE, "- attribute %s attributes=%d (nestLevel=%d)", null, (Object)xmlReader.getName(), (Object)xmlReader.getAttributeCount(), (Object)(++nestLevel));
                        break;
                    }
                    case 4: 
                    case 12: {
                        String text = xmlReader.getText();
                        if (!text.isEmpty() && !text.equals("\n")) {
                            if (settings.trimText) {
                                lastContent = text.trim();
                                break;
                            }
                            lastContent = text;
                            break;
                        }
                        lastContent = null;
                        break;
                    }
                }
                if (settings.parsingLimitEntries <= 0L || context.parsed.get() <= settings.parsingLimitEntries) continue;
                break;
            }
        }
        catch (Exception e) {
            throw new ImportException("Error on importing from source '" + parser.getSource() + "'", e);
        }
    }

    @Override
    public SourceSchema analyze(AnalyzedEntity.ENTITY_TYPE entityType, Parser parser, ImporterSettings settings, AnalyzedSchema analyzedSchema) {
        int objectNestLevel = 1;
        long analyzingLimitEntries = 0L;
        for (Map.Entry<String, String> entry : settings.options.entrySet()) {
            if ("analyzingLimitEntries".equals(entry.getKey())) {
                analyzingLimitEntries = Long.parseLong(entry.getValue());
                continue;
            }
            if (!"objectNestLevel".equals(entry.getKey())) continue;
            objectNestLevel = Integer.parseInt(entry.getValue());
        }
        long parsedObjects = 0L;
        String currentUnit = parser.isCompressed() ? "uncompressed " : "";
        String totalUnit = parser.isCompressed() ? "compressed " : "";
        try {
            parser.reset();
            XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
            xmlFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            xmlFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            XMLStreamReader xmlReader = xmlFactory.createXMLStreamReader(parser.getInputStream());
            int nestLevel = 0;
            boolean parsedStructure = false;
            String entityName = null;
            String lastName = null;
            String lastContent = null;
            while (xmlReader.hasNext()) {
                int eventType = xmlReader.next();
                switch (eventType) {
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 1: {
                        LogManager.instance().log((Object)this, Level.FINE, "<%s> attributes=%d (nestLevel=%d)", null, (Object)xmlReader.getName(), (Object)xmlReader.getAttributeCount(), (Object)nestLevel);
                        if (nestLevel == objectNestLevel) {
                            entityName = xmlReader.getName().toString();
                            for (int i = 0; i < xmlReader.getAttributeCount(); ++i) {
                                analyzedSchema.getOrCreateEntity(entityName, entityType).getOrCreateProperty(xmlReader.getAttributeName(i).toString(), xmlReader.getAttributeValue(i));
                                lastName = null;
                            }
                        } else if (nestLevel == objectNestLevel + 1) {
                            if (lastName != null) {
                                analyzedSchema.getOrCreateEntity(entityName, entityType).getOrCreateProperty(lastName, lastContent);
                            }
                            lastName = xmlReader.getName().toString();
                        }
                        ++nestLevel;
                        break;
                    }
                    case 2: {
                        if (lastName != null) {
                            analyzedSchema.getOrCreateEntity(entityName, entityType).getOrCreateProperty(lastName, lastContent);
                        }
                        LogManager.instance().log((Object)this, Level.FINE, "</%s> (nestLevel=%d)", null, (Object)xmlReader.getName(), (Object)nestLevel);
                        if (--nestLevel != objectNestLevel) break;
                        ++parsedObjects;
                        if (!parsedStructure) {
                            parsedStructure = true;
                        }
                        if (parsedObjects % 10000L != 0L) break;
                        LogManager.instance().log((Object)this, Level.INFO, "- Parsed %d XML objects (%s%s/%s%s)", null, (Object)parsedObjects, (Object)currentUnit, (Object)FileUtils.getSizeAsString((long)parser.getPosition()), (Object)totalUnit, (Object)FileUtils.getSizeAsString((long)parser.getTotal()));
                        break;
                    }
                    case 10: {
                        LogManager.instance().log((Object)this, Level.FINE, "- attribute %s attributes=%d (nestLevel=%d)", null, (Object)xmlReader.getName(), (Object)xmlReader.getAttributeCount(), (Object)(++nestLevel));
                        break;
                    }
                    case 4: 
                    case 12: {
                        String text = xmlReader.getText();
                        if (!text.isEmpty() && !text.equals("\n")) {
                            if (settings.trimText) {
                                lastContent = text.trim();
                                break;
                            }
                            lastContent = text;
                            break;
                        }
                        lastContent = null;
                        break;
                    }
                }
                if (analyzingLimitEntries <= 0L || parsedObjects <= analyzingLimitEntries) continue;
                break;
            }
        }
        catch (XMLStreamException xmlFactory) {
        }
        catch (Exception e) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Error on parsing XML", (Throwable)e);
            return null;
        }
        analyzedSchema.endParsing();
        return new SourceSchema(this, parser.getSource(), analyzedSchema);
    }

    @Override
    public String getFormat() {
        return "XML";
    }
}

